/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import weblogic.cacheprovider.coherence.CoherenceClusterDescriptorHelper;
import weblogic.coherence.descriptor.wl.WeblogicCoherenceBean;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.management.DomainDir;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.internal.PendingDirectoryManager;
import weblogic.management.mbeans.custom.ConfigurationExtension;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.management.provider.internal.DescriptorInfoUtils;
import weblogic.utils.FileUtils;
import weblogic.utils.io.StreamUtils;

public class CoherenceClusterSystemResource
extends ConfigurationExtension {
    private String _DescriptorFileName;
    private String _customConfigFile;
    private static final String DEFAULT_APPENDIX = "-coherence.xml";
    private static final String DEFAULT_CUSTOM_CONFIG_FILE_NAME = "tangosol-coherence-override.xml";

    public CoherenceClusterSystemResource(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    public static String constructDefaultCoherenceSystemFilename(String string) {
        if ((string = string.trim()).endsWith("-coherence")) {
            string = string.substring(0, string.length() - 10);
        }
        return "coherence/" + string + "/" + FileUtils.mapNameToFileName((String)string) + DEFAULT_APPENDIX;
    }

    public String getDescriptorFileName() {
        return this._DescriptorFileName;
    }

    public void setDescriptorFileName(String string) {
        String string2 = "coherence/";
        this._DescriptorFileName = string != null && this.isEdit() && !new File(string).getPath().startsWith(new File(string2).getPath()) ? string2 + string : string;
    }

    public DescriptorBean getResource() {
        return (DescriptorBean)this.getCoherenceClusterResource();
    }

    public WeblogicCoherenceBean getCoherenceClusterResource() {
        WeblogicCoherenceBean weblogicCoherenceBean = (WeblogicCoherenceBean)this.getExtensionRoot(WeblogicCoherenceBean.class, "CoherenceClusterResource", "coherence");
        if (weblogicCoherenceBean != null && this.getMbean() != null && weblogicCoherenceBean.getName() == null) {
            weblogicCoherenceBean.setName(this.getMbean().getName());
        }
        return weblogicCoherenceBean;
    }

    public String getCustomClusterConfigurationFileName() {
        WeblogicCoherenceBean weblogicCoherenceBean = this.getCoherenceClusterResource();
        if (weblogicCoherenceBean != null) {
            return weblogicCoherenceBean.getCustomClusterConfigurationFileName();
        }
        return null;
    }

    public boolean isUsingCustomClusterConfigurationFile() {
        return this.getCustomClusterConfigurationFileName() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importCustomClusterConfigurationFile(String string) throws ManagementException {
        try {
            File file = new File(string);
            if (!(file.exists() && file.isFile() && file.canRead())) {
                throw new ManagementException("Unable to read from " + file);
            }
            String string2 = file.getCanonicalPath();
            String string3 = this.getCustomClusterConfigurationFileName();
            if (string3 != null && !string3.equals(string2)) {
                throw new ManagementException("Cannot associate a new custom cluster configuration file for " + this.getName() + "." + this.getName() + " already using " + string3);
            }
            WeblogicCoherenceBean weblogicCoherenceBean = this.getCoherenceClusterResource();
            String string4 = "coherence/" + this.getName() + "/" + file.getName();
            PendingDirectoryManager pendingDirectoryManager = PendingDirectoryManager.getInstance();
            FileInputStream fileInputStream = new FileInputStream(file);
            OutputStream outputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                outputStream = pendingDirectoryManager.getFileOutputStream(string4);
                StreamUtils.writeTo((InputStream)fileInputStream, (OutputStream)outputStream);
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            this.updateCustomConfigurationFileDetails(string2);
            this._customConfigFile = string2;
        }
        catch (IOException iOException) {
            throw new ManagementException("Failed to import custom cluster configuration file for " + this.getName(), (Throwable)iOException);
        }
    }

    public void setUsingCustomClusterConfigurationFile(boolean bl) throws ManagementException {
        if (bl) {
            if (this._customConfigFile == null && !this.isUsingCustomClusterConfigurationFile()) {
                throw new ManagementException("Must import new custom cluster configuration file for " + this.getName() + ".");
            }
        } else if (this._customConfigFile != null) {
            this.updateCustomConfigurationFileDetails(null);
            this._customConfigFile = null;
        }
    }

    private void updateCustomConfigurationFileDetails(String string) {
        WeblogicCoherenceBean weblogicCoherenceBean = this.getCoherenceClusterResource();
        if (string != null) {
            weblogicCoherenceBean.setCustomClusterConfigurationFileName(string);
            weblogicCoherenceBean.setCustomClusterConfigurationFileLastUpdatedTimestamp(System.currentTimeMillis());
        } else {
            weblogicCoherenceBean.unSet("CustomClusterConfigurationFileName");
            weblogicCoherenceBean.unSet("CustomClusterConfigurationFileLastUpdatedTimestamp");
        }
    }

    public void _postCreate() {
        this.getCoherenceClusterResource();
        this._customConfigFile = this.getCustomClusterConfigurationFileName();
    }

    public void _preDestroy() {
        String[] stringArray;
        File file;
        File file2;
        ConfigurationMBean configurationMBean = this.getMbean();
        WeblogicCoherenceBean weblogicCoherenceBean = this.getCoherenceClusterResource();
        DescriptorInfoUtils.removeDescriptorInfo((DescriptorBean)weblogicCoherenceBean, configurationMBean.getDescriptor());
        if (this.isUsingCustomClusterConfigurationFile()) {
            file2 = new File(weblogicCoherenceBean.getCustomClusterConfigurationFileName());
            file = new File(DomainDir.getConfigDir() + "/" + "coherence" + "/" + weblogicCoherenceBean.getName() + "/" + file2.getName());
            if (file.exists()) {
                file.delete();
            }
        }
        if ((stringArray = (file = (file2 = new File(DomainDir.getConfigDir() + "/" + this.getDescriptorFileName())).getParentFile()).list()) == null || stringArray.length == 0) {
            file.delete();
        }
    }

    protected Descriptor loadDescriptor(DescriptorManager descriptorManager, InputStream inputStream, List list) throws Exception {
        return ((DescriptorBean)CoherenceClusterDescriptorHelper.createCoherenceDescriptor(inputStream, descriptorManager, list, true)).getDescriptor();
    }
}

