/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import weblogic.application.utils.TargetUtils;
import weblogic.j2ee.J2EEApplicationService;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.ComponentMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.deploy.internal.AppRuntimeStateManager;
import weblogic.management.deploy.internal.MBeanConverter;
import weblogic.management.descriptors.TopLevelDescriptorMBean;
import weblogic.management.provider.DomainAccess;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.management.provider.custom.ConfigurationMBeanCustomizer;
import weblogic.management.runtime.ServerLifeCycleRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.t3.srvr.T3Srvr;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.FileUtils;
import weblogic.utils.jars.VirtualJarFile;

public class Component
extends ConfigurationMBeanCustomizer {
    private static final long serialVersionUID = -2559563505270982380L;
    private static final DebugCategory DEBUGGING = Debug.getCategory((String)"weblogic.deployment");
    protected static final boolean DEBUG = DEBUGGING.isEnabled();
    private transient File compFile = null;
    private transient File tmpdir = null;
    private transient File altddFile = null;
    private boolean isArchivedEar;
    private String altDDURI = null;
    private transient ApplicationMBean applicationMBean;
    private transient AppDeploymentMBean appDeployment = null;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    TargetMBean[] targets = new TargetMBean[0];

    public Component(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    protected boolean isServerRunning() {
        T3Srvr t3Srvr = T3Srvr.getT3Srvr();
        if (t3Srvr != null) {
            return t3Srvr.getRunState() == 2;
        }
        return false;
    }

    protected boolean isPhysicalModule() {
        throw new UnsupportedOperationException("Abstract method not supported in Customizers for new bean model");
    }

    protected TopLevelDescriptorMBean readDescriptor(VirtualJarFile virtualJarFile, File file, String string) throws Exception {
        throw new UnsupportedOperationException("Abstract method not supported in Customizers for new bean model");
    }

    public boolean activated(TargetMBean targetMBean) {
        return Arrays.asList((Object[])this.getComponentMBean().getActivatedTargets()).contains(targetMBean);
    }

    private void removeTempModule() {
        if (this.isArchivedEar) {
            String[] stringArray;
            if (this.altddFile != null) {
                this.altddFile.delete();
            }
            if ((stringArray = this.tmpdir.list()) == null) {
                return;
            }
            if (stringArray.length == 1) {
                FileUtils.remove((File)this.tmpdir);
            } else {
                FileUtils.remove((File)this.compFile);
            }
        }
    }

    protected boolean containsDD(String[] stringArray, String string) {
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(string)) continue;
            return true;
        }
        return false;
    }

    private void initTempDir() throws IOException {
        if (this.tmpdir == null) {
            this.tmpdir = new File(J2EEApplicationService.getTempDir().getCanonicalPath() + File.separator + "dde" + File.separator + this.getApplication().getName());
        }
        if (!(this.tmpdir.exists() || this.tmpdir.mkdirs() || this.tmpdir.exists())) {
            throw new IOException("Failed to create tmpdir : " + this.tmpdir);
        }
    }

    protected ComponentMBean getComponentMBean() {
        return (ComponentMBean)this.getMbean();
    }

    public ApplicationMBean getApplication() {
        if (this.applicationMBean != null) {
            return this.applicationMBean;
        }
        this.setApplication((ApplicationMBean)this.getMbean().getParent());
        return this.applicationMBean;
    }

    public void setApplication(ApplicationMBean applicationMBean) {
        this.applicationMBean = applicationMBean;
        if (applicationMBean == null) {
            this.appDeployment = null;
            return;
        }
        this.appDeployment = applicationMBean.getAppDeployment();
    }

    protected AppDeploymentMBean getAppDeployment() {
        if (this.appDeployment == null) {
            this.initFromParent();
        }
        return this.appDeployment;
    }

    private void initFromParent() {
        this.applicationMBean = (ApplicationMBean)this.getMbean().getParent();
        this.setApplication(this.applicationMBean);
    }

    public void setTargets(TargetMBean[] targetMBeanArray) {
        if (this.getAppDeployment() != null) {
            MBeanConverter.setTargetsForComponent(this.getAppDeployment(), this.getComponentMBean(), targetMBeanArray);
        }
        this.putValueNotify("Targets", targetMBeanArray);
        this.targets = targetMBeanArray;
    }

    public TargetMBean[] getTargets() {
        if (this.getAppDeployment() != null) {
            return MBeanConverter.getTargetsForComponent(this.getAppDeployment(), this.getComponentMBean());
        }
        return this.targets;
    }

    public TargetMBean[] getActivatedTargets() {
        DomainAccess domainAccess = ManagementService.getDomainAccess(kernelId);
        AppRuntimeStateManager appRuntimeStateManager = AppRuntimeStateManager.getManager();
        TargetMBean[] targetMBeanArray = this.getTargets();
        HashSet<TargetMBean> hashSet = new HashSet<TargetMBean>();
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            String string;
            String string2 = targetMBeanArray[i].getName();
            if (!this.targetAlive(targetMBeanArray[i], domainAccess) || !this.compActive(string = appRuntimeStateManager.getCurrentState(this.getApplication().getName(), this.getName(), string2))) continue;
            hashSet.add(targetMBeanArray[i]);
        }
        return hashSet.toArray(new TargetMBean[0]);
    }

    private boolean targetAlive(TargetMBean targetMBean, DomainAccess domainAccess) {
        if (domainAccess != null) {
            Set set = targetMBean.getServerNames();
            for (String string : set) {
                ServerLifeCycleRuntimeMBean serverLifeCycleRuntimeMBean = domainAccess.lookupServerLifecycleRuntime(string);
                if (!this.serverAlive(serverLifeCycleRuntimeMBean)) continue;
                return true;
            }
            return false;
        }
        return TargetUtils.isDeployedLocally(new TargetMBean[]{targetMBean});
    }

    private boolean serverAlive(ServerLifeCycleRuntimeMBean serverLifeCycleRuntimeMBean) {
        return serverLifeCycleRuntimeMBean != null && ("ADMIN".equals(serverLifeCycleRuntimeMBean.getState()) || "RUNNING".equals(serverLifeCycleRuntimeMBean.getState()));
    }

    private boolean compActive(String string) {
        return "STATE_ADMIN".equals(string) || "STATE_ACTIVE".equals(string) || "STATE_UPDATE_PENDING".equals(string);
    }
}

