/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import com.bea.xml.XmlValidationError;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.descriptor.internal.DescriptorImpl;
import weblogic.logging.Loggable;
import weblogic.management.DomainDir;
import weblogic.management.ManagementLogger;
import weblogic.management.ManagementRuntimeException;
import weblogic.management.configuration.ConfigurationExtensionMBean;
import weblogic.management.internal.PendingDirectoryManager;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.management.provider.custom.ConfigurationMBeanCustomizer;
import weblogic.management.provider.internal.DescriptorInfo;
import weblogic.management.provider.internal.DescriptorInfoUtils;
import weblogic.management.provider.internal.DescriptorManagerHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class ConfigurationExtension
extends ConfigurationMBeanCustomizer {
    private static final String SCHEMA_VALIDATION_ENABLED_PROP = "weblogic.configuration.schemaValidationEnabled";
    private static final boolean schemaValidationEnabled = ConfigurationExtension.getBooleanProperty("weblogic.configuration.schemaValidationEnabled", true);
    private DescriptorBean extensionRootBean;
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public ConfigurationExtension(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    protected Descriptor loadDescriptor(DescriptorManager descriptorManager, InputStream inputStream, List list) throws Exception {
        return descriptorManager.createDescriptor(inputStream, list);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized DescriptorBean getExtensionRoot(Class clazz, String string, String string2) {
        Descriptor descriptor;
        Object object;
        if (this.extensionRootBean != null) {
            return this.extensionRootBean;
        }
        InputStream inputStream = null;
        try {
            Object object2;
            EditableDescriptorManager editableDescriptorManager;
            DescriptorImpl descriptorImpl;
            ConfigurationExtensionMBean configurationExtensionMBean;
            block32: {
                String string3;
                block30: {
                    String string4;
                    Object object3;
                    boolean bl;
                    String string5;
                    String string6;
                    PendingDirectoryManager pendingDirectoryManager;
                    block31: {
                        configurationExtensionMBean = (ConfigurationExtensionMBean)this.getMbean();
                        object = configurationExtensionMBean.getDescriptor();
                        descriptor = null;
                        pendingDirectoryManager = PendingDirectoryManager.getInstance();
                        boolean bl2 = object.isEditable();
                        descriptorImpl = (DescriptorImpl)object;
                        Map map = descriptorImpl.getContext();
                        Boolean bl3 = (Boolean)map.get("DescriptorExtensionLoad");
                        if (bl3 != null && !bl3.booleanValue()) {
                            DescriptorBean descriptorBean = null;
                            return descriptorBean;
                        }
                        string3 = configurationExtensionMBean.getDescriptorFileName();
                        String string7 = DomainDir.getConfigDir() + File.separator + string3;
                        string6 = null;
                        string5 = null;
                        if (string2 != null) {
                            string6 = string2 + File.separator + string3;
                            string5 = DomainDir.getConfigDir() + File.separator + string2 + string3;
                        }
                        editableDescriptorManager = null;
                        if (!bl2) break block30;
                        if (!configurationExtensionMBean.isSet("DescriptorFileName")) {
                            configurationExtensionMBean.setDescriptorFileName(string3);
                        }
                        editableDescriptorManager = object2 = (EditableDescriptorManager)DescriptorManagerHelper.getDescriptorManager(true);
                        bl = false;
                        Iterator iterator = DescriptorInfoUtils.getDeletedDescriptorInfos(object);
                        while (iterator != null && iterator.hasNext()) {
                            object3 = (DescriptorInfo)iterator.next();
                            string4 = ((DescriptorInfo)object3).getConfigurationExtension().getDescriptorFileName();
                            if (!string3.equals(string4)) continue;
                            bl = true;
                        }
                        if (bl || !pendingDirectoryManager.fileExists(string3) && !new File(string7).exists()) break block31;
                        inputStream = pendingDirectoryManager.getFileAsStream(string3);
                        object3 = new ArrayList();
                        descriptor = this.loadDescriptor((DescriptorManager)object2, inputStream, (List)object3);
                        this.checkErrors(string3, (ArrayList)object3);
                        break block32;
                    }
                    if (!bl && string2 != null && (pendingDirectoryManager.fileExists(string6) || new File(string5).exists())) {
                        inputStream = pendingDirectoryManager.getFileAsStream(string6);
                        object3 = new ArrayList();
                        descriptor = this.loadDescriptor((DescriptorManager)object2, inputStream, (List)object3);
                        this.checkErrors(string6, (ArrayList)object3);
                        break block32;
                    } else {
                        if (clazz == null) {
                            object3 = null;
                            return object3;
                        }
                        this.extensionRootBean = object2.createDescriptorRoot(clazz, "UTF-8").getRootBean();
                        descriptor = this.extensionRootBean.getDescriptor();
                        object3 = ManagementService.getRuntimeAccess(kernelId);
                        if (object3 != null) {
                            string4 = object3.getDomain().getDescriptor();
                            Iterator iterator = DescriptorInfoUtils.getNotFoundDescriptorInfos((Descriptor)string4);
                            while (iterator != null && iterator.hasNext()) {
                                DescriptorInfo descriptorInfo = (DescriptorInfo)iterator.next();
                                ConfigurationExtensionMBean configurationExtensionMBean2 = descriptorInfo.getConfigurationExtension();
                                if (!configurationExtensionMBean.getName().equals(configurationExtensionMBean2.getName())) continue;
                                ((DescriptorImpl)descriptor).setModified(false);
                            }
                        }
                    }
                    break block32;
                }
                object2 = DomainDir.getConfigDir() + File.separator + string3;
                inputStream = new FileInputStream((String)object2);
                editableDescriptorManager = DescriptorManagerHelper.getDescriptorManager(false);
                ArrayList arrayList = new ArrayList();
                descriptor = this.loadDescriptor((DescriptorManager)editableDescriptorManager, inputStream, arrayList);
                this.checkErrors((String)object2, arrayList);
            }
            this.extensionRootBean = descriptor.getRootBean();
            object2 = new DescriptorInfo(descriptor, clazz, this.extensionRootBean, (DescriptorManager)editableDescriptorManager, configurationExtensionMBean);
            DescriptorInfoUtils.addDescriptorInfo((DescriptorInfo)object2, descriptorImpl);
            DescriptorInfoUtils.setDescriptorConfigExtension(descriptor, configurationExtensionMBean, string);
            DescriptorBean descriptorBean = this.extensionRootBean;
            return descriptorBean;
        }
        catch (FileNotFoundException fileNotFoundException) {
            ManagementLogger.logCouldNotFindSystemResource((String)this.getMbean().getName());
            object = new DescriptorInfo(null, clazz, null, null, (ConfigurationExtensionMBean)this.getMbean());
            DescriptorInfoUtils.addNotFoundDescriptorInfo((DescriptorInfo)object, (DescriptorImpl)this.getMbean().getDescriptor());
            descriptor = null;
            return descriptor;
        }
        catch (Exception exception) {
            throw new ManagementRuntimeException(exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void checkErrors(String string, ArrayList arrayList) {
        if (arrayList.size() > 0) {
            Loggable loggable;
            for (Object object : arrayList) {
                if (object instanceof XmlValidationError) {
                    loggable = (XmlValidationError)object;
                    ManagementLogger.logConfigurationValidationProblem((String)string, (String)loggable.getMessage());
                    continue;
                }
                ManagementLogger.logConfigurationValidationProblem((String)string, (String)object.toString());
            }
            if (schemaValidationEnabled) {
                Object object;
                object = "-Dweblogic.configuration.schemaValidationEnabled=false";
                loggable = ManagementLogger.logConfigurationSchemaFailureLoggable((String)string, object);
                throw new RuntimeException(loggable.getMessage());
            }
        }
    }

    public static boolean getBooleanProperty(String string, boolean bl) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            return Boolean.parseBoolean(string2);
        }
        return bl;
    }
}

