/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import java.io.File;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorClassLoader;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.CustomResourceMBean;
import weblogic.management.internal.ManagementTextTextFormatter;
import weblogic.management.mbeans.custom.ConfigurationExtension;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.management.provider.internal.DescriptorInfoUtils;

public class CustomResource
extends ConfigurationExtension {
    private String _DescriptorFileName;

    public CustomResource(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    public String getDescriptorFileName() {
        return this._DescriptorFileName;
    }

    public void setDescriptorFileName(String string) {
        File file = null;
        if (string != null && (file = new File(string)).isAbsolute()) {
            throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getFileCannotBeAbsolute(string));
        }
        String string2 = "custom/";
        this._DescriptorFileName = string != null && this.isEdit() && file.getParent() == null ? string2 + string : string;
    }

    public DescriptorBean getResource() {
        Class<?> clazz;
        ClassLoader classLoader = DescriptorClassLoader.getClassLoader();
        CustomResourceMBean customResourceMBean = (CustomResourceMBean)this.getMbean();
        String string = customResourceMBean.getDescriptorBeanClass();
        try {
            clazz = classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
        return this.getExtensionRoot(clazz, "Resource", "custom");
    }

    public DescriptorBean getCustomResource() {
        return this.getResource();
    }

    public void _postCreate() {
        this.getResource();
    }

    public void _preDestroy() {
        ConfigurationMBean configurationMBean = this.getMbean();
        DescriptorInfoUtils.removeDescriptorInfo(this.getResource(), configurationMBean.getDescriptor());
    }
}

