/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import java.security.AccessController;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.management.RuntimeOperationsException;
import weblogic.descriptor.Descriptor;
import weblogic.management.DomainDir;
import weblogic.management.ManagementLogger;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.BasicRealmMBean;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ForeignJMSConnectionFactoryMBean;
import weblogic.management.configuration.ForeignJMSDestinationMBean;
import weblogic.management.configuration.JMSDistributedQueueMemberMBean;
import weblogic.management.configuration.JMSDistributedTopicMemberMBean;
import weblogic.management.configuration.JMSQueueMBean;
import weblogic.management.configuration.JMSSessionPoolMBean;
import weblogic.management.configuration.JMSTopicMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.SystemResourceMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.mbeans.custom.AttributeAggregator;
import weblogic.management.provider.DomainAccess;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.management.provider.custom.ConfigurationMBeanCustomizer;
import weblogic.management.provider.internal.DescriptorHelper;
import weblogic.management.runtime.ServerLifeCycleTaskRuntimeMBean;
import weblogic.management.utils.AppDeploymentHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.ServerLifecycleException;

public final class Domain
extends ConfigurationMBeanCustomizer {
    private boolean debug = false;
    private String path = null;
    static int instanceCounter = 0;
    static Map instanceMap = new HashMap();
    private boolean clusterConstraintsEnabled = false;
    private boolean productionModeEnabled = false;

    public Domain(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
        String string = System.getProperty("weblogic.ClusterConstraintsEnabled");
        if (string != null) {
            if ((string = string.toLowerCase(Locale.US)).equals("true")) {
                this.setClusterConstraintsEnabled(true);
            } else {
                this.setClusterConstraintsEnabled(false);
            }
        }
        if (this.debug) {
            instanceMap.put(this.toString(), Thread.currentThread().getStackTrace());
            System.out.println("Constructed DomainMBean customizer current count " + ++instanceCounter);
            Thread.dumpStack();
        }
    }

    public String getRootDirectory() {
        try {
            if (this.path == null) {
                this.path = DomainDir.getRootDir();
            }
        }
        catch (Exception exception) {
            ManagementLogger.logExceptionInCustomizer((Throwable)exception);
        }
        return this.path;
    }

    public boolean isClusterConstraintsEnabled() {
        return this.clusterConstraintsEnabled;
    }

    public void setClusterConstraintsEnabled(boolean bl) {
        this.clusterConstraintsEnabled = bl;
    }

    public boolean isProductionModeEnabled() {
        return this.productionModeEnabled;
    }

    public void setProductionModeEnabled(boolean bl) {
        this.productionModeEnabled = bl;
        Descriptor descriptor = ((DomainMBean)this.getMbean()).getDescriptor();
        DescriptorHelper.setDescriptorTreeProductionMode(descriptor, bl);
        DescriptorHelper.setDescriptorManagerProductionModeIfNeeded(descriptor, bl);
    }

    public void discoverManagedServers() {
    }

    public boolean discoverManagedServer(String string) {
        return false;
    }

    public Object[] getDisconnectedManagedServers() {
        return new Object[0];
    }

    public HashMap start() {
        if (this.isConfig()) {
            return null;
        }
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        DomainAccess domainAccess = ManagementService.getDomainAccess(authenticatedSubject);
        ServerMBean[] serverMBeanArray = ((DomainMBean)this.getMbean()).getServers();
        HashMap<String, ServerLifeCycleTaskRuntimeMBean> hashMap = new HashMap<String, ServerLifeCycleTaskRuntimeMBean>();
        try {
            for (int i = 0; i < serverMBeanArray.length; ++i) {
                ServerMBean serverMBean = serverMBeanArray[i];
                hashMap.put(serverMBean.getName(), domainAccess.lookupServerLifecycleRuntime(serverMBean.getName()).start());
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (ServerLifecycleException serverLifecycleException) {
            RuntimeException runtimeException = new RuntimeException(serverLifecycleException);
            throw new RuntimeOperationsException(runtimeException);
        }
        return hashMap;
    }

    public HashMap kill() {
        if (this.isConfig()) {
            return null;
        }
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        DomainAccess domainAccess = ManagementService.getDomainAccess(authenticatedSubject);
        ServerMBean[] serverMBeanArray = ((DomainMBean)this.getMbean()).getServers();
        HashMap<String, ServerLifeCycleTaskRuntimeMBean> hashMap = new HashMap<String, ServerLifeCycleTaskRuntimeMBean>();
        try {
            for (int i = 0; i < serverMBeanArray.length; ++i) {
                ServerMBean serverMBean = serverMBeanArray[i];
                hashMap.put(serverMBean.getName(), domainAccess.lookupServerLifecycleRuntime(serverMBean.getName()).forceShutdown());
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (ServerLifecycleException serverLifecycleException) {
            RuntimeException runtimeException = new RuntimeException(serverLifecycleException);
            throw new RuntimeOperationsException(runtimeException);
        }
        return hashMap;
    }

    public DeploymentMBean[] getDeployments() {
        return (DeploymentMBean[])DEPLOYMENTAGGREGATOR.instance.getAll(this.getMbean());
    }

    public BasicDeploymentMBean[] getBasicDeployments() {
        DomainMBean domainMBean = (DomainMBean)this.getMbean();
        BasicDeploymentMBean[] basicDeploymentMBeanArray = AppDeploymentHelper.getAppsAndLibs(domainMBean);
        BasicDeploymentMBean[] basicDeploymentMBeanArray2 = domainMBean.getSystemResources();
        if (basicDeploymentMBeanArray == null || basicDeploymentMBeanArray.length == 0) {
            return basicDeploymentMBeanArray2;
        }
        if (basicDeploymentMBeanArray2 == null || basicDeploymentMBeanArray2.length == 0) {
            return basicDeploymentMBeanArray;
        }
        BasicDeploymentMBean[] basicDeploymentMBeanArray3 = new BasicDeploymentMBean[basicDeploymentMBeanArray.length + basicDeploymentMBeanArray2.length];
        System.arraycopy(basicDeploymentMBeanArray2, 0, basicDeploymentMBeanArray3, 0, basicDeploymentMBeanArray2.length);
        System.arraycopy(basicDeploymentMBeanArray, 0, basicDeploymentMBeanArray3, basicDeploymentMBeanArray2.length, basicDeploymentMBeanArray.length);
        return basicDeploymentMBeanArray3;
    }

    public SystemResourceMBean[] getSystemResources() {
        return (SystemResourceMBean[])SYSTEMRESOURCEAGGREGATOR.instance.getAll(this.getMbean());
    }

    public SystemResourceMBean lookupSystemResource(String string) {
        return (SystemResourceMBean)SYSTEMRESOURCEAGGREGATOR.instance.lookup(this.getMbean(), string);
    }

    public TargetMBean[] getTargets() {
        return (TargetMBean[])TARGETAGGREGATOR.instance.getAll(this.getMbean());
    }

    public TargetMBean lookupTarget(String string) {
        return (TargetMBean)TARGETAGGREGATOR.instance.lookup(this.getMbean(), string);
    }

    public BasicRealmMBean[] getBasicRealms() {
        return (BasicRealmMBean[])BASICREALMAGGREGATOR.instance.getAll(this.getMbean());
    }

    public JMSSessionPoolMBean createJMSSessionPool(String string, JMSSessionPoolMBean jMSSessionPoolMBean) {
        JMSSessionPoolMBean jMSSessionPoolMBean2 = (JMSSessionPoolMBean)this.getMbean().createChildCopyIncludingObsolete("JMSSessionPool", jMSSessionPoolMBean);
        return jMSSessionPoolMBean2;
    }

    public ForeignJMSDestinationMBean createForeignJMSDestination(String string, ForeignJMSDestinationMBean foreignJMSDestinationMBean) {
        ForeignJMSDestinationMBean foreignJMSDestinationMBean2 = (ForeignJMSDestinationMBean)this.getMbean().createChildCopyIncludingObsolete("ForeignJMSDestination", foreignJMSDestinationMBean);
        return foreignJMSDestinationMBean2;
    }

    public ForeignJMSConnectionFactoryMBean createForeignJMSConnectionFactory(String string, ForeignJMSConnectionFactoryMBean foreignJMSConnectionFactoryMBean) {
        ForeignJMSConnectionFactoryMBean foreignJMSConnectionFactoryMBean2 = (ForeignJMSConnectionFactoryMBean)this.getMbean().createChildCopyIncludingObsolete("ForeignJMSConnectionFactory", foreignJMSConnectionFactoryMBean);
        return foreignJMSConnectionFactoryMBean2;
    }

    public JMSDistributedQueueMemberMBean createJMSDistributedQueueMember(String string, JMSDistributedQueueMemberMBean jMSDistributedQueueMemberMBean) {
        JMSDistributedQueueMemberMBean jMSDistributedQueueMemberMBean2 = (JMSDistributedQueueMemberMBean)this.getMbean().createChildCopy("JMSDistributedQueueMember", jMSDistributedQueueMemberMBean);
        return jMSDistributedQueueMemberMBean2;
    }

    public JMSDistributedTopicMemberMBean createJMSDistributedTopicMember(String string, JMSDistributedTopicMemberMBean jMSDistributedTopicMemberMBean) {
        JMSDistributedTopicMemberMBean jMSDistributedTopicMemberMBean2 = (JMSDistributedTopicMemberMBean)this.getMbean().createChildCopy("JMSDistributedTopicMember", jMSDistributedTopicMemberMBean);
        return jMSDistributedTopicMemberMBean2;
    }

    public JMSTopicMBean createJMSTopic(String string, JMSTopicMBean jMSTopicMBean) {
        JMSTopicMBean jMSTopicMBean2 = (JMSTopicMBean)this.getMbean().createChildCopyIncludingObsolete("JMSTopic", jMSTopicMBean);
        return jMSTopicMBean2;
    }

    public JMSQueueMBean createJMSQueue(String string, JMSQueueMBean jMSQueueMBean) {
        JMSQueueMBean jMSQueueMBean2 = (JMSQueueMBean)this.getMbean().createChildCopyIncludingObsolete("JMSQueue", jMSQueueMBean);
        return jMSQueueMBean2;
    }

    private static class BASICREALMAGGREGATOR {
        static AttributeAggregator instance = new AttributeAggregator("weblogic.management.configuration.DomainMBean", BasicRealmMBean.class);

        private BASICREALMAGGREGATOR() {
        }
    }

    private static class TARGETAGGREGATOR {
        static AttributeAggregator instance = new AttributeAggregator("weblogic.management.configuration.DomainMBean", TargetMBean.class);

        private TARGETAGGREGATOR() {
        }
    }

    private static class SYSTEMRESOURCEAGGREGATOR {
        static AttributeAggregator instance = new AttributeAggregator(DomainMBean.class, SystemResourceMBean.class, "getSystemResources");

        private SYSTEMRESOURCEAGGREGATOR() {
        }
    }

    private static class DEPLOYMENTAGGREGATOR {
        static AttributeAggregator instance = new AttributeAggregator(DomainMBean.class, DeploymentMBean.class, "getDeployments");

        private DEPLOYMENTAGGREGATOR() {
        }
    }
}

