/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weblogic.application.ApplicationFileManager;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.j2ee.J2EEApplicationService;
import weblogic.j2ee.J2EEUtils;
import weblogic.j2ee.descriptor.EntityBeanBean;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.ComponentMBean;
import weblogic.management.configuration.EJBComponentMBean;
import weblogic.management.descriptors.TopLevelDescriptorMBean;
import weblogic.management.mbeans.custom.Component;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.management.runtime.EJBComponentRuntimeMBean;
import weblogic.security.service.EJBResource;
import weblogic.utils.Debug;
import weblogic.utils.FileUtils;
import weblogic.utils.classloaders.ClasspathClassLoader;
import weblogic.utils.jars.JarFileObject;
import weblogic.utils.jars.VirtualJarFile;

public final class EJBComponent
extends Component {
    private static final long serialVersionUID = 5432117546996543348L;
    private List excludedResources = null;
    private List uncheckedResources = null;
    private EJBComponentRuntimeMBean compRTMBean = null;
    private EjbDescriptorBean dd = null;
    private Map remoteMethods = new HashMap();
    private Map homeMethods = new HashMap();
    private Map localMethods = new HashMap();
    private Map localHomeMethods = new HashMap();
    private boolean methodsInitialized = false;

    public EJBComponent(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    public EJBComponentRuntimeMBean getEJBComponentRuntime() {
        return this.compRTMBean;
    }

    public void setEJBComponentRuntime(EJBComponentRuntimeMBean eJBComponentRuntimeMBean) {
        this.compRTMBean = eJBComponentRuntimeMBean;
    }

    public List getExcludedEJBResources() {
        if (this.excludedResources == null) {
            this.excludedResources = new ArrayList();
        }
        return this.excludedResources;
    }

    public List getUncheckedEJBResources() {
        if (this.uncheckedResources == null) {
            this.uncheckedResources = new ArrayList();
        }
        return this.uncheckedResources;
    }

    public List getExcludedEJBResources(String string, String string2, String string3) {
        if (!this.hasExcludedEJBResources()) {
            return this.getExcludedEJBResources();
        }
        return this.getQualifiedList(string, string2, string3, this.excludedResources);
    }

    public List getUncheckedEJBResources(String string, String string2, String string3) {
        if (!this.hasUncheckedEJBResources()) {
            return this.getUncheckedEJBResources();
        }
        return this.getQualifiedList(string, string2, string3, this.uncheckedResources);
    }

    public EjbDescriptorBean getEJBDescriptor() {
        return this.dd;
    }

    public void refreshDDsIfNeeded(String[] stringArray) {
        if (this.isConfig()) {
            return;
        }
        if (stringArray == null || this.containsDD(stringArray, "ejb-jar.xml") || this.containsDD(stringArray, "weblogic-ejb-jar.xml") || this.containsDD(stringArray, "weblogic-rdbms-jar.xml")) {
            if (DEBUG) {
                Debug.say((String)"Resetting Editor and Descriptor Tree");
            }
            this.dd = null;
        }
        this.methodsInitialized = false;
    }

    private void addExcludedEJBResource(EJBResource eJBResource) {
        if (this.excludedResources == null) {
            this.excludedResources = new ArrayList();
        }
        this.excludedResources.add(eJBResource);
    }

    private void addUncheckedEJBResource(EJBResource eJBResource) {
        if (this.uncheckedResources == null) {
            this.uncheckedResources = new ArrayList();
        }
        this.uncheckedResources.add(eJBResource);
    }

    public boolean hasExcludedEJBResources() {
        if (this.excludedResources == null) {
            return false;
        }
        return this.excludedResources.size() > 0;
    }

    public boolean hasUncheckedEJBResources() {
        if (this.uncheckedResources == null) {
            return false;
        }
        return this.uncheckedResources.size() > 0;
    }

    protected TopLevelDescriptorMBean readDescriptor(VirtualJarFile virtualJarFile, File file, String string) {
        return null;
    }

    protected boolean isPhysicalModule() {
        return true;
    }

    private List getQualifiedList(String string, String string2, String string3, List list) {
        ArrayList<EJBResource> arrayList = new ArrayList<EJBResource>();
        if (list == null) {
            return arrayList;
        }
        for (EJBResource eJBResource : list) {
            if (string != null && !string.equals(eJBResource.getApplicationName()) || string2 != null && !string2.equals(eJBResource.getModuleName()) || string3 != null && !string3.equals(eJBResource.getEJBName())) continue;
            arrayList.add(eJBResource);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeMethods() throws IOException, ClassNotFoundException {
        File file;
        block17: {
            this.remoteMethods.clear();
            this.homeMethods.clear();
            this.localMethods.clear();
            this.localHomeMethods.clear();
            ApplicationMBean applicationMBean = this.getApplication();
            File file2 = new File(applicationMBean.getPath());
            file = null;
            ClasspathClassLoader classpathClassLoader = null;
            try {
                Object object;
                int n;
                ComponentMBean[] componentMBeanArray;
                Object object2;
                StringBuffer stringBuffer;
                if (applicationMBean.getDeploymentType().equals(ApplicationMBean.TYPE_EAR)) {
                    file = new File(J2EEApplicationService.getTempDir().getCanonicalPath() + File.separator + "dde" + File.separator + applicationMBean.getName());
                    file.mkdirs();
                    stringBuffer = new JarFileObject(file2);
                    stringBuffer.extract(file);
                    file2 = file;
                }
                stringBuffer = new StringBuffer();
                if (applicationMBean.isEar()) {
                    J2EEUtils.addAppInfToClasspath(stringBuffer, file2);
                    object2 = ApplicationFileManager.newInstance(file2);
                    if (((ApplicationFileManager)object2).isSplitDirectory()) {
                        J2EEUtils.addAppInfToClasspath(stringBuffer, ((ApplicationFileManager)object2).getSourcePath());
                    }
                    componentMBeanArray = applicationMBean.getComponents();
                    for (n = 0; n < componentMBeanArray.length; ++n) {
                        if (!(componentMBeanArray[n] instanceof EJBComponentMBean)) continue;
                        object = new File(file2, componentMBeanArray[n].getURI());
                        if (DEBUG) {
                            Debug.assertion((boolean)((File)object).exists());
                        }
                        stringBuffer.append(((File)object).getPath());
                        stringBuffer.append(File.pathSeparator);
                        if (!((ApplicationFileManager)object2).isSplitDirectory()) continue;
                        stringBuffer.append(new File(((ApplicationFileManager)object2).getSourcePath(), componentMBeanArray[n].getURI()));
                        stringBuffer.append(File.pathSeparator);
                    }
                } else {
                    object2 = new File(file2, this.getComponentMBean().getURI());
                    stringBuffer.append(((File)object2).getPath());
                    if (DEBUG) {
                        Debug.assertion((boolean)((File)object2).exists());
                    }
                }
                classpathClassLoader = new ClasspathClassLoader(stringBuffer.toString());
                object2 = this.dd.getEjbJarBean().getEnterpriseBeans();
                if (object2 != null) {
                    Class clazz;
                    Object object3;
                    componentMBeanArray = object2.getSessions();
                    for (n = 0; n < componentMBeanArray.length; ++n) {
                        object = componentMBeanArray[n].getEjbName();
                        if (componentMBeanArray[n].getRemote() != null) {
                            object3 = classpathClassLoader.loadClass(componentMBeanArray[n].getRemote());
                            this.remoteMethods.put(object, ((Class)object3).getMethods());
                            clazz = classpathClassLoader.loadClass(componentMBeanArray[n].getHome());
                            this.homeMethods.put(object, clazz.getMethods());
                        }
                        if (componentMBeanArray[n].getLocal() == null) continue;
                        object3 = classpathClassLoader.loadClass(componentMBeanArray[n].getLocal());
                        this.localMethods.put(object, ((Class)object3).getMethods());
                        clazz = classpathClassLoader.loadClass(componentMBeanArray[n].getLocalHome());
                        this.localHomeMethods.put(object, clazz.getMethods());
                    }
                    EntityBeanBean[] entityBeanBeanArray = object2.getEntities();
                    for (int i = 0; i < entityBeanBeanArray.length; ++i) {
                        Class clazz2;
                        object3 = entityBeanBeanArray[i].getEjbName();
                        if (entityBeanBeanArray[i].getRemote() != null) {
                            clazz = classpathClassLoader.loadClass(entityBeanBeanArray[i].getRemote());
                            this.remoteMethods.put(object3, clazz.getMethods());
                            clazz2 = classpathClassLoader.loadClass(entityBeanBeanArray[i].getHome());
                            this.homeMethods.put(object3, clazz2.getMethods());
                        }
                        if (entityBeanBeanArray[i].getLocal() == null) continue;
                        clazz = classpathClassLoader.loadClass(entityBeanBeanArray[i].getLocal());
                        this.localMethods.put(object3, clazz.getMethods());
                        clazz2 = classpathClassLoader.loadClass(entityBeanBeanArray[i].getLocalHome());
                        this.localHomeMethods.put(object3, clazz2.getMethods());
                    }
                }
                if (classpathClassLoader == null) break block17;
            }
            catch (Throwable throwable) {
                if (classpathClassLoader != null) {
                    classpathClassLoader.close();
                }
                if (file != null) {
                    FileUtils.remove(file);
                }
                throw throwable;
            }
            classpathClassLoader.close();
        }
        if (file != null) {
            FileUtils.remove((File)file);
        }
        this.methodsInitialized = true;
    }
}

