/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.management.InvalidAttributeValueException;
import weblogic.j2ee.descriptor.wl.ForeignServerBean;
import weblogic.j2ee.descriptor.wl.PropertyBean;
import weblogic.management.DistributedManagementException;
import weblogic.management.EncryptionHelper;
import weblogic.management.WebLogicMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ForeignJMSConnectionFactoryMBean;
import weblogic.management.configuration.ForeignJMSDestinationMBean;
import weblogic.management.configuration.ForeignJMSServerMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.mbeans.custom.ForeignJMSDestination;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.management.provider.custom.ConfigurationMBeanCustomizer;
import weblogic.utils.ArrayUtils;

public class ForeignJMSServer
extends ConfigurationMBeanCustomizer {
    private static final String TARGETS = "Targets";
    private transient ForeignServerBean delegate;
    private transient SubDeploymentMBean subDeployment;

    public ForeignJMSServer(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    public void useDelegates(ForeignServerBean foreignServerBean, SubDeploymentMBean subDeploymentMBean) {
        this.delegate = foreignServerBean;
        this.subDeployment = subDeploymentMBean;
    }

    public TargetMBean[] getTargets() {
        if (this.subDeployment == null) {
            TargetMBean[] targetMBeanArray = this.getValue(TARGETS);
            if (targetMBeanArray == null) {
                return new TargetMBean[0];
            }
            if (!(targetMBeanArray instanceof TargetMBean)) {
                if (!(targetMBeanArray instanceof WebLogicMBean[])) {
                    return new TargetMBean[0];
                }
                WebLogicMBean[] webLogicMBeanArray = targetMBeanArray;
                TargetMBean[] targetMBeanArray2 = new TargetMBean[webLogicMBeanArray.length];
                for (int i = 0; i < webLogicMBeanArray.length; ++i) {
                    WebLogicMBean webLogicMBean = webLogicMBeanArray[i];
                    if (!(webLogicMBean instanceof TargetMBean)) {
                        return new TargetMBean[0];
                    }
                    targetMBeanArray2[i] = (TargetMBean)webLogicMBean;
                }
                targetMBeanArray = targetMBeanArray2;
            }
            return targetMBeanArray;
        }
        return this.subDeployment.getTargets();
    }

    public void setTargets(TargetMBean[] targetMBeanArray) throws InvalidAttributeValueException, DistributedManagementException {
        if (this.subDeployment == null) {
            this.putValueNotify(TARGETS, targetMBeanArray);
        } else {
            this.subDeployment.setTargets(targetMBeanArray);
        }
    }

    public String getInitialContextFactory() {
        if (this.delegate == null) {
            Object object = this.getValue("InitialContextFactory");
            if (object == null || !(object instanceof String)) {
                return null;
            }
            return (String)object;
        }
        return this.delegate.getInitialContextFactory();
    }

    public void setInitialContextFactory(String string) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("InitialContextFactory", string);
        } else {
            this.delegate.setInitialContextFactory(string);
        }
    }

    public String getConnectionURL() {
        if (this.delegate == null) {
            Object object = this.getValue("ConnectionURL");
            if (object == null || !(object instanceof String)) {
                return null;
            }
            return (String)object;
        }
        return this.delegate.getConnectionURL();
    }

    public void setConnectionURL(String string) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("ConnectionURL", string);
        } else {
            this.delegate.setConnectionURL(string);
        }
    }

    public Properties getJNDIProperties() {
        if (this.delegate == null) {
            Object object = this.getValue("JNDIProperties");
            if (object == null || !(object instanceof Properties)) {
                return null;
            }
            return (Properties)object;
        }
        Properties properties = new Properties();
        PropertyBean[] propertyBeanArray = this.delegate.getJNDIProperties();
        if (propertyBeanArray != null) {
            for (int i = 0; i < propertyBeanArray.length; ++i) {
                PropertyBean propertyBean = propertyBeanArray[i];
                properties.setProperty(propertyBean.getKey(), propertyBean.getValue());
            }
        }
        return properties;
    }

    public void setJNDIProperties(Properties properties) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            if (properties == null) {
                return;
            }
            Properties properties2 = new Properties();
            properties2.putAll((Map<?, ?>)properties);
            String string = (String)properties2.remove("java.naming.security.credentials");
            this.putValue("JNDIProperties", properties2);
            byte[] byArray = null;
            if (string != null) {
                byArray = EncryptionHelper.encryptString(string);
                this.putValue("JNDIPropertiesCredentialEncrypted", byArray);
            }
        } else {
            Object object;
            PropertyBean[] propertyBeanArray = this.delegate.getJNDIProperties();
            for (int i = 0; i < propertyBeanArray.length; ++i) {
                object = propertyBeanArray[i];
                this.delegate.destroyJNDIProperty((PropertyBean)object);
            }
            if (properties == null) {
                return;
            }
            String string = (String)properties.remove("java.naming.security.credentials");
            object = properties.entrySet();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                Object k = entry.getKey();
                String string2 = k == null ? "" : (!(k instanceof String) ? k.toString() : (String)k);
                Object v = entry.getValue();
                String string3 = v == null ? null : (!(v instanceof String) ? v.toString() : (String)v);
                PropertyBean propertyBean = this.delegate.createJNDIProperty(string2);
                propertyBean.setValue(string3);
            }
            if (string != null) {
                this.delegate.setJNDIPropertiesCredential(string);
            }
        }
    }

    public ForeignJMSDestinationMBean[] getDestinations() {
        return ((ForeignJMSServerMBean)this.getMbean()).getForeignJMSDestinations();
    }

    void setDestinations(ForeignJMSDestinationMBean[] foreignJMSDestinationMBeanArray) {
        ArrayUtils.computeDiff((Object[])this.getDestinations(), (Object[])foreignJMSDestinationMBeanArray, (ArrayUtils.DiffHandler)new ArrayUtils.DiffHandler(){

            public void addObject(Object object) {
                ForeignJMSServer.this.addDestination((ForeignJMSDestinationMBean)object);
            }

            public void removeObject(Object object) {
                ForeignJMSServer.this.removeDestination((ForeignJMSDestinationMBean)object);
            }
        });
    }

    public boolean addDestination(ForeignJMSDestinationMBean foreignJMSDestinationMBean) {
        ForeignJMSServerMBean foreignJMSServerMBean = (ForeignJMSServerMBean)this.getMbean();
        if (foreignJMSServerMBean.lookupForeignJMSDestination(foreignJMSDestinationMBean.getName()) != null) {
            return true;
        }
        ForeignJMSDestination foreignJMSDestination = (ForeignJMSDestination)this.getMbean().createChildCopyIncludingObsolete("ForeignJMSDestination", foreignJMSDestinationMBean);
        DomainMBean domainMBean = (DomainMBean)foreignJMSServerMBean.getParentBean();
        domainMBean.destroyForeignJMSDestination(foreignJMSDestinationMBean);
        return true;
    }

    boolean removeDestination(ForeignJMSDestinationMBean foreignJMSDestinationMBean) {
        ForeignJMSServerMBean foreignJMSServerMBean = (ForeignJMSServerMBean)this.getMbean();
        DomainMBean domainMBean = (DomainMBean)foreignJMSServerMBean.getParentBean();
        if (foreignJMSServerMBean.lookupForeignJMSDestination(foreignJMSDestinationMBean.getName()) == null) {
            return true;
        }
        domainMBean.createForeignJMSDestination(foreignJMSDestinationMBean.getName(), foreignJMSDestinationMBean);
        foreignJMSServerMBean.destroyForeignJMSDestination(foreignJMSDestinationMBean);
        return true;
    }

    ForeignJMSConnectionFactoryMBean[] getConnectionFactories() {
        return ((ForeignJMSServerMBean)this.getMbean()).getForeignJMSConnectionFactories();
    }

    void setConnectionFactories(ForeignJMSConnectionFactoryMBean[] foreignJMSConnectionFactoryMBeanArray) {
        ArrayUtils.computeDiff((Object[])this.getDestinations(), (Object[])foreignJMSConnectionFactoryMBeanArray, (ArrayUtils.DiffHandler)new ArrayUtils.DiffHandler(){

            public void addObject(Object object) {
                ForeignJMSServer.this.addConnectionFactory((ForeignJMSConnectionFactoryMBean)object);
            }

            public void removeObject(Object object) {
                ForeignJMSServer.this.removeConnectionFactory((ForeignJMSConnectionFactoryMBean)object);
            }
        });
    }

    public boolean addConnectionFactory(ForeignJMSConnectionFactoryMBean foreignJMSConnectionFactoryMBean) {
        ForeignJMSServerMBean foreignJMSServerMBean = (ForeignJMSServerMBean)this.getMbean();
        if (foreignJMSServerMBean.lookupForeignJMSConnectionFactory(foreignJMSConnectionFactoryMBean.getName()) != null) {
            return true;
        }
        ForeignJMSDestination foreignJMSDestination = (ForeignJMSDestination)this.getMbean().createChildCopyIncludingObsolete("ForeignConnectionFactory", foreignJMSConnectionFactoryMBean);
        DomainMBean domainMBean = (DomainMBean)foreignJMSServerMBean.getParentBean();
        domainMBean.destroyForeignJMSConnectionFactory(foreignJMSConnectionFactoryMBean);
        return true;
    }

    boolean removeConnectionFactory(ForeignJMSConnectionFactoryMBean foreignJMSConnectionFactoryMBean) {
        ForeignJMSServerMBean foreignJMSServerMBean = (ForeignJMSServerMBean)this.getMbean();
        DomainMBean domainMBean = (DomainMBean)foreignJMSServerMBean.getParentBean();
        if (foreignJMSServerMBean.lookupForeignJMSDestination(foreignJMSConnectionFactoryMBean.getName()) == null) {
            return true;
        }
        domainMBean.createForeignJMSConnectionFactory(foreignJMSConnectionFactoryMBean.getName(), foreignJMSConnectionFactoryMBean);
        foreignJMSServerMBean.destroyForeignJMSConnectionFactory(foreignJMSConnectionFactoryMBean);
        return true;
    }

    public ForeignJMSConnectionFactoryMBean createForeignJMSConnectionFactory(String string, ForeignJMSConnectionFactoryMBean foreignJMSConnectionFactoryMBean) {
        return (ForeignJMSConnectionFactoryMBean)this.getMbean().createChildCopyIncludingObsolete("ForeignJMSConnectionFactory", foreignJMSConnectionFactoryMBean);
    }

    public ForeignJMSDestinationMBean createForeignJMSDestination(String string, ForeignJMSDestinationMBean foreignJMSDestinationMBean) {
        return (ForeignJMSDestinationMBean)this.getMbean().createChildCopyIncludingObsolete("ForeignJMSDestination", foreignJMSDestinationMBean);
    }
}

