/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import javax.management.InvalidAttributeValueException;
import weblogic.management.DistributedManagementException;
import weblogic.management.WebLogicMBean;
import weblogic.management.configuration.JDBCSystemResourceMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.management.provider.custom.ConfigurationMBeanCustomizer;

public class JDBCConfigurationMBeanCustomizer
extends ConfigurationMBeanCustomizer {
    transient JDBCSystemResourceMBean delegate;
    private static final String TARGETS = "Targets";

    public JDBCConfigurationMBeanCustomizer(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    public void setJDBCSystemResource(JDBCSystemResourceMBean jDBCSystemResourceMBean) {
        this.delegate = jDBCSystemResourceMBean;
    }

    public JDBCSystemResourceMBean getJDBCSystemResource() {
        return this.delegate;
    }

    public TargetMBean[] getTargets() {
        if (this.delegate != null) {
            return this.delegate.getTargets();
        }
        TargetMBean[] targetMBeanArray = this.getValue(TARGETS);
        if (targetMBeanArray == null) {
            return new TargetMBean[0];
        }
        if (!(targetMBeanArray instanceof TargetMBean)) {
            if (!(targetMBeanArray instanceof WebLogicMBean[])) {
                return new TargetMBean[0];
            }
            WebLogicMBean[] webLogicMBeanArray = targetMBeanArray;
            TargetMBean[] targetMBeanArray2 = new TargetMBean[webLogicMBeanArray.length];
            for (int i = 0; i < webLogicMBeanArray.length; ++i) {
                WebLogicMBean webLogicMBean = webLogicMBeanArray[i];
                if (!(webLogicMBean instanceof TargetMBean)) {
                    return new TargetMBean[0];
                }
                targetMBeanArray2[i] = (TargetMBean)webLogicMBean;
            }
            targetMBeanArray = targetMBeanArray2;
        }
        return targetMBeanArray;
    }

    public void setTargets(TargetMBean[] targetMBeanArray) throws InvalidAttributeValueException, DistributedManagementException {
        if (this.delegate != null) {
            this.delegate.setTargets(targetMBeanArray);
        }
        this.putValueNotify(TARGETS, targetMBeanArray);
    }

    private int findTargetIndex(TargetMBean[] targetMBeanArray, TargetMBean targetMBean) {
        if (targetMBean == null) {
            return -1;
        }
        String string = targetMBean.getName();
        if (string == null) {
            return -1;
        }
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            String string2;
            TargetMBean targetMBean2 = targetMBeanArray[i];
            if (targetMBean2 == null || (string2 = targetMBean2.getName()) == null || !string.equals(string2)) continue;
            return i;
        }
        return -1;
    }
}

