/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import java.security.AccessController;
import java.util.Properties;
import javax.management.InvalidAttributeValueException;
import weblogic.j2ee.descriptor.wl.JDBCPropertyBean;
import weblogic.jdbc.common.internal.JDBCMBeanConverter;
import weblogic.jdbc.common.internal.JDBCUtil;
import weblogic.management.configuration.JDBCLegalHelper;
import weblogic.management.mbeans.custom.JDBCConfigurationMBeanCustomizer;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;

public final class JDBCConnectionPool
extends JDBCConfigurationMBeanCustomizer {
    private static final AuthenticatedSubject KERNELID = JDBCConnectionPool.getKernelID();
    boolean prepStmtCacheProfilingEnabled = false;
    int prepStmtCacheProfilingThreshold = 10;
    boolean sqlStmtProfilingEnabled = false;
    boolean sqlStmtParamLoggingEnabled = false;
    boolean connLeakProfiling = false;
    boolean connProfiling = false;
    int sqlStmtMaxParamLength = 10;
    String aclName = null;
    String url = null;
    String driverName = null;
    Properties properties;
    int loginDelaySeconds = 0;
    int secondsToTrustAnIdlePoolConnection = 10;
    int initialCapacity = 1;
    int maxCapacity = 15;
    int capacityIncrement = 1;
    int shrinkFrequencySeconds = 900;
    int testFrequencySeconds = 120;
    String testTableName = null;
    boolean testConnectionsOnReserve = false;
    boolean testConnectionsOnRelease = false;
    boolean testConnectionsOnCreate = true;
    byte[] passwordEncrypted = null;
    int jdbcXADebugLevel = 10;
    boolean keepXaConnTillTxComplete = false;
    boolean needTxCtxOnClose = false;
    boolean xaEndOnlyOnce = false;
    boolean newXaConnForCommit = false;
    boolean keepLogicalConnOpenOnRelease = false;
    boolean enableResourceHealthMonitoring = true;
    boolean xaSetTransactionTimeout = false;
    int xaTransactionTimeout = 0;
    boolean recoverOnlyOnce = false;
    int connectionReserveTimeoutSeconds = 10;
    int connectionCreationRetryFrequencySeconds = 0;
    int inactiveConnectionTimeoutSeconds = 0;
    int highestNumWaiters = 0;
    int highestNumUnavailable = 0;
    String initSQL = null;
    int statementCacheSize = 10;
    String statementCacheType = "LRU";
    boolean removeInfectedConnectionsEnabled = true;
    boolean rollbackLocalTxUponConnClose = false;
    int statementTimeout = -1;
    boolean ignoreInUseConnectionsEnabled = true;
    boolean credentialMappingEnabled = false;
    int countOfTestFailuresTillFlush = 2;
    int countOfRefreshFailuresTillDisable = 2;
    String lcvStr;
    int lcv;

    private static AuthenticatedSubject getKernelID() {
        return (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }

    public JDBCConnectionPool(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    public boolean isPrepStmtCacheProfilingEnabled() {
        return this.prepStmtCacheProfilingEnabled;
    }

    public void setPrepStmtCacheProfilingEnabled(boolean bl) throws InvalidAttributeValueException {
        this.prepStmtCacheProfilingEnabled = bl;
    }

    public void setPrepStmtCacheProfilingThreshold(int n) throws InvalidAttributeValueException {
        this.prepStmtCacheProfilingThreshold = n;
    }

    public int getPrepStmtCacheProfilingThreshold() {
        return this.prepStmtCacheProfilingThreshold;
    }

    public void setSqlStmtParamLoggingEnabled(boolean bl) throws InvalidAttributeValueException {
        this.sqlStmtParamLoggingEnabled = bl;
    }

    public boolean isSqlStmtParamLoggingEnabled() {
        return this.sqlStmtParamLoggingEnabled;
    }

    public void setSqlStmtMaxParamLength(int n) throws InvalidAttributeValueException {
        this.sqlStmtMaxParamLength = n;
    }

    public int getSqlStmtMaxParamLength() {
        return this.sqlStmtMaxParamLength;
    }

    public void setConnLeakProfilingEnabled(boolean bl) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            int n = this.delegate.getJDBCResource().getJDBCConnectionPoolParams().getProfileType();
            n = bl ? (n |= 4) : (n &= 0xFFFFFFFB);
            this.delegate.getJDBCResource().getJDBCConnectionPoolParams().setProfileType(n);
        } else {
            this.connLeakProfiling = bl;
        }
    }

    public boolean isConnLeakProfilingEnabled() {
        if (this.delegate != null) {
            return (this.delegate.getJDBCResource().getJDBCConnectionPoolParams().getProfileType() & 4) > 0;
        }
        return this.connLeakProfiling;
    }

    public void setConnProfilingEnabled(boolean bl) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            int n = this.delegate.getJDBCResource().getJDBCConnectionPoolParams().getProfileType();
            n = bl ? (n |= 0x40) : (n &= 0xFFFFFFBF);
            this.delegate.getJDBCResource().getJDBCConnectionPoolParams().setProfileType(n);
        } else {
            this.connProfiling = bl;
        }
    }

    public boolean isConnProfilingEnabled() {
        if (this.delegate != null) {
            return (this.delegate.getJDBCResource().getJDBCConnectionPoolParams().getProfileType() & 0x40) > 0;
        }
        return this.connProfiling;
    }

    public void setSqlStmtProfilingEnabled(boolean bl) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            int n = this.delegate.getJDBCResource().getJDBCConnectionPoolParams().getProfileType();
            n = bl ? (n |= 0x20) : (n &= 0xFFFFFFDF);
            this.delegate.getJDBCResource().getJDBCConnectionPoolParams().setProfileType(n);
        } else {
            this.sqlStmtProfilingEnabled = bl;
        }
    }

    public boolean isSqlStmtProfilingEnabled() {
        if (this.delegate != null) {
            return (this.delegate.getJDBCResource().getJDBCConnectionPoolParams().getProfileType() & 0x20) > 0;
        }
        return this.sqlStmtProfilingEnabled;
    }

    public void setURL(String string) {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCDriverParams().setUrl(string);
        } else {
            this.url = string;
        }
    }

    public String getURL() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCDriverParams().getUrl();
        }
        return this.url;
    }

    public void setDriverName(String string) {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCDriverParams().setDriverName(string);
        } else {
            this.driverName = string;
        }
    }

    public String getDriverName() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCDriverParams().getDriverName();
        }
        return this.driverName;
    }

    public void setProperties(Properties properties) {
        if (this.delegate != null) {
            JDBCMBeanConverter.setDriverProperties(this.delegate.getJDBCResource(), properties);
        } else {
            this.properties = properties;
        }
    }

    public Properties getProperties() {
        Properties properties = this.delegate != null ? JDBCUtil.getProperties((JDBCPropertyBean[])this.delegate.getJDBCResource().getJDBCDriverParams().getProperties().getProperties()) : this.properties;
        if (properties != null && properties.getProperty("password") != null && SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNELID) != KERNELID) {
            properties = (Properties)properties.clone();
            properties.remove("password");
        }
        return properties;
    }

    public int getLoginDelaySeconds() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCConnectionPoolParams().getLoginDelaySeconds();
        }
        return this.loginDelaySeconds;
    }

    public void setLoginDelaySeconds(int n) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCConnectionPoolParams().setLoginDelaySeconds(n);
        } else {
            this.loginDelaySeconds = n;
        }
    }

    public int getSecondsToTrustAnIdlePoolConnection() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCConnectionPoolParams().getSecondsToTrustAnIdlePoolConnection();
        }
        return this.secondsToTrustAnIdlePoolConnection;
    }

    public void setSecondsToTrustAnIdlePoolConnection(int n) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCConnectionPoolParams().setSecondsToTrustAnIdlePoolConnection(n);
        } else {
            this.secondsToTrustAnIdlePoolConnection = n;
        }
    }

    public int getInitialCapacity() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCConnectionPoolParams().getInitialCapacity();
        }
        return this.initialCapacity;
    }

    public void setInitialCapacity(int n) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCConnectionPoolParams().setInitialCapacity(n);
        } else {
            this.initialCapacity = n;
        }
    }

    public int getMaxCapacity() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCConnectionPoolParams().getMaxCapacity();
        }
        return this.maxCapacity;
    }

    public void setMaxCapacity(int n) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCConnectionPoolParams().setMaxCapacity(n);
        } else {
            this.maxCapacity = n;
        }
    }

    public int getCapacityIncrement() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCConnectionPoolParams().getCapacityIncrement();
        }
        return this.capacityIncrement;
    }

    public void setCapacityIncrement(int n) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCConnectionPoolParams().setCapacityIncrement(n);
        } else {
            this.capacityIncrement = n;
        }
    }

    public void setShrinkingEnabled(boolean bl) throws InvalidAttributeValueException {
        this.lcv = bl ? 900 : 0;
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCConnectionPoolParams().setShrinkFrequencySeconds(this.lcv);
        } else {
            this.shrinkFrequencySeconds = this.lcv;
        }
    }

    public boolean isShrinkingEnabled() {
        this.lcv = this.delegate != null ? this.delegate.getJDBCResource().getJDBCConnectionPoolParams().getShrinkFrequencySeconds() : this.shrinkFrequencySeconds;
        return this.lcv > 0;
    }

    public int getShrinkPeriodMinutes() {
        this.lcv = this.delegate != null ? this.delegate.getJDBCResource().getJDBCConnectionPoolParams().getShrinkFrequencySeconds() / 60 : this.shrinkFrequencySeconds / 60;
        if (this.lcv < 1) {
            return 1;
        }
        return this.lcv;
    }

    public void setShrinkPeriodMinutes(int n) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCConnectionPoolParams().setShrinkFrequencySeconds(n * 60);
        } else {
            this.shrinkFrequencySeconds = n * 60;
        }
    }

    public int getShrinkFrequencySeconds() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCConnectionPoolParams().getShrinkFrequencySeconds();
        }
        return this.shrinkFrequencySeconds;
    }

    public void setShrinkFrequencySeconds(int n) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCConnectionPoolParams().setShrinkFrequencySeconds(n);
        } else {
            this.shrinkFrequencySeconds = n;
        }
    }

    public int getRefreshPeriodMinutes() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCConnectionPoolParams().getTestFrequencySeconds() / 60;
        }
        return this.testFrequencySeconds / 60;
    }

    public void setRefreshPeriodMinutes(int n) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCConnectionPoolParams().setTestFrequencySeconds(n * 60);
        } else {
            this.testFrequencySeconds = n * 60;
        }
    }

    public int getTestFrequencySeconds() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCConnectionPoolParams().getTestFrequencySeconds();
        }
        return this.testFrequencySeconds;
    }

    public void setTestFrequencySeconds(int n) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCConnectionPoolParams().setTestFrequencySeconds(n);
        } else {
            this.testFrequencySeconds = n;
        }
    }

    public String getTestTableName() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCConnectionPoolParams().getTestTableName();
        }
        return this.testTableName;
    }

    public void setTestTableName(String string) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCConnectionPoolParams().setTestTableName(string);
        } else {
            this.testTableName = string;
        }
    }

    public boolean getTestConnectionsOnReserve() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCConnectionPoolParams().isTestConnectionsOnReserve();
        }
        return this.testConnectionsOnReserve;
    }

    public void setTestConnectionsOnReserve(boolean bl) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCConnectionPoolParams().setTestConnectionsOnReserve(bl);
        } else {
            this.testConnectionsOnReserve = bl;
        }
    }

    public boolean getTestConnectionsOnRelease() {
        if (this.delegate != null) {
            return JDBCMBeanConverter.isInternalPropertySet(this.delegate.getJDBCResource(), "TestConnectionsOnRelease");
        }
        return this.testConnectionsOnRelease;
    }

    public void setTestConnectionsOnRelease(boolean bl) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            JDBCMBeanConverter.setInternalProperty(this.delegate.getJDBCResource(), "TestConnectionsOnRelease", Boolean.toString(bl));
        } else {
            this.testConnectionsOnRelease = bl;
        }
    }

    public boolean getTestConnectionsOnCreate() {
        if (this.delegate != null) {
            return JDBCMBeanConverter.isInternalPropertySet(this.delegate.getJDBCResource(), "TestConnectionsOnCreate");
        }
        return this.testConnectionsOnCreate;
    }

    public void setTestConnectionsOnCreate(boolean bl) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            JDBCMBeanConverter.setInternalProperty(this.delegate.getJDBCResource(), "TestConnectionsOnCreate", Boolean.toString(bl));
        } else {
            this.testConnectionsOnCreate = bl;
        }
    }

    public byte[] getPasswordEncrypted() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCDriverParams().getPasswordEncrypted();
        }
        return this.passwordEncrypted;
    }

    public void setPasswordEncrypted(byte[] byArray) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCDriverParams().setPasswordEncrypted(byArray);
        } else {
            this.passwordEncrypted = byArray;
        }
    }

    public int getJDBCXADebugLevel() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCConnectionPoolParams().getJDBCXADebugLevel();
        }
        return this.jdbcXADebugLevel;
    }

    public void setJDBCXADebugLevel(int n) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCConnectionPoolParams().setJDBCXADebugLevel(n);
        } else {
            this.jdbcXADebugLevel = n;
        }
    }

    public boolean getSupportsLocalTransaction() {
        return true;
    }

    public void setSupportsLocalTransaction(boolean bl) {
    }

    public boolean getKeepXAConnTillTxComplete() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCXAParams().isKeepXaConnTillTxComplete();
        }
        return this.keepXaConnTillTxComplete;
    }

    public void setKeepXAConnTillTxComplete(boolean bl) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCXAParams().setKeepXaConnTillTxComplete(bl);
        } else {
            this.keepXaConnTillTxComplete = bl;
        }
    }

    public boolean getNeedTxCtxOnClose() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCXAParams().isNeedTxCtxOnClose();
        }
        return this.needTxCtxOnClose;
    }

    public void setNeedTxCtxOnClose(boolean bl) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCXAParams().setNeedTxCtxOnClose(bl);
        } else {
            this.needTxCtxOnClose = bl;
        }
    }

    public boolean getXAEndOnlyOnce() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCXAParams().isXaEndOnlyOnce();
        }
        return this.xaEndOnlyOnce;
    }

    public void setXAEndOnlyOnce(boolean bl) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCXAParams().setXaEndOnlyOnce(bl);
        } else {
            this.xaEndOnlyOnce = bl;
        }
    }

    public boolean getNewXAConnForCommit() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCXAParams().isNewXaConnForCommit();
        }
        return this.newXaConnForCommit;
    }

    public void setNewXAConnForCommit(boolean bl) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCXAParams().setNewXaConnForCommit(bl);
        } else {
            this.newXaConnForCommit = bl;
        }
    }

    public boolean getKeepLogicalConnOpenOnRelease() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCXAParams().isKeepLogicalConnOpenOnRelease();
        }
        return this.keepLogicalConnOpenOnRelease;
    }

    public void setKeepLogicalConnOpenOnRelease(boolean bl) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCXAParams().setKeepLogicalConnOpenOnRelease(bl);
        } else {
            this.keepLogicalConnOpenOnRelease = bl;
        }
    }

    public int getXAPreparedStatementCacheSize() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCConnectionPoolParams().getStatementCacheSize();
        }
        return this.statementCacheSize;
    }

    public void setXAPreparedStatementCacheSize(int n) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCConnectionPoolParams().setStatementCacheSize(n);
        } else {
            this.statementCacheSize = n;
        }
    }

    public int getPreparedStatementCacheSize() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCConnectionPoolParams().getStatementCacheSize();
        }
        return this.statementCacheSize;
    }

    public void setPreparedStatementCacheSize(int n) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCConnectionPoolParams().setStatementCacheSize(n);
        } else {
            this.statementCacheSize = n;
        }
    }

    public boolean getEnableResourceHealthMonitoring() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCXAParams().isResourceHealthMonitoring();
        }
        return this.enableResourceHealthMonitoring;
    }

    public void setEnableResourceHealthMonitoring(boolean bl) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCXAParams().setResourceHealthMonitoring(bl);
        } else {
            this.enableResourceHealthMonitoring = bl;
        }
    }

    public boolean getRecoverOnlyOnce() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCXAParams().isRecoverOnlyOnce();
        }
        return this.recoverOnlyOnce;
    }

    public void setRecoverOnlyOnce(boolean bl) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCXAParams().setRecoverOnlyOnce(bl);
        } else {
            this.recoverOnlyOnce = bl;
        }
    }

    public boolean getXASetTransactionTimeout() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCXAParams().isXaSetTransactionTimeout();
        }
        return this.xaSetTransactionTimeout;
    }

    public void setXASetTransactionTimeout(boolean bl) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCXAParams().setXaSetTransactionTimeout(bl);
        } else {
            this.xaSetTransactionTimeout = bl;
        }
    }

    public int getConnectionReserveTimeoutSeconds() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCConnectionPoolParams().getConnectionReserveTimeoutSeconds();
        }
        return this.connectionReserveTimeoutSeconds;
    }

    public void setConnectionReserveTimeoutSeconds(int n) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCConnectionPoolParams().setConnectionReserveTimeoutSeconds(n);
        } else {
            this.connectionReserveTimeoutSeconds = n;
        }
    }

    public int getConnectionCreationRetryFrequencySeconds() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCConnectionPoolParams().getConnectionCreationRetryFrequencySeconds();
        }
        return this.connectionCreationRetryFrequencySeconds;
    }

    public void setConnectionCreationRetryFrequencySeconds(int n) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCConnectionPoolParams().setConnectionCreationRetryFrequencySeconds(n);
        } else {
            this.connectionCreationRetryFrequencySeconds = n;
        }
    }

    public int getInactiveConnectionTimeoutSeconds() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCConnectionPoolParams().getInactiveConnectionTimeoutSeconds();
        }
        return this.inactiveConnectionTimeoutSeconds;
    }

    public void setInactiveConnectionTimeoutSeconds(int n) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCConnectionPoolParams().setInactiveConnectionTimeoutSeconds(n);
        } else {
            this.inactiveConnectionTimeoutSeconds = n;
        }
    }

    public int getHighestNumWaiters() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCConnectionPoolParams().getHighestNumWaiters();
        }
        return this.highestNumWaiters;
    }

    public void setHighestNumWaiters(int n) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCConnectionPoolParams().setHighestNumWaiters(n);
        } else {
            this.highestNumWaiters = n;
        }
    }

    public int getHighestNumUnavailable() {
        if (this.delegate != null) {
            JDBCPropertyBean jDBCPropertyBean = this.delegate.getJDBCResource().getInternalProperties().lookupProperty("HighestNumUnavailable");
            if (jDBCPropertyBean != null) {
                return Integer.parseInt(jDBCPropertyBean.getValue());
            }
            return 0;
        }
        return this.highestNumUnavailable;
    }

    public void setHighestNumUnavailable(int n) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            JDBCMBeanConverter.setInternalProperty(this.delegate.getJDBCResource(), "HighestNumUnavailable", Integer.toString(n));
        } else {
            this.highestNumUnavailable = n;
        }
    }

    public void setInitSQL(String string) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCConnectionPoolParams().setInitSql(string);
        } else {
            this.initSQL = string;
        }
    }

    public String getInitSQL() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCConnectionPoolParams().getInitSql();
        }
        return this.initSQL;
    }

    public void setStatementCacheSize(int n) {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCConnectionPoolParams().setStatementCacheSize(n);
        } else {
            this.statementCacheSize = n;
        }
    }

    public int getStatementCacheSize() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCConnectionPoolParams().getStatementCacheSize();
        }
        return this.statementCacheSize;
    }

    public void setStatementCacheType(String string) {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCConnectionPoolParams().setStatementCacheType(string);
        } else {
            this.statementCacheType = string;
        }
    }

    public String getStatementCacheType() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCConnectionPoolParams().getStatementCacheType();
        }
        return this.statementCacheType;
    }

    public void setRemoveInfectedConnectionsEnabled(boolean bl) {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCConnectionPoolParams().setRemoveInfectedConnections(bl);
        } else {
            this.removeInfectedConnectionsEnabled = bl;
        }
    }

    public boolean isRemoveInfectedConnectionsEnabled() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCConnectionPoolParams().isRemoveInfectedConnections();
        }
        return this.removeInfectedConnectionsEnabled;
    }

    public void setRollbackLocalTxUponConnClose(boolean bl) {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCXAParams().setRollbackLocalTxUponConnClose(bl);
        } else {
            this.rollbackLocalTxUponConnClose = bl;
        }
    }

    public boolean getRollbackLocalTxUponConnClose() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCXAParams().isRollbackLocalTxUponConnClose();
        }
        return this.rollbackLocalTxUponConnClose;
    }

    public void setTestStatementTimeout(int n) {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCConnectionPoolParams().setStatementTimeout(n);
        } else {
            this.statementTimeout = n;
        }
    }

    public int getTestStatementTimeout() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCConnectionPoolParams().getStatementTimeout();
        }
        return this.statementTimeout;
    }

    public void setStatementTimeout(int n) {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCConnectionPoolParams().setStatementTimeout(n);
        } else {
            this.statementTimeout = n;
        }
    }

    public int getStatementTimeout() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCConnectionPoolParams().getStatementTimeout();
        }
        return this.statementTimeout;
    }

    public void setIgnoreInUseConnectionsEnabled(boolean bl) {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCConnectionPoolParams().setIgnoreInUseConnectionsEnabled(bl);
        } else {
            this.ignoreInUseConnectionsEnabled = bl;
        }
    }

    public boolean isIgnoreInUseConnectionsEnabled() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCConnectionPoolParams().isIgnoreInUseConnectionsEnabled();
        }
        return this.ignoreInUseConnectionsEnabled;
    }

    public void setCredentialMappingEnabled(boolean bl) {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCConnectionPoolParams().setCredentialMappingEnabled(bl);
        } else {
            this.credentialMappingEnabled = bl;
        }
    }

    public boolean isCredentialMappingEnabled() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCConnectionPoolParams().isCredentialMappingEnabled();
        }
        return this.credentialMappingEnabled;
    }

    public int getCountOfTestFailuresTillFlush() {
        if (this.delegate != null) {
            JDBCPropertyBean jDBCPropertyBean = this.delegate.getJDBCResource().getInternalProperties().lookupProperty("CountOfTestFailuresTillFlush");
            if (jDBCPropertyBean != null) {
                return Integer.parseInt(jDBCPropertyBean.getValue());
            }
            return JDBCLegalHelper.computeCountTillFlush((int)this.getTestFrequencySeconds(), (int)this.getMaxCapacity());
        }
        return this.countOfTestFailuresTillFlush;
    }

    public void setCountOfTestFailuresTillFlush(int n) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            JDBCMBeanConverter.setInternalProperty(this.delegate.getJDBCResource(), "CountOfTestFailuresTillFlush", Integer.toString(n));
        } else {
            this.countOfTestFailuresTillFlush = n;
        }
    }

    public int getCountOfRefreshFailuresTillDisable() {
        if (this.delegate != null) {
            JDBCPropertyBean jDBCPropertyBean = this.delegate.getJDBCResource().getInternalProperties().lookupProperty("CountOfRefreshFailuresTillDisable");
            if (jDBCPropertyBean != null) {
                return Integer.parseInt(jDBCPropertyBean.getValue());
            }
            return 2;
        }
        return this.countOfRefreshFailuresTillDisable;
    }

    public void setCountOfRefreshFailuresTillDisable(int n) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            JDBCMBeanConverter.setInternalProperty(this.delegate.getJDBCResource(), "CountOfRefreshFailuresTillDisable", Integer.toString(n));
        } else {
            this.countOfRefreshFailuresTillDisable = n;
        }
    }
}

