/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import java.util.StringTokenizer;
import javax.management.InvalidAttributeValueException;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JDBCConnectionPoolMBean;
import weblogic.management.mbeans.custom.JDBCConfigurationMBeanCustomizer;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;

public final class JDBCMultiPool
extends JDBCConfigurationMBeanCustomizer {
    private transient JDBCConnectionPoolMBean[] poolList;
    private String algorithm = "High-Availability";
    private String connectionPoolFailoverCallbackHandler = null;
    private boolean failoverRequestIfBusy = false;
    private int healthCheckFrequencySeconds = 300;

    public JDBCMultiPool(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    public JDBCConnectionPoolMBean[] getPoolList() {
        if (this.delegate != null) {
            String string = this.delegate.getJDBCResource().getJDBCDataSourceParams().getDataSourceList();
            if (string == null) {
                return new JDBCConnectionPoolMBean[0];
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            JDBCConnectionPoolMBean[] jDBCConnectionPoolMBeanArray = new JDBCConnectionPoolMBean[stringTokenizer.countTokens()];
            int n = 0;
            DomainMBean domainMBean = (DomainMBean)this.getMbean().getParent();
            JDBCConnectionPoolMBean[] jDBCConnectionPoolMBeanArray2 = domainMBean.getJDBCConnectionPools();
            block0: while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                for (int i = 0; i < jDBCConnectionPoolMBeanArray2.length; ++i) {
                    JDBCConnectionPoolMBean jDBCConnectionPoolMBean = jDBCConnectionPoolMBeanArray2[i];
                    if (jDBCConnectionPoolMBean == null || !string2.equals(jDBCConnectionPoolMBean.getName())) continue;
                    jDBCConnectionPoolMBeanArray[n++] = jDBCConnectionPoolMBean;
                    continue block0;
                }
            }
            if (n == 0) {
                return new JDBCConnectionPoolMBean[0];
            }
            return jDBCConnectionPoolMBeanArray;
        }
        if (this.poolList == null) {
            return new JDBCConnectionPoolMBean[0];
        }
        return this.poolList;
    }

    public void setPoolList(JDBCConnectionPoolMBean[] jDBCConnectionPoolMBeanArray) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            int n;
            String string = null;
            if (jDBCConnectionPoolMBeanArray != null && (n = jDBCConnectionPoolMBeanArray.length) > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(jDBCConnectionPoolMBeanArray[i].getName());
                    stringBuffer.append(",");
                }
                stringBuffer.deleteCharAt(stringBuffer.lastIndexOf(","));
                string = stringBuffer.toString();
            }
            this.delegate.getJDBCResource().getJDBCDataSourceParams().setDataSourceList(string);
        } else {
            this.poolList = jDBCConnectionPoolMBeanArray;
        }
    }

    public void setAlgorithmType(String string) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            if ("High-Availability".equals(string)) {
                this.delegate.getJDBCResource().getJDBCDataSourceParams().setAlgorithmType("Failover");
            } else {
                this.delegate.getJDBCResource().getJDBCDataSourceParams().setAlgorithmType(string);
            }
        } else {
            this.algorithm = string;
        }
    }

    public String getAlgorithmType() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCDataSourceParams().getAlgorithmType();
        }
        return this.algorithm;
    }

    public String getConnectionPoolFailoverCallbackHandler() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCDataSourceParams().getConnectionPoolFailoverCallbackHandler();
        }
        return this.connectionPoolFailoverCallbackHandler;
    }

    public void setConnectionPoolFailoverCallbackHandler(String string) {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCDataSourceParams().setConnectionPoolFailoverCallbackHandler(string);
        } else {
            this.connectionPoolFailoverCallbackHandler = string;
        }
    }

    public boolean getFailoverRequestIfBusy() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCDataSourceParams().isFailoverRequestIfBusy();
        }
        return this.failoverRequestIfBusy;
    }

    public void setFailoverRequestIfBusy(boolean bl) {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCDataSourceParams().setFailoverRequestIfBusy(bl);
        } else {
            this.failoverRequestIfBusy = bl;
        }
    }

    public void setHealthCheckFrequencySeconds(int n) {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCConnectionPoolParams().setTestFrequencySeconds(n);
        } else {
            this.healthCheckFrequencySeconds = n;
        }
    }

    public int getHealthCheckFrequencySeconds() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCConnectionPoolParams().getTestFrequencySeconds();
        }
        return this.healthCheckFrequencySeconds;
    }
}

