/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import java.util.StringTokenizer;
import javax.management.InvalidAttributeValueException;
import weblogic.j2ee.descriptor.wl.JDBCPropertyBean;
import weblogic.jdbc.common.internal.JDBCMBeanConverter;
import weblogic.management.mbeans.custom.JDBCConfigurationMBeanCustomizer;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;

public final class JDBCTxDataSource
extends JDBCConfigurationMBeanCustomizer {
    private String jndiName = null;
    private String jndiNameSeparator = ";";
    private String poolName = null;
    private boolean emulate2PC = false;
    private boolean rowPrefetch = false;
    private int rowPrefetchSize = 48;
    private int streamChunkSize = 256;

    public JDBCTxDataSource(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    public void setJNDIName(String string) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            if (string == null) {
                return;
            }
            String string2 = this.getJNDINameSeparator();
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n++] = stringTokenizer.nextToken();
            }
            this.delegate.getJDBCResource().getJDBCDataSourceParams().setJNDINames(stringArray);
        } else {
            this.jndiName = string;
        }
    }

    public String getJNDIName() {
        if (this.delegate != null) {
            String[] stringArray = this.delegate.getJDBCResource().getJDBCDataSourceParams().getJNDINames();
            if (stringArray == null || stringArray.length == 0) {
                return null;
            }
            String string = this.getJNDINameSeparator();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                stringBuffer.append(string);
            }
            stringBuffer.deleteCharAt(stringBuffer.lastIndexOf(string));
            return stringBuffer.toString();
        }
        return this.jndiName;
    }

    public void setJNDINameSeparator(String string) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            JDBCMBeanConverter.setInternalProperty(this.delegate.getJDBCResource(), "JNDINameSeparator", string);
        } else {
            this.jndiNameSeparator = string;
        }
    }

    public String getJNDINameSeparator() {
        if (this.delegate != null) {
            JDBCPropertyBean jDBCPropertyBean = this.delegate.getJDBCResource().getInternalProperties().lookupProperty("JNDINameSeparator");
            if (jDBCPropertyBean != null) {
                return jDBCPropertyBean.getValue();
            }
            return ";";
        }
        return this.jndiNameSeparator;
    }

    public void setPoolName(String string) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            JDBCMBeanConverter.setInternalProperty(this.delegate.getJDBCResource(), "LegacyPoolName", string);
        } else {
            this.poolName = string;
        }
    }

    public String getPoolName() {
        if (this.delegate != null) {
            if (JDBCMBeanConverter.getLegacyType(this.delegate.getJDBCResource()) == 0) {
                return this.delegate.getJDBCResource().getName();
            }
            return JDBCMBeanConverter.getInternalProperty(this.delegate.getJDBCResource(), "LegacyPoolName");
        }
        return this.poolName;
    }

    public boolean getEnableTwoPhaseCommit() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCDataSourceParams().getGlobalTransactionsProtocol().equals("EmulateTwoPhaseCommit");
        }
        return this.emulate2PC;
    }

    public void setEnableTwoPhaseCommit(boolean bl) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            if (bl) {
                this.delegate.getJDBCResource().getJDBCDataSourceParams().setGlobalTransactionsProtocol("EmulateTwoPhaseCommit");
            } else {
                this.delegate.getJDBCResource().getJDBCDataSourceParams().setGlobalTransactionsProtocol("OnePhaseCommit");
            }
        } else {
            this.emulate2PC = bl;
        }
    }

    public boolean isRowPrefetchEnabled() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCDataSourceParams().isRowPrefetch();
        }
        return this.rowPrefetch;
    }

    public void setRowPrefetchEnabled(boolean bl) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCDataSourceParams().setRowPrefetch(bl);
        } else {
            this.rowPrefetch = bl;
        }
    }

    public int getRowPrefetchSize() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCDataSourceParams().getRowPrefetchSize();
        }
        return this.rowPrefetchSize;
    }

    public void setRowPrefetchSize(int n) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCDataSourceParams().setRowPrefetchSize(n);
        } else {
            this.rowPrefetchSize = n;
        }
    }

    public int getStreamChunkSize() {
        if (this.delegate != null) {
            return this.delegate.getJDBCResource().getJDBCDataSourceParams().getStreamChunkSize();
        }
        return this.streamChunkSize;
    }

    public void setStreamChunkSize(int n) throws InvalidAttributeValueException {
        if (this.delegate != null) {
            this.delegate.getJDBCResource().getJDBCDataSourceParams().setStreamChunkSize(n);
        } else {
            this.streamChunkSize = n;
        }
    }
}

