/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import javax.management.InvalidAttributeValueException;
import weblogic.j2ee.descriptor.wl.JMSConnectionFactoryBean;
import weblogic.jms.JMSLogger;
import weblogic.management.DistributedManagementException;
import weblogic.management.WebLogicMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.management.provider.custom.ConfigurationMBeanCustomizer;

public class JMSConnectionFactory
extends ConfigurationMBeanCustomizer {
    private static final String TARGETS = "Targets";
    private transient JMSConnectionFactoryBean delegate;
    private transient SubDeploymentMBean subDeployment;

    public JMSConnectionFactory(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    public void useDelegates(JMSConnectionFactoryBean jMSConnectionFactoryBean, SubDeploymentMBean subDeploymentMBean) {
        this.delegate = jMSConnectionFactoryBean;
        this.subDeployment = subDeploymentMBean;
    }

    public TargetMBean[] getTargets() {
        if (this.subDeployment == null) {
            TargetMBean[] targetMBeanArray = this.getValue(TARGETS);
            if (targetMBeanArray == null) {
                return new TargetMBean[0];
            }
            if (!(targetMBeanArray instanceof TargetMBean)) {
                if (!(targetMBeanArray instanceof WebLogicMBean[])) {
                    return new TargetMBean[0];
                }
                WebLogicMBean[] webLogicMBeanArray = targetMBeanArray;
                TargetMBean[] targetMBeanArray2 = new TargetMBean[webLogicMBeanArray.length];
                for (int i = 0; i < webLogicMBeanArray.length; ++i) {
                    WebLogicMBean webLogicMBean = webLogicMBeanArray[i];
                    if (!(webLogicMBean instanceof TargetMBean)) {
                        return new TargetMBean[0];
                    }
                    targetMBeanArray2[i] = (TargetMBean)webLogicMBean;
                }
                targetMBeanArray = targetMBeanArray2;
            }
            return targetMBeanArray;
        }
        return this.subDeployment.getTargets();
    }

    public void setTargets(TargetMBean[] targetMBeanArray) throws InvalidAttributeValueException, DistributedManagementException {
        if (this.subDeployment == null) {
            this.putValueNotify(TARGETS, targetMBeanArray);
        } else {
            this.subDeployment.setTargets(targetMBeanArray);
        }
    }

    public String getJNDIName() {
        if (this.delegate == null) {
            Object object = this.getValue("JNDIName");
            if (object == null || !(object instanceof String)) {
                return null;
            }
            return (String)object;
        }
        return this.delegate.getJNDIName();
    }

    public void setJNDIName(String string) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("JNDIName", string);
        } else {
            this.delegate.setJNDIName(string);
        }
    }

    public String getClientId() {
        if (this.delegate == null) {
            Object object = this.getValue("ClientId");
            if (object == null || !(object instanceof String)) {
                return null;
            }
            return (String)object;
        }
        return this.delegate.getClientParams().getClientId();
    }

    public void setClientId(String string) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("ClientId", string);
        } else {
            this.delegate.getClientParams().setClientId(string);
        }
    }

    public String getAcknowledgePolicy() {
        if (this.delegate == null) {
            Object object = this.getValue("AcknowledgePolicy");
            if (object == null || !(object instanceof String)) {
                return "All";
            }
            return (String)object;
        }
        return this.delegate.getClientParams().getAcknowledgePolicy();
    }

    public void setAcknowledgePolicy(String string) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("AcknowledgePolicy", string);
        } else {
            this.delegate.getClientParams().setAcknowledgePolicy(string);
        }
    }

    public boolean getAllowCloseInOnMessage() {
        if (this.delegate == null) {
            Object object = this.getValue("AllowCloseInOnMessage");
            if (object == null || !(object instanceof Boolean)) {
                return false;
            }
            return (Boolean)object;
        }
        return this.delegate.getClientParams().isAllowCloseInOnMessage();
    }

    public void setAllowCloseInOnMessage(boolean bl) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("AllowCloseInOnMessage", new Boolean(bl));
        } else {
            this.delegate.getClientParams().setAllowCloseInOnMessage(bl);
        }
    }

    public int getMessagesMaximum() {
        if (this.delegate == null) {
            Object object = this.getValue("MessagesMaximum");
            if (object == null || !(object instanceof Integer)) {
                return 10;
            }
            return (Integer)object;
        }
        return this.delegate.getClientParams().getMessagesMaximum();
    }

    public void setMessagesMaximum(int n) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("MessagesMaximum", new Integer(n));
        } else {
            this.delegate.getClientParams().setMessagesMaximum(n);
        }
    }

    public String getOverrunPolicy() {
        if (this.delegate == null) {
            Object object = this.getValue("OverrunPolicy");
            if (object == null || !(object instanceof String)) {
                return "KeepOld";
            }
            return (String)object;
        }
        return this.delegate.getClientParams().getMulticastOverrunPolicy();
    }

    public void setOverrunPolicy(String string) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("OverrunPolicy", string);
        } else {
            this.delegate.getClientParams().setMulticastOverrunPolicy(string);
        }
    }

    public int getDefaultPriority() {
        if (this.delegate == null) {
            Object object = this.getValue("DefaultPriority");
            if (object == null || !(object instanceof Integer)) {
                return 4;
            }
            return (Integer)object;
        }
        return this.delegate.getDefaultDeliveryParams().getDefaultPriority();
    }

    public void setDefaultPriority(int n) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("DefaultPriority", new Integer(n));
        } else {
            this.delegate.getDefaultDeliveryParams().setDefaultPriority(n);
        }
    }

    public long getDefaultTimeToDeliver() {
        if (this.delegate == null) {
            Object object = this.getValue("DefaultTimeToDeliver");
            if (object == null || !(object instanceof Long)) {
                return 0L;
            }
            return (Long)object;
        }
        Long l = new Long(this.delegate.getDefaultDeliveryParams().getDefaultTimeToDeliver());
        return l;
    }

    public void setDefaultTimeToDeliver(long l) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("DefaultTimeToDeliver", new Long(l));
        } else {
            this.delegate.getDefaultDeliveryParams().setDefaultTimeToDeliver("" + l);
        }
    }

    public long getDefaultTimeToLive() {
        if (this.delegate == null) {
            Object object = this.getValue("DefaultTimeToLive");
            if (object == null || !(object instanceof Long)) {
                return 0L;
            }
            return (Long)object;
        }
        return this.delegate.getDefaultDeliveryParams().getDefaultTimeToLive();
    }

    public void setDefaultTimeToLive(long l) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("DefaultTimeToLive", new Long(l));
        } else {
            this.delegate.getDefaultDeliveryParams().setDefaultTimeToLive(l);
        }
    }

    public long getSendTimeout() {
        if (this.delegate == null) {
            Object object = this.getValue("SendTimeout");
            if (object == null || !(object instanceof Long)) {
                return 10L;
            }
            return (Long)object;
        }
        return this.delegate.getDefaultDeliveryParams().getSendTimeout();
    }

    public void setSendTimeout(long l) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("SendTimeout", new Long(l));
        } else {
            this.delegate.getDefaultDeliveryParams().setSendTimeout(l);
        }
    }

    public String getDefaultDeliveryMode() {
        if (this.delegate == null) {
            Object object = this.getValue("DefaultDeliveryMode");
            if (object == null || !(object instanceof String)) {
                return "Persistent";
            }
            return (String)object;
        }
        return this.delegate.getDefaultDeliveryParams().getDefaultDeliveryMode();
    }

    public void setDefaultDeliveryMode(String string) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("DefaultDeliveryMode", string);
        } else {
            this.delegate.getDefaultDeliveryParams().setDefaultDeliveryMode(string);
        }
    }

    public long getDefaultRedeliveryDelay() {
        if (this.delegate == null) {
            Object object = this.getValue("DefaultRedeliveryDelay");
            if (object == null || !(object instanceof Long)) {
                return 0L;
            }
            return (Long)object;
        }
        return this.delegate.getDefaultDeliveryParams().getDefaultRedeliveryDelay();
    }

    public void setDefaultRedeliveryDelay(long l) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("DefaultRedeliveryDelay", new Long(l));
        } else {
            this.delegate.getDefaultDeliveryParams().setDefaultRedeliveryDelay(l);
        }
    }

    public long getTransactionTimeout() {
        if (this.delegate == null) {
            Object object = this.getValue("TransactionTimeout");
            if (object == null || !(object instanceof Long)) {
                return 3600L;
            }
            return (Long)object;
        }
        return this.delegate.getTransactionParams().getTransactionTimeout();
    }

    public void setTransactionTimeout(long l) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("TransactionTimeout", new Long(l));
        } else {
            this.delegate.getTransactionParams().setTransactionTimeout(l);
        }
    }

    public boolean isUserTransactionsEnabled() {
        if (this.delegate == null) {
            Object object = this.getValue("UserTransactionsEnabled");
            if (object == null || !(object instanceof Boolean)) {
                return false;
            }
            return (Boolean)object;
        }
        return this.delegate.getTransactionParams().isXAConnectionFactoryEnabled();
    }

    public void setUserTransactionsEnabled(boolean bl) throws InvalidAttributeValueException {
        if (bl) {
            JMSLogger.logUserTransactionsEnabledDeprecated((String)this.getMbean().getName());
        }
        if (this.delegate == null) {
            this.putValue("UserTransactionsEnabled", new Boolean(bl));
        } else {
            this.delegate.getTransactionParams().setXAConnectionFactoryEnabled(bl);
        }
    }

    public boolean isXAConnectionFactoryEnabled() {
        if (this.delegate == null) {
            Object object = this.getValue("XAConnectionFactoryEnabled");
            if (object == null || !(object instanceof Boolean)) {
                return false;
            }
            return (Boolean)object;
        }
        return this.delegate.getTransactionParams().isXAConnectionFactoryEnabled();
    }

    public void setXAConnectionFactoryEnabled(boolean bl) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("XAConnectionFactoryEnabled", new Boolean(bl));
        } else {
            this.delegate.getTransactionParams().setXAConnectionFactoryEnabled(bl);
        }
    }

    public boolean isXAServerEnabled() {
        if (this.delegate == null) {
            Object object = this.getValue("XAServerEnabled");
            if (object == null || !(object instanceof Boolean)) {
                return false;
            }
            return (Boolean)object;
        }
        return this.delegate.getTransactionParams().isXAConnectionFactoryEnabled();
    }

    public void setXAServerEnabled(boolean bl) throws InvalidAttributeValueException {
        if (bl) {
            JMSLogger.logXAServerEnabledDeprecated((String)this.getMbean().getName());
        }
        if (this.delegate == null) {
            this.putValue("XAServerEnabled", new Boolean(bl));
        } else {
            this.delegate.getTransactionParams().setXAConnectionFactoryEnabled(bl);
        }
    }

    public boolean getLoadBalancingEnabled() {
        if (this.delegate == null) {
            Object object = this.getValue("LoadBalancingEnabled");
            if (object == null || !(object instanceof Boolean)) {
                return true;
            }
            return (Boolean)object;
        }
        return this.delegate.getLoadBalancingParams().isLoadBalancingEnabled();
    }

    public void setLoadBalancingEnabled(boolean bl) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("LoadBalancingEnabled", new Boolean(bl));
        } else {
            this.delegate.getLoadBalancingParams().setLoadBalancingEnabled(bl);
        }
    }

    public boolean getServerAffinityEnabled() {
        if (this.delegate == null) {
            Object object = this.getValue("ServerAffinityEnabled");
            if (object == null || !(object instanceof Boolean)) {
                return true;
            }
            return (Boolean)object;
        }
        return this.delegate.getLoadBalancingParams().isServerAffinityEnabled();
    }

    public void setServerAffinityEnabled(boolean bl) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("ServerAffinityEnabled", new Boolean(bl));
        } else {
            this.delegate.getLoadBalancingParams().setServerAffinityEnabled(bl);
        }
    }

    public boolean getAttachJMSXUserID() {
        if (this.delegate == null) {
            Object object = this.getValue("AttachJMSXUserID");
            if (object == null || !(object instanceof Boolean)) {
                return false;
            }
            return (Boolean)object;
        }
        return this.delegate.getSecurityParams().isAttachJMSXUserId();
    }

    public void setAttachJMSXUserID(boolean bl) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("AttachJMSXUserID", new Boolean(bl));
        } else {
            this.delegate.getSecurityParams().setAttachJMSXUserId(bl);
        }
    }

    public int getFlowMinimum() {
        if (this.delegate == null) {
            Object object = this.getValue("FlowMinimum");
            if (object == null || !(object instanceof Integer)) {
                return 50;
            }
            return (Integer)object;
        }
        return this.delegate.getFlowControlParams().getFlowMinimum();
    }

    public void setFlowMinimum(int n) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("FlowMinimum", new Integer(n));
        } else {
            this.delegate.getFlowControlParams().setFlowMinimum(n);
        }
    }

    public int getFlowMaximum() {
        if (this.delegate == null) {
            Object object = this.getValue("FlowMaximum");
            if (object == null || !(object instanceof Integer)) {
                return 500;
            }
            return (Integer)object;
        }
        return this.delegate.getFlowControlParams().getFlowMaximum();
    }

    public void setFlowMaximum(int n) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("FlowMaximum", new Integer(n));
        } else {
            this.delegate.getFlowControlParams().setFlowMaximum(n);
        }
    }

    public int getFlowSteps() {
        if (this.delegate == null) {
            Object object = this.getValue("FlowSteps");
            if (object == null || !(object instanceof Integer)) {
                return 10;
            }
            return (Integer)object;
        }
        return this.delegate.getFlowControlParams().getFlowSteps();
    }

    public void setFlowSteps(int n) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("FlowSteps", new Integer(n));
        } else {
            this.delegate.getFlowControlParams().setFlowSteps(n);
        }
    }

    public int getFlowInterval() {
        if (this.delegate == null) {
            Object object = this.getValue("FlowInterval");
            if (object == null || !(object instanceof Integer)) {
                return 60;
            }
            return (Integer)object;
        }
        return this.delegate.getFlowControlParams().getFlowInterval();
    }

    public void setFlowInterval(int n) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("FlowInterval", new Integer(n));
        } else {
            this.delegate.getFlowControlParams().setFlowInterval(n);
        }
    }

    public boolean getFlowControlEnabled() {
        if (this.delegate == null) {
            Object object = this.getValue("FlowControlEnabled");
            if (object == null || !(object instanceof Boolean)) {
                return true;
            }
            return (Boolean)object;
        }
        return this.delegate.getFlowControlParams().isFlowControlEnabled();
    }

    public void setFlowControlEnabled(boolean bl) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("FlowControlEnabled", new Boolean(bl));
        } else {
            this.delegate.getFlowControlParams().setFlowControlEnabled(bl);
        }
    }

    public String getNotes() {
        if (this.delegate == null) {
            Object object = this.getValue("Notes");
            if (object == null || !(object instanceof String)) {
                return null;
            }
            return (String)object;
        }
        return this.delegate.getNotes();
    }

    public void setNotes(String string) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("Notes", string);
        } else {
            this.delegate.setNotes(string);
        }
    }
}

