/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import javax.management.InvalidAttributeValueException;
import weblogic.j2ee.descriptor.wl.DestinationBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.QuotaBean;
import weblogic.jms.JMSLogger;
import weblogic.jms.module.JMSBeanHelper;
import weblogic.jms.module.MBeanConverter;
import weblogic.management.WebLogicMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSDestinationKeyMBean;
import weblogic.management.configuration.JMSDestinationMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.management.provider.custom.ConfigurationMBeanCustomizer;

public abstract class JMSDestCommon
extends ConfigurationMBeanCustomizer {
    protected transient DomainMBean domain;
    protected transient JMSBean interopModule;
    private transient DestinationBean delegate;
    private static final String BYTES_MAXIMUM = "BytesMaximum";
    private static final String MESSAGES_MAXIMUM = "MessagesMaximum";

    public JMSDestCommon(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    public void useDelegates(DomainMBean domainMBean, JMSBean jMSBean, DestinationBean destinationBean) {
        this.domain = domainMBean;
        this.interopModule = jMSBean;
        this.delegate = destinationBean;
    }

    public long getBytesMaximum() {
        if (this.delegate != null) {
            QuotaBean quotaBean = this.delegate.getQuota();
            if (quotaBean == null || !this.delegate.isSet("Quota")) {
                return -1L;
            }
            if (quotaBean.isSet(BYTES_MAXIMUM)) {
                return quotaBean.getBytesMaximum();
            }
            return -1L;
        }
        Object object = this.getValue(BYTES_MAXIMUM);
        if (object == null || !(object instanceof Long)) {
            return -1L;
        }
        return (Long)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytesMaximum(long l) throws InvalidAttributeValueException {
        this.putValue(BYTES_MAXIMUM, new Long(l));
        if (this.delegate == null) {
            return;
        }
        String string = this.delegate.getName();
        String string2 = MBeanConverter.constructQuotaNameFromDestinationName(string);
        QuotaBean quotaBean = null;
        try {
            quotaBean = this.interopModule.lookupQuota(string2);
            if (quotaBean == null) {
                quotaBean = this.interopModule.createQuota(string2);
            }
        }
        finally {
            if (quotaBean == null) {
                JMSLogger.logBytesMaximumNoEffect((String)string, (long)l);
            } else {
                if (l >= 0L) {
                    quotaBean.setBytesMaximum(l);
                } else {
                    quotaBean.unSet(BYTES_MAXIMUM);
                }
                if (quotaBean.isSet(BYTES_MAXIMUM) || quotaBean.isSet(MESSAGES_MAXIMUM)) {
                    this.delegate.setQuota(quotaBean);
                } else {
                    this.delegate.unSet("Quota");
                }
            }
        }
    }

    public long getMessagesMaximum() {
        if (this.delegate != null) {
            QuotaBean quotaBean = this.delegate.getQuota();
            if (quotaBean == null || !this.delegate.isSet("Quota")) {
                return -1L;
            }
            if (quotaBean.isSet(MESSAGES_MAXIMUM)) {
                return quotaBean.getMessagesMaximum();
            }
            return -1L;
        }
        Object object = this.getValue(MESSAGES_MAXIMUM);
        if (object == null || !(object instanceof Long)) {
            return -1L;
        }
        return (Long)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessagesMaximum(long l) throws InvalidAttributeValueException {
        this.putValue(MESSAGES_MAXIMUM, new Long(l));
        if (this.delegate == null) {
            return;
        }
        String string = this.delegate.getName();
        String string2 = MBeanConverter.constructQuotaNameFromDestinationName(string);
        QuotaBean quotaBean = null;
        try {
            quotaBean = this.interopModule.lookupQuota(string2);
            if (quotaBean == null) {
                quotaBean = this.interopModule.createQuota(string2);
            }
        }
        finally {
            if (quotaBean == null) {
                JMSLogger.logMessagesMaximumNoEffect((String)string, (long)l);
            } else {
                if (l >= 0L) {
                    quotaBean.setMessagesMaximum(l);
                } else {
                    quotaBean.unSet(MESSAGES_MAXIMUM);
                }
                if (quotaBean.isSet(BYTES_MAXIMUM) || quotaBean.isSet(MESSAGES_MAXIMUM)) {
                    this.delegate.setQuota(quotaBean);
                } else {
                    this.delegate.unSet("Quota");
                }
            }
        }
    }

    public JMSDestinationMBean getErrorDestination() {
        if (this.delegate == null) {
            Object object = this.getValue("ErrorDestination");
            if (object == null || !(object instanceof JMSDestinationMBean)) {
                return null;
            }
            return (JMSDestinationMBean)object;
        }
        DestinationBean destinationBean = this.delegate.getDeliveryFailureParams().getErrorDestination();
        if (destinationBean == null) {
            return null;
        }
        return MBeanConverter.findErrorQueue(this.domain, destinationBean.getName());
    }

    public void setErrorDestination(JMSDestinationMBean jMSDestinationMBean) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("ErrorDestination", jMSDestinationMBean);
        } else {
            String string = jMSDestinationMBean == null ? null : jMSDestinationMBean.getName();
            DestinationBean destinationBean = JMSBeanHelper.findDestinationBean(string, this.interopModule);
            this.delegate.getDeliveryFailureParams().setErrorDestination(destinationBean);
        }
    }

    public JMSDestinationKeyMBean[] getDestinationKeys() {
        if (this.delegate == null) {
            Object object = this.getValue("DestinationKeys");
            if (object == null || !(object instanceof JMSDestinationKeyMBean[])) {
                return null;
            }
            return (JMSDestinationKeyMBean[])object;
        }
        String[] stringArray = this.delegate.getDestinationKeys();
        if (stringArray == null) {
            return null;
        }
        JMSDestinationKeyMBean[] jMSDestinationKeyMBeanArray = new JMSDestinationKeyMBean[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            jMSDestinationKeyMBeanArray[i] = this.domain.lookupJMSDestinationKey(stringArray[i]);
        }
        return jMSDestinationKeyMBeanArray;
    }

    public void setDestinationKeys(JMSDestinationKeyMBean[] jMSDestinationKeyMBeanArray) {
        if (this.delegate == null) {
            this.putValue("DestinationKeys", jMSDestinationKeyMBeanArray);
        } else if (jMSDestinationKeyMBeanArray != null) {
            String[] stringArray = new String[jMSDestinationKeyMBeanArray.length];
            for (int i = 0; i < jMSDestinationKeyMBeanArray.length; ++i) {
                stringArray[i] = jMSDestinationKeyMBeanArray[i].getName();
            }
            this.delegate.setDestinationKeys(stringArray);
        }
    }

    public long getBytesThresholdHigh() {
        if (this.delegate != null && this.delegate.getThresholds().isSet("BytesHigh")) {
            long l = this.delegate.getThresholds().getBytesHigh();
            long l2 = (Long)this.getValue("BytesThresholdHigh");
            if (l == Long.MAX_VALUE && l2 == -1L) {
                return l2;
            }
            return l;
        }
        Object object = this.getValue("BytesThresholdHigh");
        if (object == null || !(object instanceof Long)) {
            return -1L;
        }
        return (Long)object;
    }

    public void setBytesThresholdHigh(long l) throws InvalidAttributeValueException {
        this.putValue("BytesThresholdHigh", new Long(l));
        if (this.delegate != null) {
            if (l == -1L) {
                l = Long.MAX_VALUE;
            }
            this.delegate.getThresholds().setBytesHigh(l);
        }
    }

    public long getBytesThresholdLow() {
        if (this.delegate != null && this.delegate.getThresholds().isSet("BytesLow")) {
            long l = this.delegate.getThresholds().getBytesLow();
            long l2 = (Long)this.getValue("BytesThresholdLow");
            if (l == Long.MAX_VALUE && l2 == -1L) {
                return l2;
            }
            return l;
        }
        Object object = this.getValue("BytesThresholdLow");
        if (object == null || !(object instanceof Long)) {
            return -1L;
        }
        return (Long)object;
    }

    public void setBytesThresholdLow(long l) throws InvalidAttributeValueException {
        this.putValue("BytesThresholdLow", new Long(l));
        if (this.delegate != null) {
            if (l == -1L) {
                l = Long.MAX_VALUE;
            }
            this.delegate.getThresholds().setBytesLow(l);
        }
    }

    public long getMessagesThresholdHigh() {
        if (this.delegate != null && this.delegate.getThresholds().isSet("MessagesHigh")) {
            long l = this.delegate.getThresholds().getMessagesHigh();
            long l2 = (Long)this.getValue("MessagesThresholdHigh");
            if (l == Long.MAX_VALUE && l2 == -1L) {
                return l2;
            }
            return l;
        }
        Object object = this.getValue("MessagesThresholdHigh");
        if (object == null || !(object instanceof Long)) {
            return -1L;
        }
        return (Long)object;
    }

    public void setMessagesThresholdHigh(long l) throws InvalidAttributeValueException {
        this.putValue("MessagesThresholdHigh", new Long(l));
        if (this.delegate != null) {
            if (l == -1L) {
                l = Long.MAX_VALUE;
            }
            this.delegate.getThresholds().setMessagesHigh(l);
        }
    }

    public long getMessagesThresholdLow() {
        if (this.delegate != null && this.delegate.getThresholds().isSet("MessagesLow")) {
            long l = this.delegate.getThresholds().getMessagesLow();
            long l2 = (Long)this.getValue("MessagesThresholdLow");
            if (l == Long.MAX_VALUE && l2 == -1L) {
                return l2;
            }
            return l;
        }
        Object object = this.getValue("MessagesThresholdLow");
        if (object == null || !(object instanceof Long)) {
            return -1L;
        }
        return (Long)object;
    }

    public void setMessagesThresholdLow(long l) throws InvalidAttributeValueException {
        this.putValue("MessagesThresholdLow", new Long(l));
        if (this.delegate != null) {
            if (l == -1L) {
                l = Long.MAX_VALUE;
            }
            this.delegate.getThresholds().setMessagesLow(l);
        }
    }

    public int getPriorityOverride() {
        if (this.delegate != null && this.delegate.getDeliveryParamsOverrides().isSet("Priority")) {
            return this.delegate.getDeliveryParamsOverrides().getPriority();
        }
        Object object = this.getValue("PriorityOverride");
        if (object == null || !(object instanceof Integer)) {
            return -1;
        }
        return (Integer)object;
    }

    public void setPriorityOverride(int n) throws InvalidAttributeValueException {
        this.putValue("PriorityOverride", new Integer(n));
        if (this.delegate != null) {
            this.delegate.getDeliveryParamsOverrides().setPriority(n);
        }
    }

    public String getTimeToDeliverOverride() {
        if (this.delegate != null && this.delegate.getDeliveryParamsOverrides().isSet("TimeToDeliver")) {
            return this.delegate.getDeliveryParamsOverrides().getTimeToDeliver();
        }
        Object object = this.getValue("TimeToDeliverOverride");
        if (object == null || !(object instanceof String)) {
            return "-1";
        }
        return (String)object;
    }

    public void setTimeToDeliverOverride(String string) throws InvalidAttributeValueException {
        this.putValue("TimeToDeliverOverride", string);
        if (this.delegate != null) {
            this.delegate.getDeliveryParamsOverrides().setTimeToDeliver(string);
        }
    }

    public long getRedeliveryDelayOverride() {
        if (this.delegate != null && this.delegate.getDeliveryParamsOverrides().isSet("RedeliveryDelay")) {
            return this.delegate.getDeliveryParamsOverrides().getRedeliveryDelay();
        }
        Object object = this.getValue("RedeliveryDelayOverride");
        if (object == null || !(object instanceof Long)) {
            return -1L;
        }
        return (Long)object;
    }

    public void setRedeliveryDelayOverride(long l) throws InvalidAttributeValueException {
        this.putValue("RedeliveryDelayOverride", new Long(l));
        if (this.delegate != null) {
            this.delegate.getDeliveryParamsOverrides().setRedeliveryDelay(l);
        }
    }

    public int getRedeliveryLimit() {
        if (this.delegate != null && this.delegate.getDeliveryFailureParams().isSet("RedeliveryLimit")) {
            return this.delegate.getDeliveryFailureParams().getRedeliveryLimit();
        }
        Object object = this.getValue("RedeliveryLimit");
        if (object == null || !(object instanceof Integer)) {
            return -1;
        }
        return (Integer)object;
    }

    public void setRedeliveryLimit(int n) throws InvalidAttributeValueException {
        this.putValue("RedeliveryLimit", new Integer(n));
        if (this.delegate != null) {
            this.delegate.getDeliveryFailureParams().setRedeliveryLimit(n);
        }
    }

    public long getTimeToLiveOverride() {
        if (this.delegate != null && this.delegate.getDeliveryParamsOverrides().isSet("TimeToLive")) {
            return this.delegate.getDeliveryParamsOverrides().getTimeToLive();
        }
        Object object = this.getValue("TimeToLiveOverride");
        if (object == null || !(object instanceof Long)) {
            return -1L;
        }
        return (Long)object;
    }

    public void setTimeToLiveOverride(long l) throws InvalidAttributeValueException {
        this.putValue("TimeToLiveOverride", new Long(l));
        if (this.delegate != null) {
            this.delegate.getDeliveryParamsOverrides().setTimeToLive(l);
        }
    }

    public String getDeliveryModeOverride() {
        if (this.delegate != null && this.delegate.getDeliveryParamsOverrides().isSet("DeliveryMode")) {
            return this.delegate.getDeliveryParamsOverrides().getDeliveryMode();
        }
        Object object = this.getValue("DeliveryModeOverride");
        if (object == null || !(object instanceof String)) {
            return "No-Delivery";
        }
        return (String)object;
    }

    public void setDeliveryModeOverride(String string) throws InvalidAttributeValueException {
        this.putValue("DeliveryModeOverride", string);
        if (this.delegate != null) {
            this.delegate.getDeliveryParamsOverrides().setDeliveryMode(string);
        }
    }

    public String getExpirationPolicy() {
        if (this.delegate != null && this.delegate.getDeliveryFailureParams().isSet("ExpirationPolicy")) {
            return this.delegate.getDeliveryFailureParams().getExpirationPolicy();
        }
        Object object = this.getValue("ExpirationPolicy");
        if (object == null || !(object instanceof String)) {
            return "Discard";
        }
        return (String)object;
    }

    public void setExpirationPolicy(String string) throws InvalidAttributeValueException {
        this.putValue("ExpirationPolicy", string);
        if (this.delegate != null) {
            this.delegate.getDeliveryFailureParams().setExpirationPolicy(string);
        }
    }

    public String getExpirationLoggingPolicy() {
        if (this.delegate != null && this.delegate.getDeliveryFailureParams().isSet("ExpirationLoggingPolicy")) {
            return this.delegate.getDeliveryFailureParams().getExpirationLoggingPolicy();
        }
        Object object = this.getValue("ExpirationLoggingPolicy");
        if (object == null || !(object instanceof String)) {
            return null;
        }
        return (String)object;
    }

    public void setExpirationLoggingPolicy(String string) throws InvalidAttributeValueException {
        this.putValue("ExpirationLoggingPolicy", string);
        if (this.delegate != null) {
            this.delegate.getDeliveryFailureParams().setExpirationLoggingPolicy(string);
        }
    }

    public int getMaximumMessageSize() {
        if (this.delegate != null && this.delegate.isSet("MaximumMessageSize")) {
            return this.delegate.getMaximumMessageSize();
        }
        Object object = this.getValue("MaximumMessageSize");
        if (object == null || !(object instanceof Integer)) {
            return Integer.MAX_VALUE;
        }
        return (Integer)object;
    }

    public void setMaximumMessageSize(int n) throws InvalidAttributeValueException {
        this.putValue("MaximumMessageSize", new Integer(n));
        if (this.delegate != null) {
            this.delegate.setMaximumMessageSize(n);
        }
    }

    public String getNotes() {
        if (this.delegate != null && this.delegate.isSet("Notes")) {
            return this.delegate.getNotes();
        }
        Object object = this.getValue("Notes");
        if (object == null || !(object instanceof String)) {
            return null;
        }
        return (String)object;
    }

    public void setNotes(String string) throws InvalidAttributeValueException {
        this.putValue("Notes", string);
        if (this.delegate != null) {
            this.delegate.setNotes(string);
        }
    }

    public void _preDestroy() {
        WebLogicMBean webLogicMBean = this.getMbean().getParent();
        if (webLogicMBean instanceof JMSServerMBean) {
            JMSServerMBean jMSServerMBean = (JMSServerMBean)webLogicMBean;
            DomainMBean domainMBean = (DomainMBean)jMSServerMBean.getParent();
            JMSServerMBean[] jMSServerMBeanArray = domainMBean.getJMSServers();
            for (int i = 0; i < jMSServerMBeanArray.length; ++i) {
                JMSDestinationMBean[] jMSDestinationMBeanArray = jMSServerMBeanArray[i].getDestinations();
                for (int j = 0; j < jMSDestinationMBeanArray.length; ++j) {
                    JMSDestinationMBean jMSDestinationMBean = jMSDestinationMBeanArray[j].getErrorDestination();
                    if (jMSDestinationMBean == null) continue;
                    String string = jMSDestinationMBean.getName();
                    String string2 = jMSDestinationMBean.getType();
                    if (!string.equals(this.getMbean().getName()) || !string2.equals(this.getMbean().getType())) continue;
                    String string3 = "Destination " + this.getMbean().getName() + " cannot be removed because it is the" + " ErrorDestinatin of " + string;
                    throw new RuntimeException(string3);
                }
            }
        }
    }
}

