/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import javax.management.InvalidAttributeValueException;
import weblogic.j2ee.descriptor.wl.DestinationBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.TemplateBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSTemplateMBean;
import weblogic.management.mbeans.custom.JMSDestCommon;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;

public abstract class JMSDestination
extends JMSDestCommon {
    private transient DestinationBean delegate;
    private String localJNDIName;
    private boolean localJNDIReplicated = true;

    public JMSDestination(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    public void useDelegates(DomainMBean domainMBean, JMSBean jMSBean, DestinationBean destinationBean) {
        this.delegate = destinationBean;
        super.useDelegates(domainMBean, jMSBean, this.delegate);
    }

    public JMSTemplateMBean getTemplate() {
        String string;
        if (this.delegate == null) {
            Object object = this.getValue("Template");
            if (object == null || !(object instanceof JMSTemplateMBean)) {
                return null;
            }
            return (JMSTemplateMBean)object;
        }
        TemplateBean templateBean = this.delegate.getTemplate();
        String string2 = string = templateBean == null ? null : templateBean.getName();
        if (string == null) {
            return null;
        }
        return this.domain.lookupJMSTemplate(string);
    }

    public void setTemplate(JMSTemplateMBean jMSTemplateMBean) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("Template", jMSTemplateMBean);
        } else {
            String string;
            String string2 = string = jMSTemplateMBean == null ? null : jMSTemplateMBean.getName();
            if (string == null) {
                this.delegate.setTemplate(null);
            } else {
                TemplateBean templateBean = this.interopModule.lookupTemplate(string);
                if (templateBean == null) {
                    throw new InvalidAttributeValueException("Could find the template " + string + " in the interop module while setting the template attribute of a destination");
                }
                this.delegate.setTemplate(templateBean);
            }
        }
    }

    public String getJNDIName() {
        if (this.delegate == null) {
            return this.localJNDIName;
        }
        if (this.localJNDIReplicated) {
            return this.delegate.getJNDIName();
        }
        return this.delegate.getLocalJNDIName();
    }

    public void setJNDIName(String string) {
        this.localJNDIName = string;
        if (this.delegate == null) {
            return;
        }
        if (this.localJNDIReplicated) {
            this.delegate.setJNDIName(this.localJNDIName);
        } else {
            this.delegate.setLocalJNDIName(this.localJNDIName);
        }
    }

    public boolean isJNDINameReplicated() {
        return this.localJNDIReplicated;
    }

    public void setJNDINameReplicated(boolean bl) {
        boolean bl2 = this.localJNDIReplicated;
        this.localJNDIReplicated = bl;
        if (this.delegate == null || this.localJNDIReplicated == bl2) {
            return;
        }
        if (this.localJNDIReplicated) {
            this.delegate.setLocalJNDIName(null);
            this.delegate.setJNDIName(this.localJNDIName);
        } else {
            this.delegate.setJNDIName(null);
            this.delegate.setLocalJNDIName(this.localJNDIName);
        }
    }

    public String getStoreEnabled() {
        if (this.delegate == null) {
            Object object = this.getValue("StoreEnabled");
            if (object == null || !(object instanceof String)) {
                return "default";
            }
            return (String)object;
        }
        String string = this.delegate.getDeliveryParamsOverrides().getDeliveryMode();
        if (string.equals("No-Delivery")) {
            return "default";
        }
        if (string.equals("Persistent")) {
            return "true";
        }
        return "false";
    }

    public void setStoreEnabled(String string) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("StoreEnabled", string);
        }
    }
}

