/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import javax.management.InvalidAttributeValueException;
import weblogic.j2ee.descriptor.wl.DistributedDestinationBean;
import weblogic.management.DistributedManagementException;
import weblogic.management.WebLogicMBean;
import weblogic.management.configuration.JMSTemplateMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.management.provider.custom.ConfigurationMBeanCustomizer;

public class JMSDistributedDestination
extends ConfigurationMBeanCustomizer {
    private static final String TARGETS = "Targets";
    private static final long serialVersionUID = 5429833394456540954L;
    private transient DistributedDestinationBean delegate;
    private transient SubDeploymentMBean subDeployment;

    public JMSDistributedDestination(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    public void useDelegates(DistributedDestinationBean distributedDestinationBean, SubDeploymentMBean subDeploymentMBean) {
        this.delegate = distributedDestinationBean;
        this.subDeployment = subDeploymentMBean;
    }

    public TargetMBean[] getTargets() {
        if (this.subDeployment == null) {
            TargetMBean[] targetMBeanArray = this.getValue(TARGETS);
            if (targetMBeanArray == null) {
                return new TargetMBean[0];
            }
            if (!(targetMBeanArray instanceof TargetMBean)) {
                if (!(targetMBeanArray instanceof WebLogicMBean[])) {
                    return new TargetMBean[0];
                }
                WebLogicMBean[] webLogicMBeanArray = targetMBeanArray;
                TargetMBean[] targetMBeanArray2 = new TargetMBean[webLogicMBeanArray.length];
                for (int i = 0; i < webLogicMBeanArray.length; ++i) {
                    WebLogicMBean webLogicMBean = webLogicMBeanArray[i];
                    if (!(webLogicMBean instanceof TargetMBean)) {
                        return new TargetMBean[0];
                    }
                    targetMBeanArray2[i] = (TargetMBean)webLogicMBean;
                }
                targetMBeanArray = targetMBeanArray2;
            }
            return targetMBeanArray;
        }
        return this.subDeployment.getTargets();
    }

    public void setTargets(TargetMBean[] targetMBeanArray) throws InvalidAttributeValueException, DistributedManagementException {
        if (this.subDeployment == null) {
            this.putValueNotify(TARGETS, targetMBeanArray);
        } else {
            this.subDeployment.setTargets(targetMBeanArray);
        }
    }

    public String getLoadBalancingPolicy() {
        if (this.delegate == null) {
            Object object = this.getValue("LoadBalancingPolicy");
            if (object == null || !(object instanceof String)) {
                return "Round-Robin";
            }
            return (String)object;
        }
        return this.delegate.getLoadBalancingPolicy();
    }

    public void setLoadBalancingPolicy(String string) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("LoadBalancingPolicy", string);
        } else {
            this.delegate.setLoadBalancingPolicy(string);
        }
    }

    public JMSTemplateMBean getTemplate() {
        Object object = this.getValue("Template");
        return (JMSTemplateMBean)object;
    }

    public void setTemplate(JMSTemplateMBean jMSTemplateMBean) throws InvalidAttributeValueException {
        this.putValue("Template", jMSTemplateMBean);
    }

    public JMSTemplateMBean getJMSTemplate() {
        Object object = this.getValue("JMSTemplate");
        return (JMSTemplateMBean)object;
    }

    public void setJMSTemplate(JMSTemplateMBean jMSTemplateMBean) throws InvalidAttributeValueException {
        this.putValue("JMSTemplate", jMSTemplateMBean);
    }

    public String getNotes() {
        if (this.delegate == null) {
            Object object = this.getValue("Notes");
            if (object == null || !(object instanceof String)) {
                return null;
            }
            return (String)object;
        }
        return this.delegate.getNotes();
    }

    public void setNotes(String string) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("Notes", string);
        } else {
            this.delegate.setNotes(string);
        }
    }

    public String getJNDIName() {
        if (this.delegate == null) {
            Object object = this.getValue("JNDIName");
            if (object == null || !(object instanceof String)) {
                return null;
            }
            return (String)object;
        }
        return this.delegate.getJNDIName();
    }

    public void setJNDIName(String string) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("JNDIName", string);
        } else {
            this.delegate.setJNDIName(string);
        }
    }
}

