/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import javax.management.InvalidAttributeValueException;
import weblogic.j2ee.descriptor.wl.DistributedDestinationBean;
import weblogic.j2ee.descriptor.wl.DistributedQueueBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSDistributedQueueMBean;
import weblogic.management.configuration.JMSDistributedQueueMemberMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.mbeans.custom.JMSDistributedDestination;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.utils.ArrayUtils;

public class JMSDistributedQueue
extends JMSDistributedDestination {
    static final long serialVersionUID = -5251076212640474307L;
    private DistributedQueueBean delegate;

    public JMSDistributedQueue(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    public void useDelegates(DistributedQueueBean distributedQueueBean, SubDeploymentMBean subDeploymentMBean) {
        this.delegate = distributedQueueBean;
        super.useDelegates((DistributedDestinationBean)this.delegate, subDeploymentMBean);
    }

    public JMSDistributedQueueMemberMBean createJMSDistributedQueueMember(String string, JMSDistributedQueueMemberMBean jMSDistributedQueueMemberMBean) {
        try {
            return (JMSDistributedQueueMemberMBean)this.getMbean().createChildCopy("JMSDistributedQueueMember", jMSDistributedQueueMemberMBean);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Error(illegalArgumentException);
        }
    }

    public void destroyJMSDistributedQueueMember(String string, JMSDistributedQueueMemberMBean jMSDistributedQueueMemberMBean) {
        this.removeMember(jMSDistributedQueueMemberMBean);
    }

    public JMSDistributedQueueMemberMBean[] getMembers() {
        return ((JMSDistributedQueueMBean)this.getMbean()).getJMSDistributedQueueMembers();
    }

    public void setMembers(JMSDistributedQueueMemberMBean[] jMSDistributedQueueMemberMBeanArray) {
        ArrayUtils.computeDiff((Object[])this.getMembers(), (Object[])jMSDistributedQueueMemberMBeanArray, (ArrayUtils.DiffHandler)new ArrayUtils.DiffHandler(){

            public void addObject(Object object) {
                JMSDistributedQueue.this.addMember((JMSDistributedQueueMemberMBean)object);
            }

            public void removeObject(Object object) {
                JMSDistributedQueue.this.removeMember((JMSDistributedQueueMemberMBean)object);
            }
        });
    }

    public boolean addMember(JMSDistributedQueueMemberMBean jMSDistributedQueueMemberMBean) {
        JMSDistributedQueueMBean jMSDistributedQueueMBean = (JMSDistributedQueueMBean)this.getMbean();
        if (jMSDistributedQueueMBean.lookupJMSDistributedQueueMember(jMSDistributedQueueMemberMBean.getName()) != null) {
            return true;
        }
        JMSDistributedQueueMemberMBean jMSDistributedQueueMemberMBean2 = (JMSDistributedQueueMemberMBean)this.getMbean().createChildCopy("JMSDistributedQueueMember", jMSDistributedQueueMemberMBean);
        DomainMBean domainMBean = (DomainMBean)jMSDistributedQueueMBean.getParentBean();
        domainMBean.destroyJMSDistributedQueueMember(jMSDistributedQueueMemberMBean);
        return true;
    }

    public boolean removeMember(JMSDistributedQueueMemberMBean jMSDistributedQueueMemberMBean) {
        JMSDistributedQueueMBean jMSDistributedQueueMBean = (JMSDistributedQueueMBean)this.getMbean();
        DomainMBean domainMBean = (DomainMBean)jMSDistributedQueueMBean.getParentBean();
        if (jMSDistributedQueueMBean.lookupJMSDistributedQueueMember(jMSDistributedQueueMemberMBean.getName()) == null) {
            return true;
        }
        domainMBean.createJMSDistributedQueueMember(jMSDistributedQueueMemberMBean.getName(), jMSDistributedQueueMemberMBean);
        jMSDistributedQueueMBean.destroyJMSDistributedQueueMember(jMSDistributedQueueMemberMBean);
        return true;
    }

    public int getForwardDelay() {
        if (this.delegate == null) {
            Object object = this.getValue("ForwardDelay");
            if (object == null || !(object instanceof Integer)) {
                return -1;
            }
            return (Integer)object;
        }
        return this.delegate.getForwardDelay();
    }

    public void setForwardDelay(int n) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue("ForwardDelay", new Integer(n));
        } else {
            this.delegate.setForwardDelay(n);
        }
    }

    public boolean getResetDeliveryCountOnFoward() {
        if (this.delegate == null) {
            Object object = this.getValue("ResetDeliveryCountOnForward");
            if (object == null || !(object instanceof Boolean)) {
                return true;
            }
            return (Boolean)object;
        }
        return this.delegate.getResetDeliveryCountOnForward();
    }

    public void setResetDeliveryCountOnForward(boolean bl) {
        if (this.delegate == null) {
            this.putValue("ResetDeliveryCountOnForward", new Boolean(bl));
        } else {
            this.delegate.setResetDeliveryCountOnForward(bl);
        }
    }
}

