/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import weblogic.j2ee.descriptor.wl.DistributedDestinationMemberBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.QueueBean;
import weblogic.jms.module.JMSBeanHelper;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSQueueMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.mbeans.custom.JMSDistributedDestinationMember;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;

public class JMSDistributedQueueMember
extends JMSDistributedDestinationMember {
    private static final String DQ_MEMBER = "JMSQueue";
    private static final String QUEUE_PROP = "PhysicalDestinationName";
    private DomainMBean domain;
    private DistributedDestinationMemberBean delegate;

    public JMSDistributedQueueMember(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    public void useDelegates(DomainMBean domainMBean, DistributedDestinationMemberBean distributedDestinationMemberBean) {
        this.domain = domainMBean;
        this.delegate = distributedDestinationMemberBean;
        super.useDelegates(this.delegate);
    }

    public JMSQueueMBean getJMSQueue() {
        if (this.delegate == null) {
            return (JMSQueueMBean)this.getValue(DQ_MEMBER);
        }
        if (!this.delegate.isSet(QUEUE_PROP)) {
            return null;
        }
        String string = this.delegate.getPhysicalDestinationName();
        if (string == null) {
            return null;
        }
        JMSBean jMSBean = JMSBeanHelper.getInteropJMSBean(this.domain);
        if (jMSBean == null) {
            return null;
        }
        QueueBean queueBean = jMSBean.lookupQueue(string);
        if (queueBean == null) {
            return null;
        }
        String string2 = queueBean.getSubDeploymentName();
        JMSServerMBean jMSServerMBean = this.domain.lookupJMSServer(string2);
        if (jMSServerMBean == null) {
            return null;
        }
        return jMSServerMBean.lookupJMSQueue(string);
    }

    public void setJMSQueue(JMSQueueMBean jMSQueueMBean) {
        if (this.delegate == null) {
            this.putValue(DQ_MEMBER, jMSQueueMBean);
            return;
        }
        if (jMSQueueMBean == null) {
            this.delegate.unSet(QUEUE_PROP);
        } else {
            this.delegate.setPhysicalDestinationName(jMSQueueMBean.getName());
        }
    }
}

