/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import weblogic.j2ee.descriptor.wl.DistributedDestinationMemberBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.TopicBean;
import weblogic.jms.module.JMSBeanHelper;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.JMSTopicMBean;
import weblogic.management.mbeans.custom.JMSDistributedDestinationMember;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;

public class JMSDistributedTopicMember
extends JMSDistributedDestinationMember {
    private static final String DT_MEMBER = "JMSTopic";
    private static final String TOPIC_PROP = "PhysicalDestinationName";
    private DistributedDestinationMemberBean delegate;
    private DomainMBean domain;

    public JMSDistributedTopicMember(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    public void useDelegates(DomainMBean domainMBean, DistributedDestinationMemberBean distributedDestinationMemberBean) {
        this.domain = domainMBean;
        this.delegate = distributedDestinationMemberBean;
        super.useDelegates(this.delegate);
    }

    public JMSTopicMBean getJMSTopic() {
        if (this.delegate == null) {
            return (JMSTopicMBean)this.getValue(DT_MEMBER);
        }
        if (!this.delegate.isSet(TOPIC_PROP)) {
            return null;
        }
        String string = this.delegate.getPhysicalDestinationName();
        if (string == null) {
            return null;
        }
        JMSBean jMSBean = JMSBeanHelper.getInteropJMSBean(this.domain);
        if (jMSBean == null) {
            return null;
        }
        TopicBean topicBean = jMSBean.lookupTopic(string);
        if (topicBean == null) {
            return null;
        }
        String string2 = topicBean.getSubDeploymentName();
        JMSServerMBean jMSServerMBean = this.domain.lookupJMSServer(string2);
        if (jMSServerMBean == null) {
            return null;
        }
        return jMSServerMBean.lookupJMSTopic(string);
    }

    public void setJMSTopic(JMSTopicMBean jMSTopicMBean) {
        if (this.delegate == null) {
            this.putValue(DT_MEMBER, jMSTopicMBean);
            return;
        }
        if (jMSTopicMBean == null) {
            this.delegate.unSet(TOPIC_PROP);
        } else {
            this.delegate.setPhysicalDestinationName(jMSTopicMBean.getName());
        }
    }
}

