/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import javax.management.InvalidAttributeValueException;
import weblogic.management.DistributedManagementException;
import weblogic.management.configuration.FileStoreMBean;
import weblogic.management.configuration.JMSFileStoreMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.management.provider.custom.ConfigurationMBeanCustomizer;

public class JMSFileStore
extends ConfigurationMBeanCustomizer {
    private transient FileStoreMBean newBean;
    private transient JMSServerMBean serverBean;
    private String directory;
    private String synchronousWritePolicy;

    public JMSFileStore(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    public void setDelegatedBean(FileStoreMBean fileStoreMBean) {
        this.newBean = fileStoreMBean;
    }

    public FileStoreMBean getDelegatedBean() {
        return this.newBean;
    }

    public void setDelegatedJMSServer(JMSServerMBean jMSServerMBean) {
        this.serverBean = jMSServerMBean;
    }

    public JMSServerMBean getDelegatedJMSServer() {
        return this.serverBean;
    }

    public static void copy(JMSFileStoreMBean jMSFileStoreMBean, FileStoreMBean fileStoreMBean) {
        try {
            if (jMSFileStoreMBean.getDirectory() != null) {
                fileStoreMBean.setDirectory(jMSFileStoreMBean.getDirectory());
            }
            if (jMSFileStoreMBean.getSynchronousWritePolicy() != null) {
                fileStoreMBean.setSynchronousWritePolicy(jMSFileStoreMBean.getSynchronousWritePolicy());
            }
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
        }
        catch (DistributedManagementException distributedManagementException) {
            // empty catch block
        }
    }

    public void setDirectory(String string) throws InvalidAttributeValueException {
        if (this.newBean != null) {
            this.newBean.setDirectory(string);
        } else if (this.serverBean != null) {
            this.serverBean.setPagingDirectory(string);
        } else {
            this.directory = string;
        }
    }

    public String getDirectory() {
        if (this.newBean != null) {
            return this.newBean.getDirectory();
        }
        if (this.serverBean != null) {
            return this.serverBean.getPagingDirectory();
        }
        return this.directory;
    }

    public void setSynchronousWritePolicy(String string) throws InvalidAttributeValueException, DistributedManagementException {
        if (this.newBean != null) {
            this.newBean.setSynchronousWritePolicy(string);
        } else {
            this.synchronousWritePolicy = string;
        }
    }

    public String getSynchronousWritePolicy() {
        if (this.newBean != null) {
            return this.newBean.getSynchronousWritePolicy();
        }
        return this.synchronousWritePolicy;
    }
}

