/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import javax.management.InvalidAttributeValueException;
import weblogic.j2ee.descriptor.wl.JDBCDataSourceBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JDBCConnectionPoolMBean;
import weblogic.management.configuration.JDBCStoreMBean;
import weblogic.management.configuration.JDBCSystemResourceMBean;
import weblogic.management.configuration.JMSJDBCStoreMBean;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.management.provider.custom.ConfigurationMBeanCustomizer;

public class JMSJDBCStore
extends ConfigurationMBeanCustomizer {
    private transient JDBCStoreMBean newBean;
    private transient JDBCConnectionPoolMBean connectionPool;
    private String prefixName;
    private String createTableDDLFile;

    public JMSJDBCStore(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    public void setDelegatedBean(JDBCStoreMBean jDBCStoreMBean) {
        this.newBean = jDBCStoreMBean;
    }

    public static void copy(JMSJDBCStoreMBean jMSJDBCStoreMBean, JDBCStoreMBean jDBCStoreMBean) {
        try {
            if (jMSJDBCStoreMBean.getConnectionPool() != null) {
                jDBCStoreMBean.setConnectionPool(jMSJDBCStoreMBean.getConnectionPool());
            }
            if (jMSJDBCStoreMBean.getPrefixName() != null) {
                jDBCStoreMBean.setPrefixName(jMSJDBCStoreMBean.getPrefixName());
            }
            if (jMSJDBCStoreMBean.getCreateTableDDLFile() != null) {
                jDBCStoreMBean.setCreateTableDDLFile(jMSJDBCStoreMBean.getCreateTableDDLFile());
            }
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            // empty catch block
        }
    }

    public void setConnectionPool(JDBCConnectionPoolMBean jDBCConnectionPoolMBean) throws InvalidAttributeValueException {
        if (this.newBean == null) {
            this.connectionPool = jDBCConnectionPoolMBean;
        } else {
            JDBCSystemResourceMBean jDBCSystemResourceMBean = this.lookupDataSource((DomainMBean)this.newBean.getParent(), jDBCConnectionPoolMBean.getName());
            if (jDBCSystemResourceMBean == null) {
                throw new InvalidAttributeValueException("The data source " + jDBCConnectionPoolMBean.getName() + " cannot be found");
            }
            this.newBean.setDataSource(jDBCSystemResourceMBean);
        }
    }

    public JDBCConnectionPoolMBean getConnectionPool() {
        if (this.newBean == null) {
            return this.connectionPool;
        }
        if (this.newBean.getConnectionPool() != null) {
            return this.newBean.getConnectionPool();
        }
        JDBCSystemResourceMBean jDBCSystemResourceMBean = this.newBean.getDataSource();
        if (jDBCSystemResourceMBean != null && jDBCSystemResourceMBean.getJDBCResource() != null) {
            String string = jDBCSystemResourceMBean.getJDBCResource().getName();
            DomainMBean domainMBean = (DomainMBean)this.getMbean().getParent();
            return domainMBean.lookupJDBCConnectionPool(string);
        }
        return null;
    }

    public void setPrefixName(String string) throws InvalidAttributeValueException {
        if (this.newBean != null) {
            this.newBean.setPrefixName(string);
        } else {
            this.prefixName = string;
        }
    }

    public String getPrefixName() {
        if (this.newBean != null) {
            return this.newBean.getPrefixName();
        }
        return this.prefixName;
    }

    public void setCreateTableDDLFile(String string) throws InvalidAttributeValueException {
        if (this.newBean != null) {
            this.newBean.setCreateTableDDLFile(string);
        } else {
            this.createTableDDLFile = string;
        }
    }

    public String getCreateTableDDLFile() {
        if (this.newBean != null) {
            return this.newBean.getCreateTableDDLFile();
        }
        return this.createTableDDLFile;
    }

    private JDBCSystemResourceMBean lookupDataSource(DomainMBean domainMBean, String string) {
        JDBCSystemResourceMBean[] jDBCSystemResourceMBeanArray = domainMBean.getJDBCSystemResources();
        if (jDBCSystemResourceMBeanArray != null) {
            for (int i = 0; i < jDBCSystemResourceMBeanArray.length; ++i) {
                JDBCSystemResourceMBean jDBCSystemResourceMBean = jDBCSystemResourceMBeanArray[i];
                JDBCDataSourceBean jDBCDataSourceBean = jDBCSystemResourceMBean.getJDBCResource();
                if (jDBCDataSourceBean == null || !string.equals(jDBCDataSourceBean.getName())) continue;
                return jDBCSystemResourceMBean;
            }
        }
        return null;
    }
}

