/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import java.util.HashSet;
import java.util.Set;
import javax.management.InvalidAttributeValueException;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.QueueBean;
import weblogic.j2ee.descriptor.wl.TopicBean;
import weblogic.jms.extensions.JMSModuleHelper;
import weblogic.jms.module.JMSBeanHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSDestinationMBean;
import weblogic.management.configuration.JMSInteropModuleMBean;
import weblogic.management.configuration.JMSQueueMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.JMSSessionPoolMBean;
import weblogic.management.configuration.JMSSystemResourceMBean;
import weblogic.management.configuration.JMSTemplateMBean;
import weblogic.management.configuration.JMSTopicMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.mbeans.custom.AttributeAggregator;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.management.provider.custom.ConfigurationMBeanCustomizer;
import weblogic.utils.ArrayUtils;

public class JMSServer
extends ConfigurationMBeanCustomizer {
    private static final String TT_PROP = "TemporaryTemplate";
    private static final String TR_PROP = "TemporaryTemplateResource";
    private static final String TN_PROP = "TemporaryTemplateName";
    private transient DomainMBean delegate;

    public JMSServer(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    public void useDelegates(DomainMBean domainMBean) {
        this.delegate = domainMBean;
    }

    public Set getServerNames() {
        TargetMBean[] targetMBeanArray = ((JMSServerMBean)this.getMbean()).getTargets();
        HashSet hashSet = new HashSet();
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            hashSet.addAll(targetMBeanArray[i].getServerNames());
        }
        return hashSet;
    }

    public JMSQueueMBean createJMSQueue(String string, JMSQueueMBean jMSQueueMBean) {
        JMSQueueMBean jMSQueueMBean2 = (JMSQueueMBean)this.getMbean().createChildCopyIncludingObsolete("JMSQueue", jMSQueueMBean);
        return jMSQueueMBean2;
    }

    public JMSTopicMBean createJMSTopic(String string, JMSTopicMBean jMSTopicMBean) {
        JMSTopicMBean jMSTopicMBean2 = (JMSTopicMBean)this.getMbean().createChildCopyIncludingObsolete("JMSTopic", jMSTopicMBean);
        return jMSTopicMBean2;
    }

    public JMSSessionPoolMBean createJMSSessionPool(String string, JMSSessionPoolMBean jMSSessionPoolMBean) {
        JMSSessionPoolMBean jMSSessionPoolMBean2 = (JMSSessionPoolMBean)this.getMbean().createChildCopyIncludingObsolete("JMSSessionPool", jMSSessionPoolMBean);
        return jMSSessionPoolMBean2;
    }

    public void setSessionPools(JMSSessionPoolMBean[] jMSSessionPoolMBeanArray) throws InvalidAttributeValueException {
        ArrayUtils.computeDiff((Object[])this.getSessionPools(), (Object[])jMSSessionPoolMBeanArray, (ArrayUtils.DiffHandler)new ArrayUtils.DiffHandler(){

            public void addObject(Object object) {
                try {
                    JMSServer.this.addSessionPool((JMSSessionPoolMBean)object);
                }
                catch (InvalidAttributeValueException invalidAttributeValueException) {
                    throw new RuntimeException(invalidAttributeValueException);
                }
                catch (DistributedManagementException distributedManagementException) {
                    throw new RuntimeException(distributedManagementException);
                }
            }

            public void removeObject(Object object) {
                try {
                    JMSServer.this.removeSessionPool((JMSSessionPoolMBean)object);
                }
                catch (InvalidAttributeValueException invalidAttributeValueException) {
                    throw new RuntimeException(invalidAttributeValueException);
                }
                catch (DistributedManagementException distributedManagementException) {
                    throw new RuntimeException(distributedManagementException);
                }
            }
        });
    }

    public boolean addSessionPool(JMSSessionPoolMBean jMSSessionPoolMBean) throws InvalidAttributeValueException, DistributedManagementException {
        JMSServerMBean jMSServerMBean = (JMSServerMBean)this.getMbean();
        if (jMSServerMBean.lookupJMSSessionPool(jMSSessionPoolMBean.getName()) != null) {
            return true;
        }
        this.getMbean().createChildCopyIncludingObsolete("JMSSessionPool", jMSSessionPoolMBean);
        DomainMBean domainMBean = (DomainMBean)jMSServerMBean.getParentBean();
        domainMBean.destroyJMSSessionPool(jMSSessionPoolMBean);
        return true;
    }

    public boolean removeSessionPool(JMSSessionPoolMBean jMSSessionPoolMBean) throws InvalidAttributeValueException, DistributedManagementException {
        JMSServerMBean jMSServerMBean = (JMSServerMBean)this.getMbean();
        DomainMBean domainMBean = (DomainMBean)jMSServerMBean.getParentBean();
        if (jMSServerMBean.lookupJMSSessionPool(jMSSessionPoolMBean.getName()) == null) {
            return true;
        }
        domainMBean.createJMSSessionPool(jMSSessionPoolMBean.getName(), jMSSessionPoolMBean);
        jMSServerMBean.destroyJMSSessionPool(jMSSessionPoolMBean);
        return true;
    }

    public JMSSessionPoolMBean[] getSessionPools() {
        JMSServerMBean jMSServerMBean = (JMSServerMBean)this.getMbean();
        return jMSServerMBean.getJMSSessionPools();
    }

    public JMSTemplateMBean getTemporaryTemplate() {
        if (this.delegate == null) {
            Object object = this.getValue(TT_PROP);
            if (object == null || !(object instanceof JMSTemplateMBean)) {
                return null;
            }
            return (JMSTemplateMBean)object;
        }
        JMSServerMBean jMSServerMBean = (JMSServerMBean)this.getMbean();
        String string = jMSServerMBean.getTemporaryTemplateName();
        String string2 = jMSServerMBean.getTemporaryTemplateResource();
        if (string2 == null || !string2.equals("interop-jms")) {
            return null;
        }
        JMSTemplateMBean[] jMSTemplateMBeanArray = this.delegate.getJMSTemplates();
        if (jMSTemplateMBeanArray != null) {
            for (int i = 0; i < jMSTemplateMBeanArray.length; ++i) {
                JMSTemplateMBean jMSTemplateMBean = jMSTemplateMBeanArray[i];
                if (!string.equals(jMSTemplateMBean.getName())) continue;
                return jMSTemplateMBean;
            }
        }
        return null;
    }

    public void setTemporaryTemplate(JMSTemplateMBean jMSTemplateMBean) throws InvalidAttributeValueException {
        if (this.delegate == null) {
            this.putValue(TT_PROP, jMSTemplateMBean);
            return;
        }
        JMSServerMBean jMSServerMBean = (JMSServerMBean)this.getMbean();
        if (jMSTemplateMBean == null) {
            jMSServerMBean.unSet(TR_PROP);
            jMSServerMBean.unSet(TN_PROP);
            return;
        }
        jMSServerMBean.setTemporaryTemplateResource("interop-jms");
        jMSServerMBean.setTemporaryTemplateName(jMSTemplateMBean.getName());
    }

    public JMSDestinationMBean[] getDestinations() {
        return (JMSDestinationMBean[])DESTINATIONAGGREGATOR.instance.getAll(this.getMbean());
    }

    public JMSDestinationMBean lookupDestination(String string) {
        return (JMSDestinationMBean)DESTINATIONAGGREGATOR.instance.lookup(this.getMbean(), string);
    }

    public boolean addDestination(JMSDestinationMBean jMSDestinationMBean) {
        JMSServerMBean jMSServerMBean = (JMSServerMBean)this.getMbean();
        DomainMBean domainMBean = (DomainMBean)jMSServerMBean.getParentBean();
        JMSSystemResourceMBean jMSSystemResourceMBean = JMSBeanHelper.addInteropApplication(domainMBean);
        JMSBean jMSBean = jMSSystemResourceMBean.getJMSResource();
        if (JMSModuleHelper.findDestinationBean(jMSDestinationMBean.getName(), jMSBean) != null) {
            return true;
        }
        if (jMSDestinationMBean instanceof JMSQueueMBean) {
            jMSServerMBean.createChildCopyIncludingObsolete("JMSQueue", jMSDestinationMBean);
            domainMBean.destroyJMSQueue((JMSQueueMBean)jMSDestinationMBean);
        } else {
            jMSServerMBean.createChildCopyIncludingObsolete("JMSTopic", jMSDestinationMBean);
            domainMBean.destroyJMSTopic((JMSTopicMBean)jMSDestinationMBean);
        }
        return true;
    }

    public boolean removeDestination(JMSDestinationMBean jMSDestinationMBean) {
        JMSServerMBean jMSServerMBean = (JMSServerMBean)this.getMbean();
        DomainMBean domainMBean = (DomainMBean)jMSServerMBean.getParentBean();
        if (jMSDestinationMBean instanceof JMSQueueMBean) {
            if (jMSServerMBean.lookupJMSQueue(jMSDestinationMBean.getName()) == null) {
                return true;
            }
            domainMBean.createChildCopyIncludingObsolete("JMSQueue", jMSDestinationMBean);
            jMSServerMBean.destroyJMSQueue((JMSQueueMBean)jMSDestinationMBean);
        } else {
            if (jMSServerMBean.lookupJMSTopic(jMSDestinationMBean.getName()) == null) {
                return true;
            }
            domainMBean.createChildCopyIncludingObsolete("JMSTopic", jMSDestinationMBean);
            jMSServerMBean.destroyJMSTopic((JMSTopicMBean)jMSDestinationMBean);
        }
        return true;
    }

    public void setDestinations(JMSDestinationMBean[] jMSDestinationMBeanArray) throws InvalidAttributeValueException {
        ArrayUtils.computeDiff((Object[])this.getDestinations(), (Object[])jMSDestinationMBeanArray, (ArrayUtils.DiffHandler)new ArrayUtils.DiffHandler(){

            public void addObject(Object object) {
                JMSServer.this.addDestination((JMSDestinationMBean)object);
            }

            public void removeObject(Object object) {
                JMSServer.this.removeDestination((JMSDestinationMBean)object);
            }
        });
    }

    public void _preDestroy() {
        DomainMBean domainMBean = this.delegate == null ? JMSBeanHelper.getDomain(this.getMbean()) : this.delegate;
        JMSInteropModuleMBean jMSInteropModuleMBean = JMSBeanHelper.getJMSInteropModule(domainMBean);
        if (jMSInteropModuleMBean == null) {
            return;
        }
        JMSBean jMSBean = jMSInteropModuleMBean.getJMSResource();
        String string = ((JMSServerMBean)this.getMbean()).getName();
        QueueBean[] queueBeanArray = jMSBean.getQueues();
        for (int i = 0; i < queueBeanArray.length; ++i) {
            QueueBean queueBean = queueBeanArray[i];
            if (!string.equals(queueBean.getSubDeploymentName())) continue;
            jMSBean.destroyQueue(queueBean);
        }
        TopicBean[] topicBeanArray = jMSBean.getTopics();
        for (int i = 0; i < topicBeanArray.length; ++i) {
            TopicBean topicBean = topicBeanArray[i];
            if (!string.equals(topicBean.getSubDeploymentName())) continue;
            jMSBean.destroyTopic(topicBean);
        }
        SubDeploymentMBean subDeploymentMBean = jMSInteropModuleMBean.lookupSubDeployment(string);
        if (subDeploymentMBean != null) {
            jMSInteropModuleMBean.destroySubDeployment(subDeploymentMBean);
        }
    }

    private static class DESTINATIONAGGREGATOR {
        static AttributeAggregator instance = new AttributeAggregator("weblogic.management.configuration.JMSServerMBean", JMSDestinationMBean.class);

        private DESTINATIONAGGREGATOR() {
        }
    }
}

