/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import weblogic.j2ee.descriptor.wl.DestinationBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.QuotaBean;
import weblogic.j2ee.descriptor.wl.TemplateBean;
import weblogic.jms.JMSLogger;
import weblogic.jms.module.JMSBeanHelper;
import weblogic.jms.module.MBeanConverter;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSDestinationMBean;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.management.provider.custom.ConfigurationMBeanCustomizer;

public final class JMSTemplate
extends ConfigurationMBeanCustomizer {
    private DomainMBean domain;
    private TemplateBean delegate;
    private JMSBean interopBean;
    private static final String BYTES_MAXIMUM = "BytesMaximum";
    private static final String MESSAGES_MAXIMUM = "MessagesMaximum";

    public JMSTemplate(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    public void useDelegates(DomainMBean domainMBean, JMSBean jMSBean, TemplateBean templateBean) {
        this.domain = domainMBean;
        this.interopBean = jMSBean;
        this.delegate = templateBean;
    }

    public long getBytesMaximum() {
        if (this.delegate == null) {
            Object object = this.getValue(BYTES_MAXIMUM);
            if (object == null || !(object instanceof Long)) {
                return -1L;
            }
            return (Long)object;
        }
        QuotaBean quotaBean = this.delegate.getQuota();
        if (quotaBean == null) {
            return -1L;
        }
        if (quotaBean.isSet(BYTES_MAXIMUM)) {
            return quotaBean.getBytesMaximum();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytesMaximum(long l) {
        if (this.delegate == null) {
            this.putValue(BYTES_MAXIMUM, new Long(l));
            return;
        }
        long l2 = l;
        if (l < 0L) {
            l = Long.MAX_VALUE;
        }
        String string = this.delegate.getName();
        String string2 = MBeanConverter.constructQuotaNameFromDestinationName(string);
        QuotaBean quotaBean = null;
        try {
            quotaBean = this.interopBean.lookupQuota(string2);
            if (quotaBean == null) {
                quotaBean = this.interopBean.createQuota(string2);
            }
        }
        finally {
            if (quotaBean == null) {
                JMSLogger.logTemplateBytesMaximumNoEffect((String)this.delegate.getName(), (long)l2);
            } else {
                if (l >= 0L) {
                    quotaBean.setBytesMaximum(l);
                } else {
                    quotaBean.unSet(BYTES_MAXIMUM);
                }
                if (quotaBean.isSet(BYTES_MAXIMUM) || quotaBean.isSet(MESSAGES_MAXIMUM)) {
                    this.delegate.setQuota(quotaBean);
                } else {
                    this.delegate.unSet("Quota");
                }
            }
        }
    }

    public long getMessagesMaximum() {
        if (this.delegate == null) {
            Object object = this.getValue(MESSAGES_MAXIMUM);
            if (object == null || !(object instanceof Long)) {
                return -1L;
            }
            return (Long)object;
        }
        QuotaBean quotaBean = this.delegate.getQuota();
        if (quotaBean == null) {
            return -1L;
        }
        if (quotaBean.isSet(MESSAGES_MAXIMUM)) {
            return quotaBean.getMessagesMaximum();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessagesMaximum(long l) {
        if (this.delegate == null) {
            this.putValue(MESSAGES_MAXIMUM, new Long(l));
            return;
        }
        long l2 = l;
        if (l < 0L) {
            l = Long.MAX_VALUE;
        }
        String string = this.delegate.getName();
        String string2 = MBeanConverter.constructQuotaNameFromDestinationName(string);
        QuotaBean quotaBean = null;
        try {
            quotaBean = this.interopBean.lookupQuota(string2);
            if (quotaBean == null) {
                quotaBean = this.interopBean.createQuota(string2);
            }
        }
        finally {
            if (quotaBean == null) {
                JMSLogger.logTemplateMessagesMaximumNoEffect((String)this.delegate.getName(), (long)l2);
            } else {
                if (l >= 0L) {
                    quotaBean.setMessagesMaximum(l);
                } else {
                    quotaBean.unSet(MESSAGES_MAXIMUM);
                }
                if (quotaBean.isSet(BYTES_MAXIMUM) || quotaBean.isSet(MESSAGES_MAXIMUM)) {
                    this.delegate.setQuota(quotaBean);
                } else {
                    this.delegate.unSet("Quota");
                }
            }
        }
    }

    public JMSDestinationMBean getErrorDestination() {
        if (this.delegate == null) {
            Object object = this.getValue("ErrorDestination");
            if (object == null || !(object instanceof JMSDestinationMBean)) {
                return null;
            }
            return (JMSDestinationMBean)object;
        }
        DestinationBean destinationBean = this.delegate.getDeliveryFailureParams().getErrorDestination();
        if (destinationBean == null) {
            return null;
        }
        return MBeanConverter.findErrorQueue(this.domain, destinationBean.getName());
    }

    public void setErrorDestination(JMSDestinationMBean jMSDestinationMBean) {
        if (this.delegate == null) {
            this.putValue("ErrorDestination", jMSDestinationMBean);
        } else {
            String string = jMSDestinationMBean == null ? null : jMSDestinationMBean.getName();
            DestinationBean destinationBean = JMSBeanHelper.findDestinationBean(string, this.interopBean);
            this.delegate.getDeliveryFailureParams().setErrorDestination(destinationBean);
        }
    }

    public long getBytesThresholdHigh() {
        if (this.delegate == null) {
            Object object = this.getValue("BytesThresholdHigh");
            if (object == null || !(object instanceof Long)) {
                return -1L;
            }
            return (Long)object;
        }
        return this.delegate.getThresholds().getBytesHigh();
    }

    public void setBytesThresholdHigh(long l) {
        if (this.delegate == null) {
            this.putValue("BytesThresholdHigh", new Long(l));
        } else {
            this.delegate.getThresholds().setBytesHigh(l);
        }
    }

    public long getBytesThresholdLow() {
        if (this.delegate == null) {
            Object object = this.getValue("BytesThresholdLow");
            if (object == null || !(object instanceof Long)) {
                return -1L;
            }
            return (Long)object;
        }
        return this.delegate.getThresholds().getBytesLow();
    }

    public void setBytesThresholdLow(long l) {
        if (this.delegate == null) {
            this.putValue("BytesThresholdLow", new Long(l));
        } else {
            this.delegate.getThresholds().setBytesLow(l);
        }
    }

    public long getMessagesThresholdHigh() {
        if (this.delegate == null) {
            Object object = this.getValue("MessagesThresholdHigh");
            if (object == null || !(object instanceof Long)) {
                return -1L;
            }
            return (Long)object;
        }
        return this.delegate.getThresholds().getMessagesHigh();
    }

    public void setMessagesThresholdHigh(long l) {
        if (this.delegate == null) {
            this.putValue("MessagesThresholdHigh", new Long(l));
        } else {
            this.delegate.getThresholds().setMessagesHigh(l);
        }
    }

    public long getMessagesThresholdLow() {
        if (this.delegate == null) {
            Object object = this.getValue("MessagesThresholdLow");
            if (object == null || !(object instanceof Long)) {
                return -1L;
            }
            return (Long)object;
        }
        return this.delegate.getThresholds().getMessagesLow();
    }

    public void setMessagesThresholdLow(long l) {
        if (this.delegate == null) {
            this.putValue("MessagesThresholdLow", new Long(l));
        } else {
            this.delegate.getThresholds().setMessagesLow(l);
        }
    }

    public int getPriorityOverride() {
        if (this.delegate == null) {
            Object object = this.getValue("PriorityOverride");
            if (object == null || !(object instanceof Integer)) {
                return -1;
            }
            return (Integer)object;
        }
        return this.delegate.getDeliveryParamsOverrides().getPriority();
    }

    public void setPriorityOverride(int n) {
        if (this.delegate == null) {
            this.putValue("PriorityOverride", new Integer(n));
        } else {
            this.delegate.getDeliveryParamsOverrides().setPriority(n);
        }
    }

    public String getTimeToDeliverOverride() {
        if (this.delegate == null) {
            Object object = this.getValue("TimeToDeliverOverride");
            if (object == null || !(object instanceof String)) {
                return "-1";
            }
            return (String)object;
        }
        return this.delegate.getDeliveryParamsOverrides().getTimeToDeliver();
    }

    public void setTimeToDeliverOverride(String string) {
        if (this.delegate == null) {
            this.putValue("TimeToDeliverOverride", string);
        } else {
            this.delegate.getDeliveryParamsOverrides().setTimeToDeliver(string);
        }
    }

    public long getRedeliveryDelayOverride() {
        if (this.delegate == null) {
            Object object = this.getValue("RedeliveryDelayOverride");
            if (object == null || !(object instanceof Long)) {
                return -1L;
            }
            return (Long)object;
        }
        return this.delegate.getDeliveryParamsOverrides().getRedeliveryDelay();
    }

    public void setRedeliveryDelayOverride(long l) {
        if (this.delegate == null) {
            this.putValue("RedeliveryDelayOverride", new Long(l));
        } else {
            this.delegate.getDeliveryParamsOverrides().setRedeliveryDelay(l);
        }
    }

    public int getRedeliveryLimit() {
        if (this.delegate == null) {
            Object object = this.getValue("RedeliveryLimit");
            if (object == null || !(object instanceof Integer)) {
                return -1;
            }
            return (Integer)object;
        }
        return this.delegate.getDeliveryFailureParams().getRedeliveryLimit();
    }

    public void setRedeliveryLimit(int n) {
        if (this.delegate == null) {
            this.putValue("RedeliveryLimit", new Integer(n));
        } else {
            this.delegate.getDeliveryFailureParams().setRedeliveryLimit(n);
        }
    }

    public long getTimeToLiveOverride() {
        if (this.delegate == null) {
            Object object = this.getValue("TimeToLiveOverride");
            if (object == null || !(object instanceof Long)) {
                return -1L;
            }
            return (Long)object;
        }
        return this.delegate.getDeliveryParamsOverrides().getTimeToLive();
    }

    public void setTimeToLiveOverride(long l) {
        if (this.delegate == null) {
            this.putValue("TimeToLiveOverride", new Long(l));
        } else {
            this.delegate.getDeliveryParamsOverrides().setTimeToLive(l);
        }
    }

    public String getDeliveryModeOverride() {
        if (this.delegate == null) {
            Object object = this.getValue("DeliveryModeOverride");
            if (object == null || !(object instanceof String)) {
                return "No-Delivery";
            }
            return (String)object;
        }
        return this.delegate.getDeliveryParamsOverrides().getDeliveryMode();
    }

    public void setDeliveryModeOverride(String string) {
        if (this.delegate == null) {
            this.putValue("DeliveryModeOverride", string);
        } else {
            this.delegate.getDeliveryParamsOverrides().setDeliveryMode(string);
        }
    }

    public String getExpirationPolicy() {
        if (this.delegate == null) {
            Object object = this.getValue("ExpirationPolicy");
            if (object == null || !(object instanceof String)) {
                return "Discard";
            }
            return (String)object;
        }
        return this.delegate.getDeliveryFailureParams().getExpirationPolicy();
    }

    public void setExpirationPolicy(String string) {
        if (this.delegate == null) {
            this.putValue("ExpirationPolicy", string);
        } else {
            this.delegate.getDeliveryFailureParams().setExpirationPolicy(string);
        }
    }

    public String getExpirationLoggingPolicy() {
        if (this.delegate == null) {
            Object object = this.getValue("ExpirationLoggingPolicy");
            if (object == null || !(object instanceof String)) {
                return null;
            }
            return (String)object;
        }
        return this.delegate.getDeliveryFailureParams().getExpirationLoggingPolicy();
    }

    public void setExpirationLoggingPolicy(String string) {
        if (this.delegate == null) {
            this.putValue("ExpirationLoggingPolicy", string);
        } else {
            this.delegate.getDeliveryFailureParams().setExpirationLoggingPolicy(string);
        }
    }

    public int getMaximumMessageSize() {
        if (this.delegate == null) {
            Object object = this.getValue("MaximumMessageSize");
            if (object == null || !(object instanceof Integer)) {
                return Integer.MAX_VALUE;
            }
            return (Integer)object;
        }
        return this.delegate.getMaximumMessageSize();
    }

    public void setMaximumMessageSize(int n) {
        if (this.delegate == null) {
            this.putValue("MaximumMessageSize", new Integer(n));
        } else {
            this.delegate.setMaximumMessageSize(n);
        }
    }

    public String getNotes() {
        if (this.delegate == null) {
            Object object = this.getValue("Notes");
            if (object == null || !(object instanceof String)) {
                return null;
            }
            return (String)object;
        }
        return this.delegate.getNotes();
    }

    public void setNotes(String string) {
        if (this.delegate == null) {
            this.putValue("Notes", string);
        } else {
            this.delegate.setNotes(string);
        }
    }
}

