/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import weblogic.common.internal.PackageInfo;
import weblogic.common.internal.VersionInfo;
import weblogic.logging.LoggingConfigurationProcessor;
import weblogic.logging.Severities;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.KernelDebugMBean;
import weblogic.management.configuration.KernelMBean;
import weblogic.management.configuration.LogMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.management.provider.custom.ConfigurationMBeanCustomizer;

public class Kernel
extends ConfigurationMBeanCustomizer {
    private static final boolean DEBUG = false;
    private static final String STDOUT_SEVERITY = "StdoutSeverity";
    private int stdoutSeverityLevel = 32;
    private boolean stdoutDebugEnabled = false;
    private boolean stdoutEnabled = true;
    private String stdoutFormat = "standard";
    private boolean stdoutLogStack = true;
    static final VersionInfo diabloVersion = new VersionInfo("9.0.0.0");

    public Kernel(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    public int getStdoutSeverityLevel() {
        if (this.isDelegateModeEnabled()) {
            return Severities.severityStringToNum((String)this.getLogMBean().getStdoutSeverity());
        }
        return this.stdoutSeverityLevel;
    }

    public void setStdoutSeverityLevel(int n) {
        this.stdoutSeverityLevel = n;
        if (this.isDelegateModeEnabled()) {
            this.updateLogMBeanStdoutSeverity();
        }
    }

    public boolean isStdoutDebugEnabled() {
        if (this.isDelegateModeEnabled()) {
            return Severities.severityStringToNum((String)this.getLogMBean().getStdoutSeverity()) >= 128;
        }
        return this.stdoutDebugEnabled;
    }

    public void setStdoutDebugEnabled(boolean bl) {
        this.stdoutDebugEnabled = bl;
        if (this.isDelegateModeEnabled()) {
            this.updateLogMBeanStdoutSeverity();
        }
    }

    public boolean isStdoutEnabled() {
        if (this.isDelegateModeEnabled()) {
            return Severities.severityStringToNum((String)this.getLogMBean().getStdoutSeverity()) > 0;
        }
        return this.stdoutEnabled;
    }

    public void setStdoutEnabled(boolean bl) {
        this.stdoutEnabled = bl;
        if (this.isDelegateModeEnabled()) {
            this.updateLogMBeanStdoutSeverity();
        }
    }

    private void updateLogMBeanStdoutSeverity() {
        LogMBean logMBean = ((KernelMBean)this.getMbean()).getLog();
        String string = LoggingConfigurationProcessor.getNormalizedStdoutSeverity(this.stdoutEnabled, this.stdoutSeverityLevel, this.stdoutDebugEnabled);
        logMBean.setStdoutSeverity(string);
        if (string.equals("Notice")) {
            logMBean.unSet(STDOUT_SEVERITY);
        }
    }

    public String getStdoutFormat() {
        if (this.isDelegateModeEnabled()) {
            return this.getLogMBean().getStdoutFormat();
        }
        return this.stdoutFormat;
    }

    public void setStdoutFormat(String string) {
        this.stdoutFormat = string;
        if (this.isDelegateModeEnabled()) {
            LogMBean logMBean = ((KernelMBean)this.getMbean()).getLog();
            logMBean.setStdoutFormat(string);
            if (string.equals("standard")) {
                logMBean.unSet("StdoutFormat");
            }
        }
    }

    public boolean isStdoutLogStack() {
        if (this.isDelegateModeEnabled()) {
            return this.getLogMBean().isStdoutLogStack();
        }
        return this.stdoutLogStack;
    }

    public void setStdoutLogStack(boolean bl) {
        this.stdoutLogStack = bl;
        if (this.isDelegateModeEnabled()) {
            LogMBean logMBean = ((KernelMBean)this.getMbean()).getLog();
            logMBean.setStdoutLogStack(bl);
            if (bl) {
                logMBean.unSet("StdoutLogStack");
            }
        }
    }

    private LogMBean getLogMBean() {
        return ((KernelMBean)this.getMbean()).getLog();
    }

    public KernelDebugMBean getKernelDebug() {
        return ((ServerMBean)this.getMbean()).getServerDebug();
    }

    protected boolean isDelegateModeEnabled() {
        DomainMBean domainMBean = (DomainMBean)this.getMbean().getDescriptor().getRootBean();
        String string = domainMBean.getConfigurationVersion();
        if (string == null) {
            return false;
        }
        VersionInfo versionInfo = new VersionInfo(string);
        return !versionInfo.earlierThan((PackageInfo)diabloVersion);
    }
}

