/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import java.io.File;
import java.security.AccessController;
import weblogic.management.DomainDir;
import weblogic.management.configuration.LogFileMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.management.provider.custom.ConfigurationMBeanCustomizer;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class LogFile
extends ConfigurationMBeanCustomizer {
    private static final long serialVersionUID = 7988658427199784266L;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public LogFile() {
        this(null);
    }

    public LogFile(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    public String computeLogFilePath() {
        File file;
        LogFileMBean logFileMBean = (LogFileMBean)this.getMbean();
        String string = logFileMBean.getFileName();
        if (string == null) {
            string = "logs/" + logFileMBean.getName() + ".log";
        }
        if ((file = new File(string)).isAbsolute()) {
            return file.getAbsolutePath();
        }
        String string2 = ManagementService.getPropertyService(kernelId).getServerName();
        return DomainDir.getPathRelativeServerDir((String)string2, (String)string);
    }
}

