/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import javax.management.InvalidAttributeValueException;
import weblogic.common.internal.PackageInfo;
import weblogic.common.internal.VersionInfo;
import weblogic.diagnostics.i18n.DiagnosticsTextTextFormatter;
import weblogic.diagnostics.logging.LogVariablesImpl;
import weblogic.diagnostics.query.Query;
import weblogic.diagnostics.query.QueryException;
import weblogic.diagnostics.query.QueryFactory;
import weblogic.diagnostics.query.VariableDeclarator;
import weblogic.diagnostics.query.VariableIndexResolver;
import weblogic.logging.LoggingConfigurationProcessor;
import weblogic.logging.Severities;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.LogFilterMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.management.provider.custom.ConfigurationMBeanCustomizer;

public class LogFilter
extends ConfigurationMBeanCustomizer {
    private int severityLevel = 16;
    private String[] userIds;
    private String[] subSystems;
    private String filterExpr = "";
    private Query query;
    private static final VersionInfo diabloVersion = new VersionInfo("9.0.0.0");

    public LogFilter(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    public int getSeverityLevel() {
        return this.severityLevel;
    }

    public void setSeverityLevel(int n) {
        this.severityLevel = n;
        LogFilterMBean logFilterMBean = (LogFilterMBean)this.getMbean();
        if (!this.isDelegateModeEnabled()) {
            return;
        }
        String string = logFilterMBean.getName();
        DomainMBean domainMBean = (DomainMBean)this.getMbean().getParent();
        if (domainMBean == null) {
            return;
        }
        ServerMBean[] serverMBeanArray = domainMBean.getServers();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            ServerMBean serverMBean = serverMBeanArray[i];
            LogFilterMBean logFilterMBean2 = serverMBean.getLog().getDomainLogBroadcastFilter();
            if (logFilterMBean2 == null || !logFilterMBean2.getName().equals(string)) continue;
            serverMBean.getLog().setDomainLogBroadcastSeverity(Severities.severityNumToString((int)this.severityLevel));
        }
    }

    public String[] getSubsystemNames() {
        return this.subSystems;
    }

    public void setSubsystemNames(String[] stringArray) throws InvalidAttributeValueException {
        this.subSystems = stringArray;
        if (this.isDelegateModeEnabled()) {
            this.computeFilterExpression();
        }
    }

    public String[] getUserIds() {
        return this.userIds;
    }

    public void setUserIds(String[] stringArray) throws InvalidAttributeValueException {
        this.userIds = stringArray;
        if (this.isDelegateModeEnabled()) {
            this.computeFilterExpression();
        }
    }

    protected boolean isDelegateModeEnabled() {
        DomainMBean domainMBean = (DomainMBean)this.getMbean().getDescriptor().getRootBean();
        String string = domainMBean.getConfigurationVersion();
        if (string == null) {
            return false;
        }
        VersionInfo versionInfo = new VersionInfo(string);
        return !versionInfo.earlierThan((PackageInfo)diabloVersion);
    }

    public String getFilterExpression() {
        if (this.filterExpr == null) {
            return "";
        }
        return this.filterExpr;
    }

    public void setFilterExpression(String string) throws InvalidAttributeValueException {
        try {
            this.query = LogFilter.createQuery(string);
            this.filterExpr = string;
        }
        catch (QueryException queryException) {
            String string2 = DiagnosticsTextTextFormatter.getInstance().getInvalidQueryExpressionText(string);
            throw new InvalidAttributeValueException(string2);
        }
    }

    public Query getQuery() {
        return this.query;
    }

    private void computeFilterExpression() throws InvalidAttributeValueException {
        String string = LoggingConfigurationProcessor.convertOldAttrsToFilterExpression(this.userIds, this.subSystems);
        ((LogFilterMBean)this.getMbean()).setFilterExpression(string);
    }

    private static Query createQuery(String string) throws QueryException {
        if (string != null && string.length() > 0) {
            LogVariablesImpl logVariablesImpl = LogVariablesImpl.getInstance();
            return QueryFactory.createQuery((VariableDeclarator)logVariablesImpl, (VariableIndexResolver)logVariablesImpl, (String)string);
        }
        return null;
    }
}

