/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.cluster.ClusterService;
import weblogic.cluster.singleton.LeasingException;
import weblogic.cluster.singleton.MigratableServerService;
import weblogic.cluster.singleton.SingletonMonitorRemote;
import weblogic.jndi.Environment;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.management.provider.custom.ConfigurationMBeanCustomizer;
import weblogic.protocol.URLManager;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.Debug;

public class MigratableTarget
extends ConfigurationMBeanCustomizer {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private transient ServerMBean userPreferredServer;
    private String _userPreferredServerName;
    private static final ServerMBean[] NO_SERVERS = new ServerMBean[0];

    public MigratableTarget(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    private SingletonMonitorRemote getSingletonMonitor(ClusterMBean clusterMBean) {
        SingletonMonitorRemote singletonMonitorRemote;
        block7: {
            singletonMonitorRemote = null;
            try {
                if (ClusterService.getServices() == null) {
                    ServerMBean[] serverMBeanArray = clusterMBean.getServers();
                    for (int i = 0; i < serverMBeanArray.length; ++i) {
                        try {
                            String string = URLManager.findAdministrationURL(serverMBeanArray[i].getName());
                            singletonMonitorRemote = this.getSingletonMonitorRemote(string);
                            if (singletonMonitorRemote == null) continue;
                            return singletonMonitorRemote;
                        }
                        catch (UnknownHostException unknownHostException) {
                            // empty catch block
                        }
                    }
                    break block7;
                }
                String string = MigratableServerService.theOne().findSingletonMaster();
                if (string != null) {
                    MigratableServerService.theOne();
                    String string2 = MigratableServerService.findURLOfUnconnectedServer(string);
                    singletonMonitorRemote = this.getSingletonMonitorRemote(string2);
                }
            }
            catch (LeasingException leasingException) {
                // empty catch block
            }
        }
        return singletonMonitorRemote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SingletonMonitorRemote getSingletonMonitorRemote(String string) {
        SingletonMonitorRemote singletonMonitorRemote;
        Environment environment = new Environment();
        Context context = null;
        try {
            if (string == null) {
                SingletonMonitorRemote singletonMonitorRemote2 = null;
                return singletonMonitorRemote2;
            }
            environment.setProviderUrl(string);
            context = environment.getInitialContext();
            singletonMonitorRemote = (SingletonMonitorRemote)context.lookup("weblogic/cluster/singleton/SingletonMonitorRemote");
        }
        catch (NamingException namingException) {
            SingletonMonitorRemote singletonMonitorRemote3 = null;
            return singletonMonitorRemote3;
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException namingException) {}
            }
        }
        return singletonMonitorRemote;
    }

    public ServerMBean getHostingServer() {
        if (ManagementService.getRuntimeAccess(kernelId) == null) {
            return this.guessHostingServer();
        }
        MigratableTargetMBean migratableTargetMBean = (MigratableTargetMBean)this.getMbean();
        String string = null;
        if (!"manual".equals(migratableTargetMBean.getMigrationPolicy())) {
            Object object;
            ConfigurationMBean configurationMBean = (ConfigurationMBean)this.getMbean().getParent();
            if (configurationMBean instanceof ServerMBean) {
                return (ServerMBean)configurationMBean;
            }
            try {
                object = this.getSingletonMonitor(migratableTargetMBean.getCluster());
                if (object == null) {
                    return this.guessHostingServer();
                }
                string = object.findServiceLocation(migratableTargetMBean.getName());
            }
            catch (RemoteException remoteException) {
                return this.guessHostingServer();
            }
            if (configurationMBean instanceof DomainMBean && string != null) {
                object = (DomainMBean)configurationMBean;
                return object.lookupServer(string);
            }
        }
        return this.guessHostingServer();
    }

    private ServerMBean guessHostingServer() {
        MigratableTargetMBean migratableTargetMBean = (MigratableTargetMBean)this.getMbean();
        if ("manual".equals(migratableTargetMBean.getMigrationPolicy())) {
            return this.getUserPreferredServer();
        }
        return null;
    }

    public ServerMBean[] getAllCandidateServers() {
        MigratableTargetMBean migratableTargetMBean = (MigratableTargetMBean)this.getMbean();
        if (migratableTargetMBean == null) {
            return NO_SERVERS;
        }
        if (migratableTargetMBean.getConstrainedCandidateServers() != null && migratableTargetMBean.getConstrainedCandidateServers().length > 0) {
            return this.moveUserPreferredServerToHead(migratableTargetMBean.getConstrainedCandidateServers());
        }
        if (migratableTargetMBean.getCluster() != null && migratableTargetMBean.getCluster().getServers().length > 0) {
            return this.moveUserPreferredServerToHead(migratableTargetMBean.getCluster().getServers());
        }
        return NO_SERVERS;
    }

    public boolean isManualActiveOn(ServerMBean serverMBean) {
        return this.getUserPreferredServer().getName().equals(serverMBean.getName());
    }

    public boolean isCandidate(ServerMBean serverMBean) {
        ServerMBean[] serverMBeanArray = ((MigratableTargetMBean)this.getMbean()).getAllCandidateServers();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            if (!serverMBean.getName().equals(serverMBeanArray[i].getName())) continue;
            return true;
        }
        return false;
    }

    public ServerMBean getUserPreferredServer() {
        if (this.userPreferredServer == null && this._userPreferredServerName != null) {
            ConfigurationMBean configurationMBean = (ConfigurationMBean)this.getMbean().getParent();
            if (configurationMBean instanceof ServerMBean) {
                configurationMBean = (ConfigurationMBean)configurationMBean.getParent();
            }
            if (configurationMBean instanceof DomainMBean) {
                DomainMBean domainMBean = (DomainMBean)configurationMBean;
                this.userPreferredServer = domainMBean.lookupServer(this._userPreferredServerName);
            }
        }
        return this.userPreferredServer;
    }

    public void setUserPreferredServer(ServerMBean serverMBean) {
        this.userPreferredServer = serverMBean;
        if (serverMBean != null) {
            this._userPreferredServerName = serverMBean.getName();
            ClusterMBean clusterMBean = serverMBean.getCluster();
            MigratableTargetMBean migratableTargetMBean = (MigratableTargetMBean)this.getMbean();
            if (migratableTargetMBean.getCluster() == null && clusterMBean != null) {
                migratableTargetMBean.setCluster(clusterMBean);
                if (clusterMBean == null) {
                    Debug.assertion((migratableTargetMBean.getCluster() == null ? 1 : 0) != 0);
                } else {
                    ClusterMBean clusterMBean2 = migratableTargetMBean.getCluster();
                    Debug.assertion((clusterMBean2 != null ? 1 : 0) != 0, (String)"Migratable Target Cluster is null");
                    Debug.assertion((clusterMBean.getName() != null ? 1 : 0) != 0, (String)"Cluster name is null");
                    Debug.assertion((boolean)clusterMBean.getName().equals(clusterMBean2.getName()));
                }
            }
        }
    }

    public Set getServerNames() {
        ServerMBean[] serverMBeanArray = this.getAllCandidateServers();
        HashSet<String> hashSet = new HashSet<String>(serverMBeanArray.length);
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            hashSet.add(serverMBeanArray[i].getName());
        }
        return hashSet;
    }

    private ServerMBean[] moveUserPreferredServerToHead(ServerMBean[] serverMBeanArray) {
        Debug.assertion((this.getUserPreferredServer() != null ? 1 : 0) != 0);
        ServerMBean serverMBean = this.getUserPreferredServer();
        String string = serverMBean.getName();
        if (serverMBeanArray[0].getName().equals(string)) {
            return serverMBeanArray;
        }
        for (int i = 1; i < serverMBeanArray.length; ++i) {
            ServerMBean serverMBean2 = serverMBeanArray[i];
            if (!string.equals(serverMBean2.getName())) continue;
            ServerMBean serverMBean3 = serverMBeanArray[0];
            serverMBeanArray[0] = serverMBeanArray[i];
            serverMBeanArray[i] = serverMBean3;
            return serverMBeanArray;
        }
        ServerMBean[] serverMBeanArray2 = new ServerMBean[serverMBeanArray.length + 1];
        System.arraycopy(serverMBeanArray, 0, serverMBeanArray2, 1, serverMBeanArray.length);
        serverMBeanArray2[0] = serverMBean;
        return serverMBeanArray2;
    }
}

