/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import javax.management.InvalidAttributeValueException;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementLogger;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.internal.ManagementTextTextFormatter;
import weblogic.management.provider.ConfigurationProcessor;
import weblogic.utils.Debug;

public class MigratableTargetConfigProcessor
implements ConfigurationProcessor {
    public void updateConfiguration(DomainMBean domainMBean) {
        ServerMBean[] serverMBeanArray = domainMBean.getServers();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            ServerMBean serverMBean = serverMBeanArray[i];
            if (serverMBean.getCluster() == null) continue;
            MigratableTargetConfigProcessor.createDefaultMigratableTargets(domainMBean, serverMBean);
        }
    }

    public static void destroyDefaultMigratableTarget(ServerMBean serverMBean) {
        String string = MigratableTargetConfigProcessor.getNameOfDefaultMigratableTargetFor(serverMBean);
        DomainMBean domainMBean = (DomainMBean)serverMBean.getParent();
        MigratableTargetMBean migratableTargetMBean = domainMBean.lookupMigratableTarget(string);
        if (migratableTargetMBean != null) {
            domainMBean.destroyMigratableTarget(migratableTargetMBean);
        }
    }

    public static void createDefaultMigratableTargets(DomainMBean domainMBean, ServerMBean serverMBean) {
        MigratableTargetMBean migratableTargetMBean;
        Object object;
        if (serverMBean.getJTAMigratableTarget() == null) {
            object = serverMBean.createJTAMigratableTarget();
            object.setCluster(serverMBean.getCluster());
            object.setUserPreferredServer(serverMBean);
        }
        if ((migratableTargetMBean = domainMBean.lookupMigratableTarget((String)(object = MigratableTargetConfigProcessor.getNameOfDefaultMigratableTargetFor(serverMBean)))) == null) {
            migratableTargetMBean = domainMBean.createMigratableTarget((String)object);
        }
        try {
            migratableTargetMBean.setUserPreferredServer(serverMBean);
            migratableTargetMBean.setNotes(ManagementTextTextFormatter.getInstance().getDefaultServerMigratableTargetNote());
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            Debug.assertion((boolean)false, (String)invalidAttributeValueException.toString());
        }
        catch (DistributedManagementException distributedManagementException) {
            ManagementLogger.logDomainSaveFailed((Throwable)distributedManagementException);
        }
    }

    public static String getNameOfDefaultMigratableTargetFor(ServerMBean serverMBean) {
        return serverMBean.getName() + " (" + ManagementTextTextFormatter.getInstance().getDefaultMigratableSuffix() + ")";
    }
}

