/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import java.util.Locale;
import weblogic.descriptor.SettableBean;
import weblogic.management.configuration.KernelMBean;
import weblogic.management.configuration.NetworkAccessPointMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.protocol.ProtocolManager;

public final class NetworkAccessPoint {
    private static final long serialVersionUID = 7259163894528106650L;
    private static final String LISTEN_ADDRESS = "ListenAddress";
    private static final String PUBLIC_ADDRESS = "PublicAddress";
    private static final String EXTERNAL_ADDRESS = "ExternalDNSName";
    private static final String CLUSTER_ADDRESS = "ClusterAddress";

    public static String getPublicAddress(NetworkAccessPointMBean networkAccessPointMBean) {
        if (networkAccessPointMBean.isSet(EXTERNAL_ADDRESS)) {
            return networkAccessPointMBean.getExternalDNSName();
        }
        if (networkAccessPointMBean.isSet(LISTEN_ADDRESS)) {
            return networkAccessPointMBean.getListenAddress();
        }
        if (((SettableBean)networkAccessPointMBean.getParent()).isSet(EXTERNAL_ADDRESS)) {
            return ((ServerMBean)networkAccessPointMBean.getParent()).getExternalDNSName();
        }
        return networkAccessPointMBean.getListenAddress();
    }

    public static String getClusterAddress(NetworkAccessPointMBean networkAccessPointMBean) {
        if (networkAccessPointMBean.isSet(PUBLIC_ADDRESS)) {
            return networkAccessPointMBean.getPublicAddress();
        }
        if (networkAccessPointMBean.isSet(EXTERNAL_ADDRESS)) {
            return networkAccessPointMBean.getExternalDNSName();
        }
        if (((ServerMBean)networkAccessPointMBean.getParent()).getCluster() != null && ((ServerMBean)networkAccessPointMBean.getParent()).getCluster().isSet(CLUSTER_ADDRESS)) {
            return ((ServerMBean)networkAccessPointMBean.getParent()).getCluster().getClusterAddress();
        }
        return networkAccessPointMBean.getListenAddress();
    }

    public static int getMaxMessageSize(NetworkAccessPointMBean networkAccessPointMBean) {
        String string = networkAccessPointMBean.getProtocol().toUpperCase(Locale.US);
        if (string.endsWith("S")) {
            string = string.substring(0, string.length() - 1);
        }
        int n = -1;
        if (string.equals("HTTP")) {
            n = ((KernelMBean)networkAccessPointMBean.getParent()).getMaxHTTPMessageSize();
        } else if (string.equals("T3")) {
            n = ((KernelMBean)networkAccessPointMBean.getParent()).getMaxT3MessageSize();
        } else if (string.equals("IIOP")) {
            n = ((KernelMBean)networkAccessPointMBean.getParent()).getMaxIIOPMessageSize();
        } else if (string.equals("COM")) {
            n = ((KernelMBean)networkAccessPointMBean.getParent()).getMaxCOMMessageSize();
        }
        if (n == -1) {
            n = ((KernelMBean)networkAccessPointMBean.getParent()).getMaxMessageSize();
        }
        return n;
    }

    public static boolean isSecure(NetworkAccessPointMBean networkAccessPointMBean) {
        byte by = ProtocolManager.getProtocolByName((String)networkAccessPointMBean.getProtocol()).getQOS();
        return by == 102 || by == 103;
    }
}

