/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import weblogic.management.configuration.RealmException;
import weblogic.management.configuration.RealmManager;
import weblogic.management.internal.RemoteRealmManagerImpl;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.management.provider.custom.ConfigurationMBeanCustomizer;
import weblogic.security.acl.BasicRealm;
import weblogic.security.acl.RefreshableRealm;

public final class Realm
extends ConfigurationMBeanCustomizer {
    private static final long serialVersionUID = -1624882119477172375L;
    private RealmManager realmManager;

    public Realm(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    public void refresh() throws RealmException {
        if (this.isAdmin()) {
            return;
        }
        BasicRealm basicRealm = weblogic.security.acl.Realm.getRealm("weblogic");
        if (basicRealm instanceof RefreshableRealm) {
            try {
                ((RefreshableRealm)basicRealm).refresh();
            }
            catch (Throwable throwable) {
                throw new RealmException("The realm didn't successfully refresh", throwable);
            }
        } else {
            throw new RealmException("The realm doesn't support refresh.");
        }
    }

    public synchronized RealmManager manager() {
        if (this.realmManager == null) {
            this.realmManager = new RealmManager(new RemoteRealmManagerImpl());
        }
        return this.realmManager;
    }
}

