/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import javax.management.InvalidAttributeValueException;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.SecurityConfigurationMBean;
import weblogic.management.configuration.SecurityMBean;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.management.provider.custom.ConfigurationMBeanCustomizer;

public final class Security
extends ConfigurationMBeanCustomizer {
    private boolean isInConstructor = true;

    private boolean constructed() {
        return !this.isInConstructor;
    }

    public void _postCreate() {
        this.isInConstructor = false;
    }

    public Security(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    private SecurityConfigurationMBean getSecurityConfiguration() {
        SecurityMBean securityMBean = (SecurityMBean)this.getMbean();
        DomainMBean domainMBean = (DomainMBean)securityMBean.getParent();
        return domainMBean.getSecurityConfiguration();
    }

    public synchronized byte[] getSalt() {
        return this.getSecurityConfiguration().getSalt();
    }

    public synchronized byte[] getEncryptedSecretKey() {
        return this.getSecurityConfiguration().getEncryptedSecretKey();
    }

    public String getSystemUser() {
        return new String("system");
    }

    public void setSystemUser(String string) {
    }

    public String getConnectionFilter() {
        return this.constructed() ? this.getSecurityConfiguration().getConnectionFilter() : null;
    }

    public void setConnectionFilter(String string) throws InvalidAttributeValueException {
        if (this.constructed()) {
            this.getSecurityConfiguration().setConnectionFilter(string);
        }
    }

    public String[] getConnectionFilterRules() {
        return this.constructed() ? this.getSecurityConfiguration().getConnectionFilterRules() : null;
    }

    public void setConnectionFilterRules(String[] stringArray) {
        if (this.constructed()) {
            this.getSecurityConfiguration().setConnectionFilterRules(stringArray);
        }
    }

    public boolean getConnectionLoggerEnabled() {
        return this.constructed() ? this.getSecurityConfiguration().getConnectionLoggerEnabled() : false;
    }

    public void setConnectionLoggerEnabled(boolean bl) throws InvalidAttributeValueException {
        if (this.constructed()) {
            this.getSecurityConfiguration().setConnectionLoggerEnabled(bl);
        }
    }
}

