/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import java.util.Vector;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import weblogic.descriptor.DescriptorBean;
import weblogic.management.ManagementLogger;
import weblogic.management.commo.StandardInterface;
import weblogic.management.configuration.ConfigurationError;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.SecurityConfigurationMBean;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.management.provider.custom.ConfigurationMBeanCustomizer;
import weblogic.management.security.ProviderMBean;
import weblogic.management.security.RealmMBean;
import weblogic.security.Salt;
import weblogic.security.internal.SerializedSystemIni;
import weblogic.security.internal.encryption.ClearOrEncryptedService;

public final class SecurityConfiguration
extends ConfigurationMBeanCustomizer {
    private boolean _initialized = false;
    private byte[] _salt;
    private byte[] _encryptedSecretKey;
    private static ClearOrEncryptedService encryptionService;
    private static final boolean DEBUG = false;

    private void debug(String string) {
    }

    private static ClearOrEncryptedService getEncryptionService() {
        if (encryptionService == null) {
            encryptionService = new ClearOrEncryptedService(SerializedSystemIni.getEncryptionService());
        }
        return encryptionService;
    }

    public SecurityConfiguration(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    public void _postCreate() {
        this._initialized = true;
    }

    private SecurityConfigurationMBean getMyMBean() {
        return (SecurityConfigurationMBean)this.getMbean();
    }

    public RealmMBean createRealm(String string) throws JMException {
        ConfigurationValidator.validateName(string);
        SecurityConfigurationMBean securityConfigurationMBean = this.getMyMBean();
        RealmMBean realmMBean = null;
        try {
            Class<?> clazz = Class.forName("weblogic.management.security.RealmMBeanImpl");
            Constructor<?> constructor = clazz.getConstructor(DescriptorBean.class, Integer.TYPE);
            realmMBean = (RealmMBean)constructor.newInstance(securityConfigurationMBean, new Integer(-1));
            realmMBean.setName(string);
            Method method = securityConfigurationMBean.getClass().getMethod("addRealm", RealmMBean.class);
            method.invoke((Object)securityConfigurationMBean, realmMBean);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof JMException) {
                throw (JMException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return realmMBean;
    }

    public RealmMBean[] findRealms() {
        return this.getMyMBean().getRealms();
    }

    public RealmMBean findDefaultRealm() {
        return this.getMyMBean().getDefaultRealm();
    }

    public RealmMBean findRealm(String string) {
        return this.getMyMBean().lookupRealm(string);
    }

    public RealmMBean getDefaultRealmInternal() {
        return this.getMyMBean().getDefaultRealm();
    }

    public void setDefaultRealmInternal(RealmMBean realmMBean) {
        try {
            this.getMyMBean().setDefaultRealm(realmMBean);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new IllegalArgumentException(invalidAttributeValueException.toString());
        }
    }

    public synchronized byte[] getSalt() {
        if (this._salt == null) {
            try {
                byte[] byArray = SerializedSystemIni.getSalt();
                if (byArray == null || byArray.length < 1) {
                    throw new ConfigurationError("Empty salt: " + byArray);
                }
                this._salt = byArray;
            }
            catch (Exception exception) {
                ManagementLogger.logExceptionInCustomizer((Throwable)exception);
            }
        }
        return this._salt;
    }

    public synchronized byte[] getEncryptedSecretKey() {
        if (this._encryptedSecretKey == null) {
            try {
                if (!this.isAdmin() && !(this.getMbean() instanceof DescriptorBean)) {
                    throw new ConfigurationError("EncryptedSecretKey null in config");
                }
                byte[] byArray = SerializedSystemIni.getEncryptedSecretKey();
                if (byArray == null || byArray.length < 1) {
                    throw new ConfigurationError("Empty encryptedSecretKey: " + byArray);
                }
                this._encryptedSecretKey = byArray;
            }
            catch (Exception exception) {
                ManagementLogger.logExceptionInCustomizer((Throwable)exception);
            }
        }
        return this._encryptedSecretKey;
    }

    public byte[] getEncryptedAESSecretKey() {
        byte[] byArray = null;
        try {
            byArray = SerializedSystemIni.getEncryptedAESSecretKey();
        }
        catch (Exception exception) {
            ManagementLogger.logExceptionInCustomizer((Throwable)exception);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateCredential() {
        byte[] byArray = Salt.getRandomBytes(32);
        try {
            byte[] byArray2 = SecurityConfiguration.getEncryptionService().encryptBytes(byArray);
            return byArray2;
        }
        finally {
            Arrays.fill(byArray, (byte)0);
        }
    }

    public void setCredentialGenerated(boolean bl) {
        if (this._initialized && bl) {
            try {
                this.getMyMBean().setCredentialEncrypted(this.generateCredential());
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
                throw new RuntimeException(invalidAttributeValueException);
            }
        }
    }

    private void addMBean(Vector vector, StandardInterface standardInterface) {
        if (standardInterface != null) {
            vector.add(standardInterface);
        }
    }

    private void addMBeans(Vector vector, StandardInterface[] standardInterfaceArray) {
        for (int i = 0; standardInterfaceArray != null && i < standardInterfaceArray.length; ++i) {
            this.addMBean(vector, standardInterfaceArray[i]);
        }
    }

    public ProviderMBean[] pre90getProviders() {
        Vector vector = new Vector();
        RealmMBean[] realmMBeanArray = this.getMyMBean().getRealms();
        for (int i = 0; realmMBeanArray != null && i < realmMBeanArray.length; ++i) {
            RealmMBean realmMBean = realmMBeanArray[i];
            this.addMBeans(vector, realmMBean.getAuditors());
            this.addMBeans(vector, realmMBean.getAuthenticationProviders());
            this.addMBeans(vector, realmMBean.getRoleMappers());
            this.addMBeans(vector, realmMBean.getAuthorizers());
            this.addMBeans(vector, realmMBean.getCredentialMappers());
            this.addMBeans(vector, realmMBean.getCertPathProviders());
            this.addMBeans(vector, realmMBean.getKeyStores());
            this.addMBean(vector, realmMBean.getAdjudicator());
        }
        return vector.toArray(new ProviderMBean[0]);
    }
}

