/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import weblogic.logging.LoggingConfigurationProcessor;
import weblogic.logging.MessageLogger;
import weblogic.logging.Severities;
import weblogic.management.DomainDir;
import weblogic.management.ManagementLogger;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.CoherenceClusterSystemResourceMBean;
import weblogic.management.configuration.DomainLogFilterMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.LogFilterMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.mbeans.custom.Kernel;
import weblogic.management.mbeans.custom.MigratableTargetConfigProcessor;
import weblogic.management.provider.DomainAccess;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.management.runtime.ServerLifeCycleRuntimeMBean;
import weblogic.nodemanager.mbean.NodeManagerRuntime;
import weblogic.nodemanager.mbean.NodeManagerTask;
import weblogic.protocol.ProtocolManager;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.StackTraceUtils;

public final class Server
extends Kernel {
    private static final DebugCategory DEBUG_DEPLOYER = Debug.getCategory((String)"weblogic.deployer");
    private static final long serialVersionUID = -2191431493098472191L;
    private static final long READ_DELAY = 250L;
    private static final long READ_MAX_DELAY_COUNT = 120L;
    private static final boolean DEBUG = false;
    private String activeDir = null;
    private transient ClusterMBean cluster;
    private String stageDir;
    private DomainLogFilterMBean domainLogFilter;
    private boolean enabledForDomainLog = true;
    private String startupMode;
    private transient CoherenceClusterSystemResourceMBean coherenceClusterSysResMBean;
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private String uploadDir;
    private int threadPoolSize = 5;
    private int adminPort;
    private boolean messageIdPrefixEnabled;

    private ServerMBean getServer() {
        return (ServerMBean)this.getMbean();
    }

    public Server(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    public static String getNameOfDefaultMigratableTargetFor(ServerMBean serverMBean) {
        return serverMBean.getName() + " (migratable)";
    }

    public Reader getLogs(String string) {
        String string2 = this.getServer().getName();
        if (string2 == null || string2.equals("")) {
            String string3 = "Could not get logs for server '" + string2 + "' via Node Manager - reason: 'Server name is not set'";
            return this.printError(string3);
        }
        NodeManagerRuntime nodeManagerRuntime = NodeManagerRuntime.getInstance(this.getServer());
        try {
            return nodeManagerRuntime.getLog(this.getServer());
        }
        catch (IOException iOException) {
            String string4 = "Could not get logs for server '" + string2 + "' via Node Manager - reason: " + iOException.getMessage();
            return this.printError(string4);
        }
    }

    public String getStagingDirectoryName() {
        if (this.stageDir == null) {
            this.stageDir = this.getDefaultStagingDirName();
            if (DEBUG_DEPLOYER.isEnabled()) {
                Debug.say((String)(this.getMbean().getName() + "\nusing " + this.stageDir + " as staging directory, my name is : " + this.getMbean().getName()));
            }
        }
        return this.stageDir;
    }

    public void setStagingDirectoryName(String string) {
        this.stageDir = string;
    }

    public String getUploadDirectoryName() {
        String string = this.getMbean().getName();
        if (this.uploadDir == null && string != null) {
            this.uploadDir = DomainDir.getPathRelativeServerDirNonCanonical((String)string, (String)"upload");
        }
        return this.uploadDir;
    }

    public void setUploadDirectoryName(String string) {
        this.uploadDir = string;
    }

    public String[] getSupportedProtocols() {
        return ProtocolManager.getProtocols();
    }

    public boolean isEnabledForDomainLog() {
        if (this.isDelegateModeEnabled()) {
            return Severities.severityStringToNum((String)this.getServer().getLog().getDomainLogBroadcastSeverity()) > 0;
        }
        return this.enabledForDomainLog;
    }

    public void setEnabledForDomainLog(boolean bl) {
        this.enabledForDomainLog = bl;
        if (this.isDelegateModeEnabled()) {
            ServerMBean serverMBean = this.getServer();
            LoggingConfigurationProcessor.upgradeDomainLogFilterEnabled(serverMBean);
        }
    }

    public boolean getEnabledForDomainLog() {
        String string = this.getServer().getLog().getDomainLogBroadcastSeverity();
        int n = Severities.severityStringToNum((String)string);
        return n > 0;
    }

    public DomainLogFilterMBean getDomainLogFilter() {
        if (!this.isDelegateModeEnabled()) {
            return this.domainLogFilter;
        }
        LogFilterMBean logFilterMBean = this.getServer().getLog().getDomainLogBroadcastFilter();
        if (logFilterMBean != null) {
            DomainMBean domainMBean = (DomainMBean)this.getMbean().getParent();
            DomainLogFilterMBean domainLogFilterMBean = domainMBean.lookupDomainLogFilter(logFilterMBean.getName());
            return domainLogFilterMBean;
        }
        return null;
    }

    public void setDomainLogFilter(DomainLogFilterMBean domainLogFilterMBean) {
        this.domainLogFilter = domainLogFilterMBean;
        if (this.isDelegateModeEnabled()) {
            ServerMBean serverMBean = this.getServer();
            DomainMBean domainMBean = (DomainMBean)serverMBean.getParent();
            LoggingConfigurationProcessor.applyDomainLogFilterToLogMBean(domainMBean, serverMBean.getLog(), this.domainLogFilter);
        }
    }

    public void setThreadPoolSize(int n) {
        this.threadPoolSize = n;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setActiveDirectoryName(String string) {
        this.activeDir = string;
    }

    public String getActiveDirectoryName() {
        if (this.activeDir == null) {
            this.activeDir = this.getStagingDirectoryName();
        }
        return this.activeDir;
    }

    public void setCluster(ClusterMBean clusterMBean) {
        ClusterMBean clusterMBean2 = this.cluster;
        this.cluster = clusterMBean;
        if (clusterMBean == null && clusterMBean2 == null) {
            return;
        }
        if (clusterMBean != null && clusterMBean2 != null) {
            if (clusterMBean.getName().equals(clusterMBean2.getName())) {
                return;
            }
            this.deleteDefaultMigratableTarget();
            this.createDefaultMigratableTarget();
        } else if (clusterMBean == null && clusterMBean2 != null) {
            this.deleteDefaultMigratableTarget();
            this.getMbean().unSet("Cluster");
        } else if (clusterMBean != null && clusterMBean2 == null) {
            this.createDefaultMigratableTarget();
        }
    }

    public ClusterMBean getCluster() {
        return this.cluster;
    }

    public void setAdministrationPort(int n) {
        this.adminPort = n;
    }

    public int getAdministrationPort() {
        return this.adminPort;
    }

    public void setMessageIdPrefixEnabled(boolean bl) {
        MessageLogger.setUsePrefix(bl);
        this.messageIdPrefixEnabled = bl;
    }

    public boolean getMessageIdPrefixEnabled() {
        return this.messageIdPrefixEnabled;
    }

    public String synchronousStart() {
        return this.getStringFromReader(this.start());
    }

    private Reader start() {
        String string = this.getServer().getName();
        if (string == null || string.equals("")) {
            String string2 = "Could not start server '" + string + "' via Node Manager - reason: 'Server name is not set'";
            return this.printError(string2);
        }
        try {
            NodeManagerRuntime.checkStartPrivileges(string, SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId));
        }
        catch (SecurityException securityException) {
            return this.printError(securityException.getMessage());
        }
        NodeManagerRuntime nodeManagerRuntime = NodeManagerRuntime.getInstance(this.getServer());
        try {
            NodeManagerTask nodeManagerTask = nodeManagerRuntime.start(this.getServer());
            return new StringReader("Server '" + string + "' started");
        }
        catch (IOException iOException) {
            String string3 = "Could not start server '" + string + "' via Node Manager - reason: " + iOException.getMessage();
            return this.printError(string3);
        }
    }

    public String synchronousKill() {
        return this.getStringFromReader(this.kill());
    }

    private Reader kill() {
        String string = this.getServer().getName();
        if (string == null || string.equals("")) {
            String string2 = "Could not start server '" + string + "' via Node Manager - reason: 'Server name is not set'";
            return this.printError(string2);
        }
        NodeManagerRuntime nodeManagerRuntime = NodeManagerRuntime.getInstance(this.getServer());
        try {
            nodeManagerRuntime.kill(this.getServer());
            return new StringReader("Server killed");
        }
        catch (IOException iOException) {
            String string3 = "Could not kill server '" + string + "' via Node Manager - reason: " + iOException.getMessage();
            return this.printError(string3);
        }
    }

    public ServerLifeCycleRuntimeMBean lookupServerLifeCycleRuntime() {
        if (ManagementService.getRuntimeAccess(kernelId).isAdminServer()) {
            DomainAccess domainAccess = ManagementService.getDomainAccess(kernelId);
            return domainAccess.lookupServerLifecycleRuntime(this.getMbean().getName());
        }
        return null;
    }

    private String getStringFromReader(Reader reader) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            BufferedReader bufferedReader = null;
            bufferedReader = new BufferedReader(reader);
            String string = null;
            boolean bl = true;
            int n = 0;
            while (bl) {
                while ((string = bufferedReader.readLine()) != null) {
                    n = 0;
                    stringBuffer.append(string);
                    stringBuffer.append("\n");
                }
                Thread.sleep(250L);
                if ((long)(++n) != 120L) continue;
                bl = false;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            stringBuffer.append(StackTraceUtils.throwable2StackTrace((Throwable)exception));
        }
        return stringBuffer.toString();
    }

    private Reader printError(String string) {
        ManagementLogger.logNodeManagerError((String)string);
        return new StringReader("Error: " + string);
    }

    private void createDefaultMigratableTarget() {
        ServerMBean serverMBean = (ServerMBean)this.getMbean();
        DomainMBean domainMBean = (DomainMBean)serverMBean.getParent();
        MigratableTargetConfigProcessor.createDefaultMigratableTargets(domainMBean, serverMBean);
    }

    private void deleteDefaultMigratableTarget() {
        this.getServer().destroyJTAMigratableTarget();
        this.getMbean().unSet("JTAMigratableTarget");
        MigratableTargetConfigProcessor.destroyDefaultMigratableTarget(this.getServer());
    }

    public Set getServerNames() {
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(this.getMbean().getName());
        return hashSet;
    }

    public String getRootDirectory() {
        return DomainDir.getRootDir();
    }

    public String getDefaultStagingDirName() {
        String string = this.getMbean().getName();
        if (string == null) {
            return null;
        }
        return DomainDir.getPathRelativeServerDir((String)string, (String)"stage");
    }

    public String get81StyleDefaultStagingDirName() {
        String string = this.getMbean().getName();
        if (string == null) {
            return null;
        }
        return DomainDir.getPathRelativeRootDir((String)(string + File.separator + "stage"));
    }

    public void setStartupMode(String string) {
        this.startupMode = string;
    }

    public String getStartupMode() {
        String string = System.getProperty("weblogic.management.startupMode");
        if (string != null) {
            return string;
        }
        return this.startupMode;
    }

    public void setCoherenceClusterSystemResource(CoherenceClusterSystemResourceMBean coherenceClusterSystemResourceMBean) {
        this.coherenceClusterSysResMBean = coherenceClusterSystemResourceMBean;
    }

    public CoherenceClusterSystemResourceMBean getCoherenceClusterSystemResource() {
        return this.coherenceClusterSysResMBean;
    }
}

