/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.cluster.ClusterService;
import weblogic.cluster.singleton.LeasingException;
import weblogic.cluster.singleton.MigratableServerService;
import weblogic.cluster.singleton.SingletonMonitorRemote;
import weblogic.jndi.Environment;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.SingletonServiceMBean;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.management.provider.custom.ConfigurationMBeanCustomizer;
import weblogic.protocol.URLManager;
import weblogic.utils.Debug;

public class SingletonService
extends ConfigurationMBeanCustomizer {
    private transient ServerMBean userPreferredServer;
    private String _userPreferredServerName;
    private static final ServerMBean[] NO_SERVERS = new ServerMBean[0];

    public SingletonService(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    private SingletonMonitorRemote getSingletonMonitor(ClusterMBean clusterMBean) {
        if (clusterMBean == null) {
            return null;
        }
        SingletonMonitorRemote singletonMonitorRemote = null;
        try {
            if (ClusterService.getServices() == null) {
                ServerMBean[] serverMBeanArray = clusterMBean.getServers();
                for (int i = 0; i < serverMBeanArray.length; ++i) {
                    String string = URLManager.findAdministrationURL(serverMBeanArray[i].getName());
                    singletonMonitorRemote = this.getSingletonMonitorRemote(string);
                    if (singletonMonitorRemote == null) continue;
                    return singletonMonitorRemote;
                }
            } else {
                String string = MigratableServerService.theOne().findSingletonMaster();
                if (string != null) {
                    MigratableServerService.theOne();
                    String string2 = MigratableServerService.findURLOfUnconnectedServer(string);
                    singletonMonitorRemote = this.getSingletonMonitorRemote(string2);
                }
            }
        }
        catch (LeasingException leasingException) {
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return singletonMonitorRemote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SingletonMonitorRemote getSingletonMonitorRemote(String string) {
        SingletonMonitorRemote singletonMonitorRemote;
        Environment environment = new Environment();
        Context context = null;
        try {
            if (string == null) {
                SingletonMonitorRemote singletonMonitorRemote2 = null;
                return singletonMonitorRemote2;
            }
            environment.setProviderUrl(string);
            context = environment.getInitialContext();
            singletonMonitorRemote = (SingletonMonitorRemote)context.lookup("weblogic/cluster/singleton/SingletonMonitorRemote");
        }
        catch (NamingException namingException) {
            SingletonMonitorRemote singletonMonitorRemote3 = null;
            return singletonMonitorRemote3;
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException namingException) {}
            }
        }
        return singletonMonitorRemote;
    }

    public ServerMBean getHostingServer() {
        Object object;
        SingletonServiceMBean singletonServiceMBean = (SingletonServiceMBean)this.getMbean();
        String string = null;
        ConfigurationMBean configurationMBean = (ConfigurationMBean)this.getMbean().getParent();
        if (configurationMBean instanceof ServerMBean) {
            return (ServerMBean)configurationMBean;
        }
        try {
            object = this.getSingletonMonitor(singletonServiceMBean.getCluster());
            if (object == null) {
                return this.getUserPreferredServer();
            }
            string = object.findServiceLocation(singletonServiceMBean.getName());
        }
        catch (RemoteException remoteException) {
            return this.getUserPreferredServer();
        }
        if (configurationMBean instanceof DomainMBean && string != null) {
            object = (DomainMBean)configurationMBean;
            return object.lookupServer(string);
        }
        return this.getUserPreferredServer();
    }

    public ServerMBean[] getAllCandidateServers() {
        SingletonServiceMBean singletonServiceMBean = (SingletonServiceMBean)this.getMbean();
        if (singletonServiceMBean == null) {
            return NO_SERVERS;
        }
        if (singletonServiceMBean.getConstrainedCandidateServers() != null && singletonServiceMBean.getConstrainedCandidateServers().length > 0) {
            return this.moveUserPreferredServerToHead(singletonServiceMBean.getConstrainedCandidateServers());
        }
        if (singletonServiceMBean.getCluster() != null && singletonServiceMBean.getCluster().getServers().length > 0) {
            return this.moveUserPreferredServerToHead(singletonServiceMBean.getCluster().getServers());
        }
        return NO_SERVERS;
    }

    public boolean isManualActiveOn(ServerMBean serverMBean) {
        return this.getUserPreferredServer().getName().equals(serverMBean.getName());
    }

    public boolean isCandidate(ServerMBean serverMBean) {
        ServerMBean[] serverMBeanArray = ((SingletonServiceMBean)this.getMbean()).getAllCandidateServers();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            if (!serverMBean.getName().equals(serverMBeanArray[i].getName())) continue;
            return true;
        }
        return false;
    }

    public ServerMBean getUserPreferredServer() {
        if (this.userPreferredServer == null && this._userPreferredServerName != null) {
            ConfigurationMBean configurationMBean = (ConfigurationMBean)this.getMbean().getParent();
            if (configurationMBean instanceof ServerMBean) {
                configurationMBean = (ConfigurationMBean)configurationMBean.getParent();
            }
            if (configurationMBean instanceof DomainMBean) {
                DomainMBean domainMBean = (DomainMBean)configurationMBean;
                this.userPreferredServer = domainMBean.lookupServer(this._userPreferredServerName);
            }
        }
        return this.userPreferredServer;
    }

    public void setUserPreferredServer(ServerMBean serverMBean) {
        this.userPreferredServer = serverMBean;
        if (serverMBean != null) {
            this._userPreferredServerName = serverMBean.getName();
            ClusterMBean clusterMBean = serverMBean.getCluster();
            SingletonServiceMBean singletonServiceMBean = (SingletonServiceMBean)this.getMbean();
            if (singletonServiceMBean.getCluster() == null && clusterMBean != null) {
                singletonServiceMBean.setCluster(clusterMBean);
                if (clusterMBean == null) {
                    Debug.assertion((singletonServiceMBean.getCluster() == null ? 1 : 0) != 0);
                } else {
                    ClusterMBean clusterMBean2 = singletonServiceMBean.getCluster();
                    Debug.assertion((clusterMBean2 != null ? 1 : 0) != 0, (String)"Migratable Target Cluster is null");
                    Debug.assertion((clusterMBean.getName() != null ? 1 : 0) != 0, (String)"Cluster name is null");
                    Debug.assertion((boolean)clusterMBean.getName().equals(clusterMBean2.getName()));
                }
            }
        }
    }

    public Set getServerNames() {
        ServerMBean[] serverMBeanArray = this.getAllCandidateServers();
        HashSet<String> hashSet = new HashSet<String>(serverMBeanArray.length);
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            hashSet.add(serverMBeanArray[i].getName());
        }
        return hashSet;
    }

    private ServerMBean[] moveUserPreferredServerToHead(ServerMBean[] serverMBeanArray) {
        if (this.getUserPreferredServer() == null) {
            return serverMBeanArray;
        }
        ServerMBean serverMBean = this.getUserPreferredServer();
        String string = serverMBean.getName();
        if (serverMBeanArray[0].getName().equals(string)) {
            return serverMBeanArray;
        }
        for (int i = 1; i < serverMBeanArray.length; ++i) {
            ServerMBean serverMBean2 = serverMBeanArray[i];
            if (!string.equals(serverMBean2.getName())) continue;
            ServerMBean serverMBean3 = serverMBeanArray[0];
            serverMBeanArray[0] = serverMBeanArray[i];
            serverMBeanArray[i] = serverMBean3;
            return serverMBeanArray;
        }
        ServerMBean[] serverMBeanArray2 = new ServerMBean[serverMBeanArray.length + 1];
        System.arraycopy(serverMBeanArray, 0, serverMBeanArray2, 1, serverMBeanArray.length);
        serverMBeanArray2[0] = serverMBean;
        return serverMBeanArray2;
    }
}

