/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.diagnostics.descriptor.WLDFResourceBean;
import weblogic.diagnostics.module.WLDFDescriptorLoader;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.mbeans.custom.ConfigurationExtension;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.management.provider.internal.DescriptorInfoUtils;

public class WLDFSystemResource
extends ConfigurationExtension {
    private static final String DEFAULT_CONFIG = "schema/diagnostics-binding.jar";
    private String _DescriptorFileName;

    public WLDFSystemResource(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    public String getDescriptorFileName() {
        return this._DescriptorFileName;
    }

    public void setDescriptorFileName(String string) {
        String string2 = "diagnostics/";
        this._DescriptorFileName = string != null && this.isEdit() && !new File(string).getPath().startsWith(new File(string2).getPath()) ? string2 + string : string;
    }

    public DescriptorBean getResource() {
        return (DescriptorBean)this.getWLDFResource();
    }

    public WLDFResourceBean getWLDFResource() {
        WLDFResourceBean wLDFResourceBean = (WLDFResourceBean)this.getExtensionRoot(WLDFResourceBean.class, "WLDFResource", "diagnostics");
        if (wLDFResourceBean == null) {
            return null;
        }
        if (wLDFResourceBean.getName() == null) {
            wLDFResourceBean.setName(this.getMbean().getName());
        }
        return wLDFResourceBean;
    }

    protected Descriptor loadDescriptor(DescriptorManager descriptorManager, InputStream inputStream, List list) throws Exception {
        WLDFDescriptorLoader wLDFDescriptorLoader = new WLDFDescriptorLoader(inputStream, descriptorManager, list);
        return wLDFDescriptorLoader.loadDescriptorBean().getDescriptor();
    }

    public void _preDestroy() {
        ConfigurationMBean configurationMBean = this.getMbean();
        DescriptorInfoUtils.removeDescriptorInfo((DescriptorBean)this.getWLDFResource(), configurationMBean.getDescriptor());
    }
}

