/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import java.text.ParseException;
import javax.management.InvalidAttributeValueException;
import weblogic.common.internal.PackageInfo;
import weblogic.common.internal.VersionInfo;
import weblogic.management.DistributedManagementException;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.WebServerLogMBean;
import weblogic.management.configuration.WebServerMBean;
import weblogic.management.internal.ManagementTextTextFormatter;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.management.provider.custom.ConfigurationMBeanCustomizer;
import weblogic.servlet.logging.LogMigrationProcessor;

public class WebServer
extends ConfigurationMBeanCustomizer {
    private static final long serialVersionUID = -1873044084609391595L;
    private static final boolean DEBUG = false;
    private boolean loggingEnabled = true;
    private String logFileFormat = "MM-dd-yyyy-k:mm:ss";
    private boolean logTimeInGMT = false;
    private String logFileName = "logs/access.log";
    private String logFileRotationType = "size";
    private int logRotationPeriodMins = 1440;
    private String logRotationTimeBegin;
    private boolean logFileLimitEnabled = false;
    private int logFileCount = 7;
    private static final VersionInfo diabloVersion = new VersionInfo("9.0.0.0");

    public WebServer(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    public void setLoggingEnabled(boolean bl) {
        this.loggingEnabled = bl;
        if (this.isDelegateModeEnabled()) {
            WebServerLogMBean webServerLogMBean = ((WebServerMBean)this.getMbean()).getWebServerLog();
            if (webServerLogMBean == null) {
                return;
            }
            if (bl == webServerLogMBean.isLoggingEnabled()) {
                return;
            }
            webServerLogMBean.setLoggingEnabled(bl);
        }
    }

    public boolean isLoggingEnabled() {
        if (this.isDelegateModeEnabled()) {
            return ((WebServerMBean)this.getMbean()).getWebServerLog().isLoggingEnabled();
        }
        return this.loggingEnabled;
    }

    public String getLogFileFormat() {
        if (this.isDelegateModeEnabled()) {
            return ((WebServerMBean)this.getMbean()).getWebServerLog().getLogFileFormat();
        }
        return this.logFileFormat;
    }

    public void setLogFileFormat(String string) throws InvalidAttributeValueException, DistributedManagementException {
        this.logFileFormat = string;
        if (this.isDelegateModeEnabled()) {
            WebServerLogMBean webServerLogMBean = ((WebServerMBean)this.getMbean()).getWebServerLog();
            if (webServerLogMBean == null) {
                return;
            }
            if (string != null && string.equals(webServerLogMBean.getLogFileFormat())) {
                return;
            }
            webServerLogMBean.setLogFileFormat(string);
        }
    }

    public boolean getLogTimeInGMT() {
        if (this.isDelegateModeEnabled()) {
            return ((WebServerMBean)this.getMbean()).getWebServerLog().isLogTimeInGMT();
        }
        return this.logTimeInGMT;
    }

    public void setLogTimeInGMT(boolean bl) {
        this.logTimeInGMT = bl;
        if (this.isDelegateModeEnabled()) {
            WebServerLogMBean webServerLogMBean = ((WebServerMBean)this.getMbean()).getWebServerLog();
            if (webServerLogMBean == null) {
                return;
            }
            if (bl == webServerLogMBean.isLogTimeInGMT()) {
                return;
            }
            webServerLogMBean.setLogTimeInGMT(bl);
        }
    }

    public String getLogFileName() {
        if (this.isDelegateModeEnabled()) {
            return ((WebServerMBean)this.getMbean()).getWebServerLog().getFileName();
        }
        return this.logFileName;
    }

    public void setLogFileName(String string) throws InvalidAttributeValueException {
        if (string == null || string.length() == 0) {
            return;
        }
        this.logFileName = string;
        if (this.logFileName.equals("logs/access.log")) {
            return;
        }
        if (this.isDelegateModeEnabled()) {
            WebServerLogMBean webServerLogMBean = ((WebServerMBean)this.getMbean()).getWebServerLog();
            webServerLogMBean.setFileName(this.logFileName);
        }
    }

    public String getLogRotationType() {
        if (this.isDelegateModeEnabled()) {
            WebServerLogMBean webServerLogMBean = ((WebServerMBean)this.getMbean()).getWebServerLog();
            String string = webServerLogMBean.getRotationType();
            if (string == null || string.equals("bySize")) {
                string = "size";
            } else if (string.equals("byTime")) {
                string = "date";
            }
            return string;
        }
        return this.logFileRotationType;
    }

    public void setLogRotationType(String string) throws InvalidAttributeValueException {
        this.logFileRotationType = string;
        if (this.isDelegateModeEnabled()) {
            WebServerLogMBean webServerLogMBean = ((WebServerMBean)this.getMbean()).getWebServerLog();
            if (webServerLogMBean == null) {
                return;
            }
            if (string == null || string.equalsIgnoreCase("size")) {
                string = "bySize";
            } else if (string.equalsIgnoreCase("date")) {
                string = "byTime";
            }
            if (string != null && string.equals(webServerLogMBean.getRotationType())) {
                return;
            }
            webServerLogMBean.setRotationType(string);
        }
    }

    public int getLogRotationPeriodMins() {
        if (this.isDelegateModeEnabled()) {
            return ((WebServerMBean)this.getMbean()).getWebServerLog().getFileTimeSpan() * 60;
        }
        return this.logRotationPeriodMins;
    }

    public void setLogRotationPeriodMins(int n) throws InvalidAttributeValueException, DistributedManagementException {
        this.logRotationPeriodMins = n;
        if (this.isDelegateModeEnabled()) {
            WebServerLogMBean webServerLogMBean = ((WebServerMBean)this.getMbean()).getWebServerLog();
            if (webServerLogMBean == null) {
                return;
            }
            if (n / 60 == webServerLogMBean.getFileTimeSpan()) {
                return;
            }
            webServerLogMBean.setFileTimeSpan(n / 60);
        }
    }

    public String getLogRotationTimeBegin() {
        if (this.isDelegateModeEnabled()) {
            return ((WebServerMBean)this.getMbean()).getWebServerLog().getRotationTime();
        }
        return this.logRotationTimeBegin;
    }

    public void setLogRotationTimeBegin(String string) throws InvalidAttributeValueException {
        this.logRotationTimeBegin = string;
        if (this.isDelegateModeEnabled()) {
            if (this.logRotationTimeBegin == null || this.logRotationTimeBegin.length() == 0) {
                return;
            }
            try {
                String string2 = LogMigrationProcessor.convertLogRotationTimeBegin(string);
                ((WebServerMBean)this.getMbean()).getWebServerLog().setRotationTime(string2);
            }
            catch (ParseException parseException) {
                String string3 = ManagementTextTextFormatter.getInstance().getTimeFormatErrorMessage("MM-dd-yyyy-k:mm:ss", string);
                throw new IllegalArgumentException(string3);
            }
        }
    }

    public boolean isLogFileLimitEnabled() {
        if (this.isDelegateModeEnabled()) {
            return ((WebServerMBean)this.getMbean()).getWebServerLog().isNumberOfFilesLimited();
        }
        return this.logFileLimitEnabled;
    }

    public void setLogFileLimitEnabled(boolean bl) throws InvalidAttributeValueException {
        this.logFileLimitEnabled = bl;
        if (this.isDelegateModeEnabled()) {
            WebServerLogMBean webServerLogMBean = ((WebServerMBean)this.getMbean()).getWebServerLog();
            if (webServerLogMBean == null) {
                return;
            }
            if (bl == webServerLogMBean.isNumberOfFilesLimited()) {
                return;
            }
            try {
                webServerLogMBean.setNumberOfFilesLimited(bl);
            }
            catch (DistributedManagementException distributedManagementException) {
                throw new IllegalArgumentException(distributedManagementException.getMessage());
            }
        }
    }

    public int getLogFileCount() {
        if (this.isDelegateModeEnabled()) {
            return ((WebServerMBean)this.getMbean()).getWebServerLog().getFileCount();
        }
        return this.logFileCount;
    }

    public void setLogFileCount(int n) throws InvalidAttributeValueException {
        this.logFileCount = n;
        if (this.isDelegateModeEnabled()) {
            WebServerLogMBean webServerLogMBean = ((WebServerMBean)this.getMbean()).getWebServerLog();
            if (webServerLogMBean == null) {
                return;
            }
            if (n == webServerLogMBean.getFileCount()) {
                return;
            }
            try {
                webServerLogMBean.setFileCount(n);
            }
            catch (DistributedManagementException distributedManagementException) {
                throw new IllegalArgumentException(distributedManagementException.getMessage());
            }
        }
    }

    protected boolean isDelegateModeEnabled() {
        DomainMBean domainMBean = (DomainMBean)this.getMbean().getDescriptor().getRootBean();
        String string = domainMBean.getConfigurationVersion();
        if (string == null) {
            return false;
        }
        VersionInfo versionInfo = new VersionInfo(string);
        return !versionInfo.earlierThan((PackageInfo)diabloVersion);
    }
}

