/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.ManagementException;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.jmx.MBeanServerInvocationHandler;
import weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean;
import weblogic.management.mbeanservers.edit.EditServiceMBean;
import weblogic.management.mbeanservers.runtime.RuntimeServiceMBean;
import weblogic.management.runtime.ServerRuntimeMBean;

public class Administration {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugJMXCore");
    private static final int EDIT = 1;
    private static final int RUNTIME = 2;
    private static final int DOMAIN_RUNTIME = 3;
    private MBeanServerConnection runtime;
    private MBeanServerConnection domain_runtime;
    private MBeanServerConnection edit;
    private JMXConnector runtime_connector;
    private JMXConnector domain_runtime_connector;
    private JMXConnector edit_connector;
    private static ObjectName runtime_on;
    private static ObjectName domain_runtime_on;
    private static ObjectName edit_on;

    public Administration(Context context) throws ManagementException {
        this.runtime = this.getConnection(2, context);
        ServerRuntimeMBean serverRuntimeMBean = this.getServerRuntimeMBean();
        if (serverRuntimeMBean.isAdminServer()) {
            this.edit = this.getConnection(1, context);
            this.domain_runtime = this.getConnection(3, context);
        }
    }

    public Administration(String string, String string2, String string3) throws ManagementException {
        this.runtime = this.getConnection(2, string, string2, string3);
        ServerRuntimeMBean serverRuntimeMBean = this.getServerRuntimeMBean();
        if (serverRuntimeMBean.isAdminServer()) {
            this.edit = this.getConnection(1, string, string2, string3);
            this.domain_runtime = this.getConnection(3, string, string2, string3);
        }
    }

    public RuntimeServiceMBean getRuntimeServiceMBean() {
        return (RuntimeServiceMBean)MBeanServerInvocationHandler.newProxyInstance((MBeanServerConnection)this.runtime, (ObjectName)runtime_on);
    }

    public DomainRuntimeServiceMBean getDomainRuntimeServiceMBean() {
        if (this.domain_runtime == null) {
            String string = "This method (getDomainRuntimeServiceMBean) can only be called when connected to an admin server";
            throw new AssertionError((Object)string);
        }
        return (DomainRuntimeServiceMBean)MBeanServerInvocationHandler.newProxyInstance((MBeanServerConnection)this.domain_runtime, (ObjectName)domain_runtime_on);
    }

    public EditServiceMBean getEditServiceMBean() {
        if (this.edit == null) {
            String string = "This method (getEditServiceMBean) can only be called when connected to an admin server";
            throw new AssertionError((Object)string);
        }
        return (EditServiceMBean)MBeanServerInvocationHandler.newProxyInstance((MBeanServerConnection)this.edit, (ObjectName)edit_on);
    }

    public ServerRuntimeMBean getServerRuntimeMBean() {
        RuntimeServiceMBean runtimeServiceMBean = this.getRuntimeServiceMBean();
        return runtimeServiceMBean.getServerRuntime();
    }

    public DomainMBean getDomainMBean() {
        RuntimeServiceMBean runtimeServiceMBean = this.getRuntimeServiceMBean();
        return runtimeServiceMBean.getDomainConfiguration();
    }

    private MBeanServerConnection getConnection(int n, Context context) throws ManagementException {
        String string = this.getJndiName(n);
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Get mbean server connection for " + string);
        }
        Object var4_4 = null;
        try {
            JMXServiceURL jMXServiceURL = new JMXServiceURL("wlx", null, 0, string);
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
            hashtable.put("weblogic.context", context);
            switch (n) {
                case 2: {
                    this.runtime_connector = JMXConnectorFactory.connect(jMXServiceURL, hashtable);
                    return this.runtime_connector.getMBeanServerConnection();
                }
                case 3: {
                    this.domain_runtime_connector = JMXConnectorFactory.connect(jMXServiceURL, hashtable);
                    return this.domain_runtime_connector.getMBeanServerConnection();
                }
                case 1: {
                    this.edit_connector = JMXConnectorFactory.connect(jMXServiceURL, hashtable);
                    return this.edit_connector.getMBeanServerConnection();
                }
            }
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            throw new ManagementException((Throwable)malformedURLException);
        }
        catch (IOException iOException) {
            throw new ManagementException((Throwable)iOException);
        }
    }

    private MBeanServerConnection getConnection(int n, String string, String string2, String string3) throws ManagementException {
        String string4 = this.getJndiName(n);
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Get mbean server connection for " + string4 + " address " + string3);
        }
        try {
            URI uRI = new URI(string3);
            String string5 = uRI.getScheme();
            String string6 = uRI.getHost();
            int n2 = uRI.getPort();
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
            hashtable.put("java.naming.provider.url", string3);
            hashtable.put("java.naming.security.principal", string);
            hashtable.put("java.naming.security.credentials", string2);
            InitialContext initialContext = new InitialContext(hashtable);
            Hashtable<?, ?> hashtable2 = initialContext.getEnvironment();
            JMXServiceURL jMXServiceURL = new JMXServiceURL(string5, string6, n2, string4);
            Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
            hashtable3.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
            if (string != null && string2 != null) {
                hashtable3.put("java.naming.security.principal", string);
                hashtable3.put("java.naming.security.credentials", string2);
            }
            switch (n) {
                case 2: {
                    this.runtime_connector = JMXConnectorFactory.connect(jMXServiceURL, hashtable3);
                    return this.runtime_connector.getMBeanServerConnection();
                }
                case 3: {
                    this.domain_runtime_connector = JMXConnectorFactory.connect(jMXServiceURL, hashtable3);
                    return this.domain_runtime_connector.getMBeanServerConnection();
                }
                case 1: {
                    this.edit_connector = JMXConnectorFactory.connect(jMXServiceURL, hashtable3);
                    return this.edit_connector.getMBeanServerConnection();
                }
            }
            return null;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ManagementException((Throwable)uRISyntaxException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ManagementException((Throwable)malformedURLException);
        }
        catch (NamingException namingException) {
            throw new ManagementException((Throwable)namingException);
        }
        catch (IOException iOException) {
            throw new ManagementException((Throwable)iOException);
        }
    }

    private String getJndiName(int n) {
        String string = null;
        switch (n) {
            case 2: {
                string = "weblogic.management.mbeanservers.runtime";
                break;
            }
            case 3: {
                string = "weblogic.management.mbeanservers.domainruntime";
                break;
            }
            case 1: {
                string = "weblogic.management.mbeanservers.edit";
                break;
            }
            default: {
                string = "weblogic.management.mbeanservers.runtime";
            }
        }
        return "/jndi/" + string;
    }

    public void close() {
        if (this.runtime_connector != null) {
            try {
                this.runtime_connector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.domain_runtime_connector != null) {
            try {
                this.domain_runtime_connector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.edit_connector != null) {
            try {
                this.edit_connector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        try {
            runtime_on = new ObjectName(RuntimeServiceMBean.OBJECT_NAME);
            domain_runtime_on = new ObjectName(DomainRuntimeServiceMBean.OBJECT_NAME);
            edit_on = new ObjectName(EditServiceMBean.OBJECT_NAME);
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }
}

