/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.WebLogicObjectName;

public class ObjectNameTranslator {
    private static DebugLogger debug = DebugLogger.getDebugLogger((String)"DebugJMXCore");

    public static Hashtable get81Keys(ObjectName objectName) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = ObjectNameTranslator.calculate81Type(objectName.getKeyProperty("Type"));
        hashtable.put("Type", string);
        String string2 = objectName.getKeyProperty("Name");
        hashtable.put("Name", string2);
        if (string.equals("Domain")) {
            hashtable.put(string, string2);
        }
        String string3 = objectName.getKeyProperty("Path");
        String[] stringArray = string3.split("/");
        Class<?> clazz = null;
        for (int i = 0; i < stringArray.length - 1; ++i) {
            String string4 = stringArray[i];
            String[] stringArray2 = string4.split("\\[|\\]");
            String string5 = stringArray2[0];
            if (clazz == null) {
                try {
                    hashtable.put(string5, stringArray2[1]);
                    if (string5.equals("DomainRuntime")) continue;
                    clazz = Class.forName(ObjectNameTranslator.translateTypeTo90(string5));
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new AssertionError((Object)("Unable to get class for type " + string5));
                }
            }
            try {
                Method method = clazz.getMethod("get" + string5, null);
                clazz = method.getReturnType();
                if (clazz.isArray()) {
                    clazz = clazz.getComponentType();
                }
                String string6 = ObjectNameTranslator.calculate81Type(clazz.getName());
                hashtable.put(string6, stringArray2[1]);
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new AssertionError((Object)("Unable to get method for specified attribute " + string5));
            }
        }
        if (debug.isDebugEnabled()) {
            debug.debug("get81Keys: for " + objectName + " returns " + hashtable);
        }
        return hashtable;
    }

    public static ObjectName translateTo81(ObjectName objectName) {
        Hashtable hashtable = ObjectNameTranslator.get81Keys(objectName);
        String string = (String)hashtable.get("DomainRuntime");
        if (string != null) {
            hashtable.remove("DomainRuntime");
        } else {
            string = (String)hashtable.get("Domain");
            hashtable.remove("Domain");
        }
        try {
            return new ObjectName(string, hashtable);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new RuntimeException("Unble to translate ObjectName", malformedObjectNameException);
        }
    }

    private static Method matchAttributeNameWithClass(Class clazz, String string) {
        Method method = null;
        try {
            method = clazz.getMethod("get" + string, null);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                String string2 = ObjectNameTranslator.pluralize(string);
                method = clazz.getMethod("get" + string2, null);
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                return null;
            }
        }
    }

    private static Method matchAttributeNameWithClass(Class clazz, Class clazz2, String string) {
        Object object;
        Method method = ObjectNameTranslator.matchAttributeNameWithClass(clazz, string);
        if (method != null) {
            return method;
        }
        if (string.endsWith("Runtime") && (method = ObjectNameTranslator.matchAttributeNameWithClass(clazz, (String)(object = string.substring(0, string.length() - 7)))) != null) {
            return method;
        }
        object = clazz.getMethods();
        for (int i = 0; i < ((Method[])object).length; ++i) {
            Method method2 = object[i];
            Class<?> clazz3 = method2.getReturnType();
            if (!method2.getName().startsWith("get") || method2.getParameterTypes().length != 0) continue;
            if (clazz3.isArray()) {
                Class<?> clazz4 = clazz3.getComponentType();
                if (!clazz4.isAssignableFrom(clazz2)) continue;
                if (clazz2.equals(clazz4)) {
                    if (method != null) continue;
                    method = method2;
                    continue;
                }
                method = method2;
                continue;
            }
            if (!clazz3.isAssignableFrom(clazz2)) continue;
            if (clazz2.equals(clazz3)) {
                if (method != null) continue;
                method = method2;
                continue;
            }
            method = method2;
        }
        if (method == null) {
            throw new RuntimeException("Unable to find getter method for " + clazz.getName() + " returning " + clazz2.getName());
        }
        return method;
    }

    public static ObjectName translateTo90(WebLogicObjectName webLogicObjectName) {
        Object object;
        Object object2;
        CharSequence charSequence;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = webLogicObjectName.getType();
        String string2 = ObjectNameTranslator.translateTypeTo90(string);
        hashtable.put("Type", string2);
        String string3 = webLogicObjectName.getName();
        hashtable.put("Name", string3);
        String string4 = webLogicObjectName.getDomain();
        ArrayList<String> arrayList = new ArrayList<String>();
        CharSequence charSequence2 = string;
        String string5 = ObjectNameTranslator.translateTypeTo90(charSequence2);
        Object object3 = null;
        try {
            object3 = Class.forName(string5);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Unable to map tag to class " + charSequence2, classNotFoundException);
        }
        String string6 = string3;
        for (WebLogicObjectName webLogicObjectName2 = webLogicObjectName.getParent(); webLogicObjectName2 != null; webLogicObjectName2 = webLogicObjectName2.getParent()) {
            charSequence = webLogicObjectName2.getType();
            object2 = ObjectNameTranslator.translateTypeTo90((String)charSequence);
            object = null;
            try {
                object = Class.forName((String)object2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("Unable to map tag to class " + (String)charSequence, classNotFoundException);
            }
            Method method = ObjectNameTranslator.matchAttributeNameWithClass(object, object3, charSequence2);
            String string7 = method.getName().substring(3);
            String string8 = string7 + "[" + string6 + "]";
            arrayList.add(0, string8);
            string6 = webLogicObjectName2.getName();
            object3 = object;
            charSequence2 = charSequence;
        }
        charSequence = new StringBuffer();
        if (!string.endsWith("Runtime")) {
            ((StringBuffer)charSequence).append("Domain[");
            ((StringBuffer)charSequence).append(string4);
            ((StringBuffer)charSequence).append("]");
        } else {
            ((StringBuffer)charSequence).append("DomainRuntime[");
            ((StringBuffer)charSequence).append(string4);
            ((StringBuffer)charSequence).append("]/");
            ((StringBuffer)charSequence).append("ServerRuntime[");
            ((StringBuffer)charSequence).append(string6);
            ((StringBuffer)charSequence).append("]");
        }
        if (arrayList.size() != 0) {
            ((StringBuffer)charSequence).append("/");
        }
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            ((StringBuffer)charSequence).append((String)object);
            if (!object2.hasNext()) continue;
            ((StringBuffer)charSequence).append("/");
        }
        hashtable.put("Path", ((StringBuffer)charSequence).toString());
        if (debug.isDebugEnabled()) {
            debug.debug("translateTo90: for " + webLogicObjectName + " has keys " + hashtable);
        }
        try {
            return new ObjectName("com.bea", hashtable);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            System.out.println(hashtable);
            throw new RuntimeException(malformedObjectNameException);
        }
    }

    public static String translateTypeTo90(String string) {
        if (string.endsWith("Runtime")) {
            return "weblogic.management.runtime." + string + "MBean";
        }
        if (string.endsWith("Config")) {
            return "weblogic.management.configuration." + string.substring(0, string.length() - 7) + "MBean";
        }
        return "weblogic.management.configuration." + string + "MBean";
    }

    public static String calculate81Type(String string) {
        int n = string.lastIndexOf(46) + 1;
        int n2 = string.length();
        if (string.endsWith("MBean")) {
            n2 -= 5;
        } else if (string.endsWith("Bean")) {
            n2 -= 4;
        }
        return string.substring(n, n2);
    }

    public static String pluralize(String string) {
        String string2 = null;
        string2 = string.endsWith("s") || string.endsWith("ch") || string.endsWith("x") || string.endsWith("sh") ? string + "es" : (string.endsWith("y") && !string.endsWith("ay") && !string.endsWith("ey") && !string.endsWith("iy") && !string.endsWith("oy") && !string.endsWith("uy") ? string.substring(0, string.length() - 1) + "ies" : string + "s");
        return string2;
    }
}

