/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.compatibility.internal;

import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.jndi.Environment;
import weblogic.management.MBeanCreationException;
import weblogic.management.MBeanHome;
import weblogic.management.ManagementException;
import weblogic.management.RemoteMBeanServer;
import weblogic.management.WebLogicMBean;
import weblogic.management.WebLogicObjectName;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.rmi.extensions.RemoteRuntimeException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class AdminMBeanHomeImpl
implements MBeanHome {
    private static DebugLogger debug = DebugLogger.getDebugLogger((String)"CompatabilityMBeanServer");
    private final MBeanHome mbeanHome;
    private final RuntimeAccess runtimeAccess;
    private final ObjectName domainObjectName;
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private Map managedHomes = Collections.synchronizedMap(new HashMap(32));
    private Context localJNDIContext;
    private static final String[] CREATOR_SIGNATURE = new String[]{String.class.getName()};

    public AdminMBeanHomeImpl(MBeanHome mBeanHome) {
        this.runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        this.mbeanHome = mBeanHome;
        this.managedHomes.put(this.runtimeAccess.getServerName(), mBeanHome);
        try {
            this.domainObjectName = new ObjectName(this.runtimeAccess.getDomainName() + ":" + "Name=" + this.runtimeAccess.getDomainName() + ",Type=Domain");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new Error(malformedObjectNameException);
        }
        try {
            Environment environment = this.getBaseEnvironment();
            this.localJNDIContext = environment.getInitialContext();
        }
        catch (NamingException namingException) {
            throw new Error(namingException);
        }
    }

    private Environment getBaseEnvironment() {
        Environment environment = new Environment();
        environment.setReplicateBindings(false);
        environment.setCreateIntermediateContexts(true);
        return environment;
    }

    private static boolean isAdminMBean(String string) {
        return !string.endsWith("Config") && !string.endsWith("Runtime");
    }

    public RemoteMBeanServer getMBeanServer() {
        return this.mbeanHome.getMBeanServer();
    }

    private MBeanHome getMBeanHomeForLocation(String string) {
        if (string == null) {
            return this.mbeanHome;
        }
        return (MBeanHome)this.managedHomes.get(string);
    }

    public Object getProxy(ObjectName objectName) throws InstanceNotFoundException {
        String string = objectName.getKeyProperty("Location");
        MBeanHome mBeanHome = this.getMBeanHomeForLocation(string);
        if (mBeanHome == null) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        try {
            return mBeanHome.getProxy(objectName);
        }
        catch (RemoteRuntimeException remoteRuntimeException) {
            this.managedHomes.remove(mBeanHome);
            throw new InstanceNotFoundException(objectName.toString());
        }
    }

    public WebLogicMBean getMBean(ObjectName objectName) throws InstanceNotFoundException {
        Object object = this.getProxy(objectName);
        if (object instanceof WebLogicMBean) {
            return (WebLogicMBean)object;
        }
        throw new InstanceNotFoundException("getMBean can be used only for weblogic mbeans");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebLogicMBean getMBean(String string, String string2, String string3) throws InstanceNotFoundException {
        if (this.managedHomes.size() == 1 || AdminMBeanHomeImpl.isAdminMBean(string2)) {
            return this.mbeanHome.getMBean(string, string2, string3);
        }
        try {
            return this.mbeanHome.getMBean(string, string2, string3);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            Map map = this.managedHomes;
            synchronized (map) {
                Iterator iterator = this.managedHomes.values().iterator();
                while (iterator.hasNext()) {
                    MBeanHome mBeanHome = null;
                    try {
                        mBeanHome = (MBeanHome)iterator.next();
                        if (this.mbeanHome.equals(mBeanHome)) continue;
                        return mBeanHome.getMBean(string, string2, string3);
                    }
                    catch (InstanceNotFoundException instanceNotFoundException2) {
                        if (!debug.isDebugEnabled()) continue;
                        debug.debug("Error getting MBean ", (Throwable)instanceNotFoundException2);
                    }
                    catch (RemoteRuntimeException remoteRuntimeException) {
                        iterator.remove();
                        if (!debug.isDebugEnabled()) continue;
                        debug.debug("Error getting MBean ", (Throwable)remoteRuntimeException);
                    }
                }
            }
            throw new InstanceNotFoundException(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebLogicMBean getMBean(String string, String string2) throws InstanceNotFoundException {
        if (this.managedHomes.size() == 1 || AdminMBeanHomeImpl.isAdminMBean(string2)) {
            return this.mbeanHome.getMBean(string, string2);
        }
        Map map = this.managedHomes;
        synchronized (map) {
            Iterator iterator = this.managedHomes.values().iterator();
            while (iterator.hasNext()) {
                MBeanHome mBeanHome = null;
                try {
                    mBeanHome = (MBeanHome)iterator.next();
                    return mBeanHome.getMBean(string, string2);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    if (!debug.isDebugEnabled()) continue;
                    debug.debug("Error getting MBean ", (Throwable)instanceNotFoundException);
                }
                catch (RemoteRuntimeException remoteRuntimeException) {
                    iterator.remove();
                    if (!debug.isDebugEnabled()) continue;
                    debug.debug("Error getting MBean ", (Throwable)remoteRuntimeException);
                }
            }
        }
        throw new InstanceNotFoundException(string);
    }

    public WebLogicMBean getMBean(String string, String string2, String string3, String string4) throws InstanceNotFoundException {
        if (this.managedHomes.containsKey(string4)) {
            return ((MBeanHome)this.managedHomes.get(string4)).getMBean(string, string2, string3, string4);
        }
        String string5 = "ObjectName:name=" + string + ",type=" + string2 + ",domain=" + string3 + ", location: " + string4;
        throw new InstanceNotFoundException(string5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebLogicMBean getMBean(String string, Class clazz) throws InstanceNotFoundException {
        Map map = this.managedHomes;
        synchronized (map) {
            Iterator iterator = this.managedHomes.values().iterator();
            while (iterator.hasNext()) {
                MBeanHome mBeanHome = null;
                try {
                    mBeanHome = (MBeanHome)iterator.next();
                    return mBeanHome.getMBean(string, clazz);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    if (!debug.isDebugEnabled()) continue;
                    debug.debug("Error getting MBean ", (Throwable)instanceNotFoundException);
                }
                catch (RemoteRuntimeException remoteRuntimeException) {
                    iterator.remove();
                    if (!debug.isDebugEnabled()) continue;
                    debug.debug("Error getting MBean ", (Throwable)remoteRuntimeException);
                }
            }
        }
        throw new InstanceNotFoundException(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getMBeansByType(String string) {
        if (this.managedHomes.size() == 1 || AdminMBeanHomeImpl.isAdminMBean(string)) {
            return this.mbeanHome.getMBeansByType(string);
        }
        HashSet hashSet = new HashSet();
        Map map = this.managedHomes;
        synchronized (map) {
            Iterator iterator = this.managedHomes.values().iterator();
            while (iterator.hasNext()) {
                MBeanHome mBeanHome = null;
                try {
                    mBeanHome = (MBeanHome)iterator.next();
                    hashSet.addAll(mBeanHome.getMBeansByType(string));
                }
                catch (RemoteRuntimeException remoteRuntimeException) {
                    iterator.remove();
                    if (!debug.isDebugEnabled()) continue;
                    debug.debug("Error getting MBeans by type ", (Throwable)remoteRuntimeException);
                }
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getAllMBeans(String string) {
        HashSet hashSet = new HashSet();
        Map map = this.managedHomes;
        synchronized (map) {
            Iterator iterator = this.managedHomes.values().iterator();
            while (iterator.hasNext()) {
                MBeanHome mBeanHome = null;
                try {
                    mBeanHome = (MBeanHome)iterator.next();
                    hashSet.addAll(mBeanHome.getAllMBeans(string));
                }
                catch (RemoteRuntimeException remoteRuntimeException) {
                    iterator.remove();
                    if (!debug.isDebugEnabled()) continue;
                    debug.debug("Error getting all MBeans ", (Throwable)remoteRuntimeException);
                }
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getAllMBeans() {
        HashSet hashSet = new HashSet();
        Map map = this.managedHomes;
        synchronized (map) {
            Iterator iterator = this.managedHomes.values().iterator();
            while (iterator.hasNext()) {
                MBeanHome mBeanHome = null;
                try {
                    mBeanHome = (MBeanHome)iterator.next();
                    hashSet.addAll(mBeanHome.getAllMBeans());
                }
                catch (RemoteRuntimeException remoteRuntimeException) {
                    iterator.remove();
                    if (!debug.isDebugEnabled()) continue;
                    debug.debug("Error getting all MBeans ", (Throwable)remoteRuntimeException);
                }
            }
        }
        return hashSet;
    }

    public ConfigurationMBean getAdminMBean(String string, String string2) throws InstanceNotFoundException {
        return this.mbeanHome.getAdminMBean(string, string2);
    }

    public ConfigurationMBean getAdminMBean(String string, String string2, String string3) throws InstanceNotFoundException {
        return this.mbeanHome.getAdminMBean(string, string2, string3);
    }

    public ConfigurationMBean getConfigurationMBean(String string, String string2) throws InstanceNotFoundException {
        return this.mbeanHome.getConfigurationMBean(string, string2);
    }

    public RuntimeMBean getRuntimeMBean(String string, String string2) throws InstanceNotFoundException {
        return this.mbeanHome.getRuntimeMBean(string, string2);
    }

    public DomainMBean getActiveDomain() {
        try {
            return (DomainMBean)this.mbeanHome.getMBean(this.getDomainName(), "Domain");
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new AssertionError((Object)instanceNotFoundException);
        }
    }

    public String getDomainName() {
        return ManagementService.getRuntimeAccess(kernelId).getDomainName();
    }

    public void addManagedHome(MBeanHome mBeanHome, String string, String string2) {
        block6: {
            try {
                Environment environment = this.getBaseEnvironment();
                environment.setProviderUrl(string2);
                Context context = environment.getInitialContext();
                context.rebind("weblogic.management.adminhome", (Object)this);
            }
            catch (NamingException namingException) {
                if (debug.isDebugEnabled()) {
                    debug.debug("Unable to bind in to the remote mbean home for " + string, (Throwable)namingException);
                }
                return;
            }
            try {
                this.localJNDIContext.bind("weblogic.management.home." + string, (Object)mBeanHome);
            }
            catch (NamingException namingException) {
                if (!debug.isDebugEnabled()) break block6;
                debug.debug("Unable to connect to bind managed MBeanHome", (Throwable)namingException);
            }
        }
        this.managedHomes.put(string, mBeanHome);
        if (debug.isDebugEnabled()) {
            debug.debug("Added managed home,  server name " + string + ", server URL " + string2);
        }
    }

    void removeManagedHome(String string) {
        block3: {
            try {
                this.localJNDIContext.unbind("weblogic.management.home." + string);
            }
            catch (NamingException namingException) {
                if (!debug.isDebugEnabled()) break block3;
                debug.debug("Unable to connect to " + string, (Throwable)namingException);
            }
        }
        this.managedHomes.remove(string);
        if (debug.isDebugEnabled()) {
            debug.debug("Removed managed home,  server name " + string);
        }
    }

    public WebLogicMBean createAdminMBean(String string, String string2, String string3, ConfigurationMBean configurationMBean) throws MBeanCreationException {
        Object object = configurationMBean != null ? configurationMBean.getObjectName() : this.domainObjectName;
        String string4 = "create" + string2;
        Object[] objectArray = new String[]{string};
        ObjectName objectName = null;
        try {
            objectName = (ObjectName)this.getMBeanServer().invoke((ObjectName)object, string4, objectArray, CREATOR_SIGNATURE);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new MBeanCreationException("Unable to create new bean of type " + string2 + " for " + object + ":parent not found", (Throwable)instanceNotFoundException);
        }
        catch (MBeanException mBeanException) {
            throw new MBeanCreationException("Unable to create new bean of type " + string2 + " for " + object + ":unexpected exception", (Throwable)mBeanException);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw new MBeanCreationException("Unable to create new bean of type " + string2 + " for " + object + ":unexpected exception", (Throwable)runtimeMBeanException);
        }
        catch (ReflectionException reflectionException) {
            if (string2 != null && string2.endsWith("Runtime")) {
                throw new MBeanCreationException("Explicit create of a RuntimeMBean is not allowed");
            }
            throw new MBeanCreationException("Unable to create new bean of type " + string2 + " for " + object + ":missing create method", (Throwable)reflectionException);
        }
        try {
            return this.getMBean(objectName);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new MBeanCreationException("Unable to acquire proxy for " + objectName);
        }
    }

    public WebLogicMBean createAdminMBean(String string, String string2, String string3) throws MBeanCreationException {
        return this.createAdminMBean(string, string2, string3, null);
    }

    public WebLogicMBean createAdminMBean(String string, String string2) throws MBeanCreationException {
        return this.createAdminMBean(string, string2, null, null);
    }

    public ConfigurationMBean findOrCreateAdminMBean(String string, String string2) throws MBeanCreationException {
        try {
            return this.getAdminMBean(string, string2);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            return (ConfigurationMBean)this.createAdminMBean(string, string2, null, null);
        }
    }

    public ConfigurationMBean findOrCreateAdminMBean(String string, String string2, String string3) throws MBeanCreationException {
        try {
            return this.getAdminMBean(string, string2, string3);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            return (ConfigurationMBean)this.createAdminMBean(string, string2, string3, null);
        }
    }

    public ConfigurationMBean findOrCreateAdminMBean(String string, String string2, String string3, ConfigurationMBean configurationMBean) throws MBeanCreationException {
        try {
            return this.getAdminMBean(string, string2, string3);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            return (ConfigurationMBean)this.createAdminMBean(string, string2, string3, configurationMBean);
        }
    }

    public void deleteMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        ObjectName objectName2 = null;
        objectName2 = objectName instanceof WebLogicObjectName ? this.domainObjectName : this.domainObjectName;
        this.deleteMBean(objectName, objectName2);
    }

    private void deleteMBean(ObjectName objectName, ObjectName objectName2) throws InstanceNotFoundException, MBeanRegistrationException {
        String string = objectName.getKeyProperty("Type");
        String string2 = "destroy" + string;
        Object[] objectArray = new Object[]{objectName};
        String[] stringArray = new String[]{ObjectName.class.getName()};
        try {
            this.getMBeanServer().invoke(objectName2, string2, objectArray, stringArray);
        }
        catch (ReflectionException reflectionException) {
            Throwable throwable = reflectionException.getCause();
            if (string != null && string.endsWith("Runtime") && throwable != null && throwable instanceof NoSuchMethodException) {
                String string3 = "Explicit delete of a RuntimeMBean of type : " + string + "  is not allowed";
                ManagementException managementException = new ManagementException(string3);
                throw new MBeanRegistrationException((Exception)((Object)managementException));
            }
            InstanceNotFoundException instanceNotFoundException = new InstanceNotFoundException("Unable to delete an MBean " + reflectionException);
            instanceNotFoundException.initCause(reflectionException);
            throw instanceNotFoundException;
        }
        catch (MBeanException mBeanException) {
            throw new MBeanRegistrationException(mBeanException);
        }
    }

    public void deleteMBean(WebLogicMBean webLogicMBean) throws InstanceNotFoundException, MBeanRegistrationException {
        WebLogicMBean webLogicMBean2 = webLogicMBean.getParent();
        if (webLogicMBean2 == null) {
            this.deleteMBean((ObjectName)webLogicMBean.getObjectName());
        } else {
            this.deleteMBean((ObjectName)webLogicMBean.getObjectName(), (ObjectName)webLogicMBean2.getObjectName());
        }
    }
}

