/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.compatibility.internal;

import java.rmi.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.management.MBeanServer;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.jndi.Environment;
import weblogic.management.MBeanHome;
import weblogic.management.ManagementLogger;
import weblogic.management.RemoteMBeanServer;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.jmx.ObjectNameManager;
import weblogic.management.jmx.ObjectSecurityManager;
import weblogic.management.jmx.mbeanserver.WLSMBeanServer;
import weblogic.management.jmx.mbeanserver.WLSMBeanServerBuilder;
import weblogic.management.jmx.mbeanserver.WLSMBeanServerInterceptor;
import weblogic.management.jmx.modelmbean.WLSModelMBeanContext;
import weblogic.management.jmx.modelmbean.WLSModelMBeanFactory;
import weblogic.management.mbeanservers.compatibility.internal.AdminMBeanHomeImpl;
import weblogic.management.mbeanservers.compatibility.internal.CompatibilityInterceptor;
import weblogic.management.mbeanservers.compatibility.internal.CompatibilityObjectNameManager;
import weblogic.management.mbeanservers.compatibility.internal.EditServiceInterceptor;
import weblogic.management.mbeanservers.compatibility.internal.MBeanHomeImpl;
import weblogic.management.mbeanservers.compatibility.internal.PropertyChangeNotificationTranslator;
import weblogic.management.mbeanservers.compatibility.internal.RemoteMBeanServerImpl;
import weblogic.management.mbeanservers.compatibility.internal.ReparentingInterceptor;
import weblogic.management.mbeanservers.internal.RuntimeMBeanAgent;
import weblogic.management.mbeanservers.internal.SecurityInterceptor;
import weblogic.management.mbeanservers.internal.WLSObjectSecurityManagerImpl;
import weblogic.management.provider.EditAccess;
import weblogic.management.provider.EditFailedException;
import weblogic.management.provider.MSIService;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.ManagementServiceRestricted;
import weblogic.management.provider.RuntimeAccess;
import weblogic.protocol.ConnectMonitorFactory;
import weblogic.protocol.URLManager;
import weblogic.rmi.extensions.ConnectEvent;
import weblogic.rmi.extensions.ConnectListener;
import weblogic.rmi.extensions.ConnectMonitor;
import weblogic.rmi.extensions.DisconnectEvent;
import weblogic.rmi.extensions.DisconnectListener;
import weblogic.rmi.extensions.PortableRemoteObject;
import weblogic.rmi.extensions.RemoteRuntimeException;
import weblogic.rmi.extensions.ServerDisconnectEvent;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;

public class CompatibilityMBeanServerService
extends AbstractServerService {
    private static DebugLogger debug = DebugLogger.getDebugLogger((String)"DebugJMXCompatibility");
    private static final String COMPATABILITY_VERSION = "8.1.0.0";
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private WLSModelMBeanContext context = null;
    private Context localJNDIContext;
    MBeanHome adminHome;

    public void start() throws ServiceFailureException {
        block22: {
            Environment environment;
            Object object;
            Object object2;
            RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
            if (!runtimeAccess.getDomain().getJMX().isCompatibilityMBeanServerEnabled()) {
                debug.debug("Compatability MBeanServer is Disabled");
                return;
            }
            if (debug.isDebugEnabled()) {
                debug.debug("Starting Compatability MBeanServer ");
            }
            WLSMBeanServerBuilder wLSMBeanServerBuilder = new WLSMBeanServerBuilder();
            WLSMBeanServer wLSMBeanServer = (WLSMBeanServer)wLSMBeanServerBuilder.newMBeanServer(runtimeAccess.getDomainName(), null, null);
            CompatibilityObjectNameManager compatibilityObjectNameManager = new CompatibilityObjectNameManager();
            SecurityInterceptor securityInterceptor = new SecurityInterceptor(wLSMBeanServer);
            wLSMBeanServer.addInterceptor((WLSMBeanServerInterceptor)securityInterceptor);
            CompatibilityInterceptor compatibilityInterceptor = new CompatibilityInterceptor();
            wLSMBeanServer.addInterceptor((WLSMBeanServerInterceptor)compatibilityInterceptor);
            if (runtimeAccess.isAdminServer()) {
                object2 = ManagementServiceRestricted.getEditAccess(kernelId);
                object = new EditServiceInterceptor((EditAccess)object2, wLSMBeanServer);
                wLSMBeanServer.addInterceptor((WLSMBeanServerInterceptor)object);
                wLSMBeanServer.addInterceptor((WLSMBeanServerInterceptor)new ReparentingInterceptor());
            }
            wLSMBeanServer.setFirstAccessCallback(this.createAccessCallback());
            object2 = new RemoteMBeanServerImpl((MBeanServer)wLSMBeanServer);
            this.context = new WLSModelMBeanContext((MBeanServer)wLSMBeanServer, (ObjectNameManager)compatibilityObjectNameManager, (ObjectSecurityManager)WLSObjectSecurityManagerImpl.getInstance());
            this.context.setVersion(COMPATABILITY_VERSION);
            this.context.setReadOnly(false);
            this.context.setRecurse(true);
            this.context.setFilteringEnabled(true);
            this.context.setNotificationFactoryClassName(PropertyChangeNotificationTranslator.class.getName());
            object = new MBeanHomeImpl((RemoteMBeanServer)object2);
            ((RemoteMBeanServerImpl)object2).setMBeanHome((MBeanHome)object);
            Environment environment2 = this.getBaseEnvironment();
            try {
                this.localJNDIContext = environment2.getInitialContext();
                this.localJNDIContext.rebind("weblogic.management.server", object2);
            }
            catch (NamingException namingException) {
                throw new ServiceFailureException("Unable to initialize Compatability Service", (Throwable)namingException);
            }
            if (runtimeAccess.isAdminServer()) {
                this.adminHome = new AdminMBeanHomeImpl((MBeanHome)object);
                try {
                    this.localJNDIContext.rebind("weblogic.management.adminhome", (Object)this.adminHome);
                }
                catch (NamingException namingException) {
                    throw new ServiceFailureException("Unable to initialize Compatability Service", (Throwable)namingException);
                }
                environment = ConnectMonitorFactory.getConnectMonitor();
                environment.addConnectDisconnectListener(this.createAdminServerConnectListener(), this.createAdminServerDisconnectListener());
            } else {
                environment = this.getBaseEnvironment();
                String string = runtimeAccess.getAdminServerName();
                String string2 = this.getAdminstrationServerURL(string);
                environment.setProviderUrl(string2);
                try {
                    if (!runtimeAccess.isAdminServerAvailable()) {
                        this.initForMSI((MBeanHome)object);
                        MSIService.getMSIService().registerForReconnectToAdminServer();
                        ConnectMonitor connectMonitor = ConnectMonitorFactory.getConnectMonitor();
                        connectMonitor.addConnectListener(this.createMSIConnectListener());
                    } else {
                        Context context = environment.getInitialContext();
                        MBeanHome mBeanHome = (MBeanHome)PortableRemoteObject.narrow((Object)context.lookup("weblogic.management.adminhome"), MBeanHome.class);
                        String string3 = runtimeAccess.getServerName();
                        String string4 = URLManager.findAdministrationURL(string3);
                        if (mBeanHome != null) {
                            mBeanHome.addManagedHome((MBeanHome)object, string3, string4);
                        }
                    }
                }
                catch (NamingException namingException) {
                    if (debug.isDebugEnabled()) {
                        debug.debug("Unable to connect to the administration server.", (Throwable)namingException);
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    if (debug.isDebugEnabled()) {
                        debug.debug("Unable to find the administration server URL.", (Throwable)unknownHostException);
                    }
                }
                catch (RemoteRuntimeException remoteRuntimeException) {
                    if (debug.isDebugEnabled()) {
                        debug.debug("Unable to reach the administration server URL.", (Throwable)remoteRuntimeException);
                    }
                    ManagementLogger.logASNotReachable();
                }
            }
            try {
                this.localJNDIContext.bind("weblogic.management.home.localhome", object);
                this.localJNDIContext.bind("weblogic.management.home." + runtimeAccess.getServerName(), object);
            }
            catch (NamingException namingException) {
                if (!debug.isDebugEnabled()) break block22;
                debug.debug("Unable to connect to the administration server.", (Throwable)namingException);
            }
        }
        if (debug.isDebugEnabled()) {
            debug.debug("Started Compatability MBeanServer ");
        }
    }

    String getAdminstrationServerURL(String string) {
        String string2 = null;
        try {
            string2 = URLManager.findAdministrationURL(string);
        }
        catch (UnknownHostException unknownHostException) {
            if (debug.isDebugEnabled()) {
                debug.debug("Unable to get administration url.", (Throwable)unknownHostException);
            }
            string2 = ManagementService.getPropertyService(kernelId).getAdminBinaryURL();
        }
        return string2;
    }

    private void initForMSI(MBeanHome mBeanHome) throws ServiceFailureException {
        this.adminHome = new AdminMBeanHomeImpl(mBeanHome);
        try {
            this.localJNDIContext.rebind("weblogic.management.adminhome", (Object)this.adminHome);
        }
        catch (NamingException namingException) {
            throw new ServiceFailureException("Unable to initialize Compatability Service", (Throwable)namingException);
        }
    }

    private Environment getBaseEnvironment() {
        Environment environment = new Environment();
        environment.setReplicateBindings(false);
        environment.setCreateIntermediateContexts(true);
        return environment;
    }

    private WLSMBeanServer.FirstAccessCallback createAccessCallback() {
        return new WLSMBeanServer.FirstAccessCallback(){

            public void accessed(MBeanServer mBeanServer) {
                SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)kernelId, (PrivilegedAction)new PrivilegedAction(){

                    public Object run() {
                        CompatibilityMBeanServerService.this.registerAllMBeans();
                        return null;
                    }
                });
            }
        };
    }

    private void registerAllMBeans() {
        DomainMBean domainMBean;
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        WLSModelMBeanContext wLSModelMBeanContext = new WLSModelMBeanContext(this.context.getMBeanServer(), this.context.getNameManager(), this.context.getSecurityManager());
        wLSModelMBeanContext.setVersion(this.context.getVersion());
        wLSModelMBeanContext.setReadOnly(false);
        wLSModelMBeanContext.setRecurse(false);
        wLSModelMBeanContext.setNotificationFactoryClassName(PropertyChangeNotificationTranslator.class.getName());
        new RuntimeMBeanAgent(wLSModelMBeanContext, runtimeAccess);
        if (runtimeAccess.isAdminServer() || !runtimeAccess.isAdminServerAvailable()) {
            if (runtimeAccess.isAdminServer()) {
                new RuntimeMBeanAgent(wLSModelMBeanContext, ManagementService.getDomainAccess(kernelId));
            }
            domainMBean = null;
            try {
                domainMBean = ManagementServiceRestricted.getEditAccess(kernelId).getDomainBeanWithoutLock();
                runtimeAccess.initializeCallbacks(domainMBean);
            }
            catch (EditFailedException editFailedException) {
                throw new Error((Throwable)((Object)editFailedException));
            }
            WLSModelMBeanContext wLSModelMBeanContext2 = new WLSModelMBeanContext(this.context.getMBeanServer(), this.context.getNameManager(), this.context.getSecurityManager());
            wLSModelMBeanContext2.setVersion(this.context.getVersion());
            wLSModelMBeanContext2.setReadOnly(false);
            wLSModelMBeanContext2.setRecurse(true);
            wLSModelMBeanContext2.setFilteringEnabled(true);
            wLSModelMBeanContext2.setNotificationFactoryClassName(PropertyChangeNotificationTranslator.class.getName());
            WLSModelMBeanFactory.registerWLSModelMBean((Object)domainMBean, (WLSModelMBeanContext)wLSModelMBeanContext2);
        }
        domainMBean = runtimeAccess.getDomain();
        runtimeAccess.initializeCallbacks(domainMBean);
        this.context.setReadOnly(true);
        this.context.setFilteringEnabled(false);
        WLSModelMBeanFactory.registerWLSModelMBean((Object)domainMBean, (WLSModelMBeanContext)this.context);
        this.context.setReadOnly(false);
        this.context.setFilteringEnabled(true);
    }

    public void stop() throws ServiceFailureException {
    }

    public void halt() throws ServiceFailureException {
        this.stop();
    }

    private ConnectListener createAdminServerConnectListener() {
        return new ConnectListener(){

            public void onConnect(ConnectEvent connectEvent) {
                String string = connectEvent.getServerName();
                if (debug.isDebugEnabled()) {
                    debug.debug("onConnect received for = " + string);
                }
                CompatibilityMBeanServerService.this.connectToManagedServer(string);
            }
        };
    }

    private void connectToManagedServer(String string) {
        MBeanHome mBeanHome;
        String string2;
        try {
            string2 = URLManager.findAdministrationURL(string);
        }
        catch (UnknownHostException unknownHostException) {
            if (debug.isDebugEnabled()) {
                debug.debug("Unable to connect to " + string, (Throwable)unknownHostException);
            }
            return;
        }
        try {
            Environment environment = this.getBaseEnvironment();
            environment.setProviderUrl(string2);
            Context context = environment.getInitialContext();
            mBeanHome = (MBeanHome)context.lookup("weblogic.management.home.localhome");
        }
        catch (NamingException namingException) {
            if (debug.isDebugEnabled()) {
                debug.debug("Unable to connect to " + string, (Throwable)namingException);
            }
            return;
        }
        this.adminHome.addManagedHome(mBeanHome, string, string2);
        if (debug.isDebugEnabled()) {
            debug.debug("registered mbean home for = " + string);
        }
    }

    private DisconnectListener createAdminServerDisconnectListener() {
        return new DisconnectListener(){

            public void onDisconnect(DisconnectEvent disconnectEvent) {
                String string = ((ServerDisconnectEvent)disconnectEvent).getServerName();
                if (debug.isDebugEnabled()) {
                    debug.debug("onDisconnect event from server = " + string);
                }
                CompatibilityMBeanServerService.this.removeMBeanHome(string);
            }
        };
    }

    private void removeMBeanHome(String string) {
        block2: {
            ((AdminMBeanHomeImpl)this.adminHome).removeManagedHome(string);
            try {
                this.localJNDIContext.unbind("weblogic.management.home." + string);
            }
            catch (NamingException namingException) {
                if (!debug.isDebugEnabled()) break block2;
                debug.debug("Unable to unbind to " + string, (Throwable)namingException);
            }
        }
    }

    private ConnectListener createMSIConnectListener() {
        return new ConnectListener(){

            public void onConnect(ConnectEvent connectEvent) {
                if (debug.isDebugEnabled()) {
                    debug.debug("onConnect event, server = " + connectEvent.getServerName());
                }
                RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
                if (!connectEvent.getServerName().equals(runtimeAccess.getAdminServerName())) {
                    return;
                }
                if (debug.isDebugEnabled()) {
                    debug.debug("onConnect setting admin server available.");
                }
            }
        };
    }
}

