/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.compatibility.internal;

import java.security.AccessController;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import weblogic.descriptor.DescriptorBean;
import weblogic.management.WebLogicMBean;
import weblogic.management.WebLogicObjectName;
import weblogic.management.commo.StandardInterface;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.jmx.ObjectNameManagerBase;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class CompatibilityObjectNameManager
extends ObjectNameManagerBase {
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public CompatibilityObjectNameManager() {
        super(DescriptorBean.class);
    }

    public boolean isFiltered(Object object) {
        return !(object instanceof WebLogicMBean);
    }

    public boolean isClassMapped(Class clazz) {
        if (WebLogicMBean.class.isAssignableFrom(clazz)) {
            return true;
        }
        return StandardInterface.class.isAssignableFrom(clazz);
    }

    public ObjectName lookupObjectName(Object object) {
        ObjectName objectName = super.lookupObjectName(object);
        if (objectName != null) {
            return objectName;
        }
        objectName = this.buildObjectName(object);
        assert (objectName != null) : "Unable to build ObjectName for " + object;
        if (!this.isFiltered(object)) {
            super.registerObject(objectName, object);
        }
        return objectName;
    }

    public ObjectName buildObjectName(Object object) {
        if (object instanceof WebLogicMBean) {
            return CompatibilityObjectNameManager.buildWLSObjectName(object);
        }
        if (object instanceof StandardInterface) {
            return CompatibilityObjectNameManager.buildCommoObjectName(object);
        }
        return null;
    }

    public static ObjectName buildWLSObjectName(Object object) {
        Object object2;
        String string = ManagementService.getRuntimeAccess(kernelId).getDomainName();
        String string2 = ManagementService.getRuntimeAccess(kernelId).getServerName();
        WebLogicObjectName webLogicObjectName = null;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        WebLogicMBean webLogicMBean = (WebLogicMBean)object;
        String string3 = webLogicMBean.getType();
        boolean bl = false;
        if (webLogicMBean instanceof ConfigurationMBean && !(object2 = (ConfigurationMBean)webLogicMBean).isEditable()) {
            string3 = string3 + "Config";
            bl = true;
        }
        hashtable.put("Type", string3);
        object2 = webLogicMBean.getName();
        for (WebLogicMBean webLogicMBean2 = webLogicMBean.getParent(); object2 == null && webLogicMBean2 != null; webLogicMBean2 = webLogicMBean2.getParent()) {
            object2 = webLogicMBean2.getName();
        }
        hashtable.put("Name", object2);
        if (bl || webLogicMBean instanceof RuntimeMBean) {
            hashtable.put("Location", string2);
        }
        for (WebLogicMBean webLogicMBean3 = webLogicMBean.getParent(); webLogicMBean3 != null && !(webLogicMBean3 instanceof DomainMBean); webLogicMBean3 = webLogicMBean3.getParent()) {
            String string4 = bl ? webLogicMBean3.getType() + "Config" : webLogicMBean3.getType();
            hashtable.put(string4, webLogicMBean3.getName());
        }
        try {
            if (string3.equals("AdminServer")) {
                string = "weblogic";
            }
            webLogicObjectName = new WebLogicObjectName(string, CompatibilityObjectNameManager.quoteObjectNameEntries(hashtable));
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new AssertionError((Object)("There is problem in constructing ObjectName " + malformedObjectNameException));
        }
        return webLogicObjectName;
    }

    private static ObjectName buildCommoObjectName(Object object) {
        if (!(object instanceof StandardInterface)) {
            throw new AssertionError((Object)(" Invalid object to register" + object));
        }
        return ((StandardInterface)object).wls_getObjectName();
    }
}

