/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.compatibility.internal;

import java.io.IOException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import weblogic.application.ModuleException;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.logging.Loggable;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.ManagementLogger;
import weblogic.management.jmx.mbeanserver.WLSMBeanServer;
import weblogic.management.jmx.mbeanserver.WLSMBeanServerInterceptorBase;
import weblogic.management.jmx.modelmbean.WLSModelMBean;
import weblogic.management.provider.ActivateTask;
import weblogic.management.provider.EditAccess;
import weblogic.management.provider.EditChangesValidationException;
import weblogic.management.provider.EditFailedException;
import weblogic.management.provider.EditNotEditorException;
import weblogic.management.provider.EditSaveChangesFailedException;
import weblogic.management.provider.EditWaitTimedOutException;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.UpdateException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class EditServiceInterceptor
extends WLSMBeanServerInterceptorBase {
    private static DebugLogger debug = DebugLogger.getDebugLogger((String)"CompatabilityMBeanServer");
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private WLSMBeanServer wlsMBeanServer;
    private EditAccess editAccess;

    public EditServiceInterceptor(EditAccess editAccess, WLSMBeanServer wLSMBeanServer) {
        this.editAccess = editAccess;
        this.wlsMBeanServer = wLSMBeanServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        ObjectInstance objectInstance = null;
        boolean bl = this.editRequired(objectName);
        if (bl) {
            EditServiceInterceptor editServiceInterceptor = this;
            synchronized (editServiceInterceptor) {
                try {
                    this.startEdit();
                    objectInstance = super.createMBean(string, objectName);
                    this.completeEdit(null);
                    bl = false;
                }
                finally {
                    if (bl) {
                        this.stopEdit();
                    }
                }
            }
        }
        objectInstance = super.createMBean(string, objectName);
        return objectInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        boolean bl = this.editRequired(objectName);
        ObjectInstance objectInstance = null;
        if (bl) {
            EditServiceInterceptor editServiceInterceptor = this;
            synchronized (editServiceInterceptor) {
                try {
                    this.startEdit();
                    objectInstance = super.createMBean(string, objectName, objectName2);
                    this.completeEdit(null);
                    bl = false;
                }
                finally {
                    if (bl) {
                        this.stopEdit();
                    }
                }
            }
        }
        objectInstance = super.createMBean(string, objectName, objectName2);
        return objectInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        boolean bl = this.editRequired(objectName);
        ObjectInstance objectInstance = null;
        if (bl) {
            EditServiceInterceptor editServiceInterceptor = this;
            synchronized (editServiceInterceptor) {
                try {
                    this.startEdit();
                    objectInstance = super.createMBean(string, objectName, objectArray, stringArray);
                    this.completeEdit(null);
                    bl = false;
                }
                finally {
                    if (bl) {
                        this.stopEdit();
                    }
                }
            }
        }
        objectInstance = super.createMBean(string, objectName, objectArray, stringArray);
        return objectInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        boolean bl = this.editRequired(objectName);
        ObjectInstance objectInstance = null;
        if (bl) {
            EditServiceInterceptor editServiceInterceptor = this;
            synchronized (editServiceInterceptor) {
                try {
                    this.startEdit();
                    objectInstance = super.createMBean(string, objectName, objectName2, objectArray, stringArray);
                    this.completeEdit(null);
                    bl = false;
                }
                finally {
                    if (bl) {
                        this.stopEdit();
                    }
                }
            }
        }
        objectInstance = super.createMBean(string, objectName, objectName2, objectArray, stringArray);
        return objectInstance;
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        super.unregisterMBean(objectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        block26: {
            Object object;
            boolean bl = this.editRequired(objectName);
            this.checkForMSConfigModification();
            if (attribute != null && (object = attribute.getValue()) != null && object.toString().length() == 0 && this.wlsMBeanServer.isInstanceOf(objectName, "weblogic.management.WebLogicMBean")) {
                return;
            }
            object = null;
            WLSModelMBean wLSModelMBean = this.lookupWLSModelMBean(objectName);
            if (wLSModelMBean != null) {
                object = wLSModelMBean.getSetterMethod(attribute.getName());
            }
            try {
                if (bl) {
                    EditServiceInterceptor editServiceInterceptor = this;
                    synchronized (editServiceInterceptor) {
                        try {
                            this.startEdit();
                            super.setAttribute(objectName, attribute);
                            this.completeEdit((Method)object);
                            bl = false;
                        }
                        finally {
                            if (bl) {
                                this.stopEdit();
                            }
                        }
                        break block26;
                    }
                }
                super.setAttribute(objectName, attribute);
            }
            catch (MBeanException mBeanException) {
                Throwable throwable;
                Throwable throwable2 = mBeanException.getCause();
                if (throwable2 != null && (throwable2 instanceof EditFailedException || throwable2 instanceof UpdateException)) {
                    if (debug.isDebugEnabled()) {
                        debug.debug("Got Edit failure - see if should be mapped to InvalidAttributeValueException: ", throwable2);
                    }
                    if ((throwable = throwable2.getCause()) != null && throwable instanceof BeanUpdateRejectedException) {
                        InvalidAttributeValueException invalidAttributeValueException = new InvalidAttributeValueException(throwable2.getMessage());
                        invalidAttributeValueException.initCause(throwable);
                        throw invalidAttributeValueException;
                    }
                }
                if (throwable2 != null && throwable2 instanceof ModuleException) {
                    if (debug.isDebugEnabled()) {
                        debug.debug("Got Edit failure - see if should be mapped to InvalidAttributeValueException: ", throwable2);
                    }
                    if ((throwable = throwable2.getCause()) != null && throwable instanceof IllegalArgumentException) {
                        InvalidAttributeValueException invalidAttributeValueException = new InvalidAttributeValueException(throwable2.getMessage());
                        invalidAttributeValueException.initCause(throwable);
                        throw invalidAttributeValueException;
                    }
                }
                if (throwable2 != null && throwable2 instanceof IllegalArgumentException) {
                    if (debug.isDebugEnabled()) {
                        debug.debug("Got IllegalArgumentException - mapping to InvalidAttributeValueException: ", (Throwable)mBeanException);
                    }
                    throwable = new InvalidAttributeValueException(throwable2.getMessage());
                    throwable.initCause(throwable2);
                    throw throwable;
                }
                if (throwable2 != null && throwable2 instanceof EditChangesValidationException) {
                    if (debug.isDebugEnabled()) {
                        debug.debug("Got EditChangesValidationException - mapping to InvalidAttributeValueException: ", (Throwable)mBeanException);
                    }
                    throwable = new InvalidAttributeValueException(throwable2.getMessage());
                    throwable.initCause(throwable2);
                    throw throwable;
                }
                if (throwable2 != null && throwable2 instanceof BeanUpdateRejectedException) {
                    if (debug.isDebugEnabled()) {
                        debug.debug("Got BeanUpdateRejectedException - mapping to InvalidAttributeValueException: ", (Throwable)mBeanException);
                    }
                    throwable = new InvalidAttributeValueException(throwable2.getMessage());
                    throwable.initCause(throwable2);
                    throw throwable;
                }
                if (debug.isDebugEnabled()) {
                    debug.debug("Got exception - could not map exception.", (Throwable)mBeanException);
                }
                throw mBeanException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException, IOException {
        try {
            this.checkForMSConfigModification();
            boolean bl = this.editRequired(objectName);
            AttributeList attributeList2 = null;
            if (bl) {
                EditServiceInterceptor editServiceInterceptor = this;
                synchronized (editServiceInterceptor) {
                    try {
                        this.startEdit();
                        attributeList2 = super.setAttributes(objectName, attributeList);
                        this.completeEdit(null);
                        bl = false;
                    }
                    finally {
                        if (bl) {
                            this.stopEdit();
                        }
                    }
                }
            }
            attributeList2 = super.setAttributes(objectName, attributeList);
            return attributeList2;
        }
        catch (MBeanException mBeanException) {
            throw (JMRuntimeException)new JMRuntimeException(mBeanException.getMessage()).initCause(mBeanException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        Object object;
        Object object2;
        boolean bl = false;
        boolean bl2 = false;
        if (!this.isAdminMBean(objectName)) {
            return super.invoke(objectName, string, objectArray, stringArray);
        }
        WLSModelMBean wLSModelMBean = this.lookupWLSModelMBean(objectName);
        Method method = null;
        if (wLSModelMBean != null) {
            object2 = wLSModelMBean.getRole(string, objectArray, stringArray);
            if (object2 != null) {
                if (((String)object2).equals("factory") || ((String)object2).equals("collection")) {
                    bl = true;
                } else if (((String)object2).equals("operation")) {
                    object = wLSModelMBean.getImpact(string, objectArray, stringArray);
                    if (object != null && !((String)object).equals("info")) {
                        bl = true;
                    }
                    if (object == null) {
                        bl2 = true;
                    }
                }
            } else {
                bl2 = true;
            }
            method = wLSModelMBean.getMethod(string, stringArray);
        }
        if (!bl) {
            if (bl2) {
                boolean bl3 = this.editAccess.isModified();
                object = super.invoke(objectName, string, objectArray, stringArray);
                if (!bl3 && this.editAccess.isModified()) {
                    ManagementLogger.logCompatibilityInvokeModifiedConfig((String)("" + objectName), (String)string);
                }
                return object;
            }
            return super.invoke(objectName, string, objectArray, stringArray);
        }
        object2 = this;
        synchronized (object2) {
            Object object3;
            block19: {
                object = null;
                this.startEdit();
                try {
                    object = super.invoke(objectName, string, objectArray, stringArray);
                    this.completeEdit(method);
                    bl = false;
                    object3 = object;
                    if (!bl) break block19;
                    this.stopEdit();
                }
                catch (Throwable throwable) {
                    if (bl) {
                        this.stopEdit();
                    }
                    throw throwable;
                }
            }
            return object3;
        }
    }

    private WLSModelMBean lookupWLSModelMBean(ObjectName objectName) {
        Object object = this.wlsMBeanServer.lookupObject(objectName);
        if (object != null && object instanceof WLSModelMBean) {
            WLSModelMBean wLSModelMBean = (WLSModelMBean)object;
            return wLSModelMBean;
        }
        return null;
    }

    private boolean editRequired(ObjectName objectName) {
        return this.isAdminMBean(objectName);
    }

    private void startEdit() throws MBeanException {
        block5: {
            try {
                this.editAccess.startEdit(-1, 300000);
                if (!this.editAccess.isPendingChange()) break block5;
                Loggable loggable = ManagementLogger.logCompatibilityWithPendingChangesLoggable();
                loggable.log();
                try {
                    this.editAccess.stopEdit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new EditFailedException(loggable.getMessage());
            }
            catch (EditWaitTimedOutException editWaitTimedOutException) {
                throw new MBeanException((Exception)((Object)editWaitTimedOutException), "Unable to modify the configuration");
            }
            catch (EditFailedException editFailedException) {
                throw new MBeanException((Exception)((Object)editFailedException), "Unable to modify the configuration");
            }
        }
    }

    private void rethrowException(Exception exception, Method method) throws MBeanException {
        if (debug.isDebugEnabled()) {
            debug.debug("About to rethrow exception.", (Throwable)exception);
        }
        if (exception instanceof MBeanException) {
            throw (MBeanException)exception;
        }
        if (method == null) {
            throw new MBeanException(exception);
        }
        Class<?>[] classArray = method.getExceptionTypes();
        if (classArray == null || classArray.length == 0) {
            throw new MBeanException(exception);
        }
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz = classArray[i];
            if (!clazz.equals(DistributedManagementException.class)) continue;
            ArrayList<Exception> arrayList = new ArrayList<Exception>(1);
            arrayList.add(exception);
            DistributedManagementException distributedManagementException = new DistributedManagementException(arrayList);
            throw new MBeanException((Exception)((Object)distributedManagementException));
        }
        throw new MBeanException(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeEdit(Method method) throws MBeanException {
        try {
            boolean bl = true;
            try {
                this.editAccess.saveChanges();
                ActivateTask activateTask = this.editAccess.activateChangesAndWaitForCompletion(180000L);
                bl = false;
                if (activateTask != null && activateTask.getError() != null) {
                    this.undoEdit();
                    this.rethrowException(activateTask.getError(), method);
                }
            }
            finally {
                if (bl) {
                    this.undoEdit();
                }
            }
        }
        catch (EditChangesValidationException editChangesValidationException) {
            this.rethrowException((Exception)((Object)editChangesValidationException), method);
        }
        catch (EditSaveChangesFailedException editSaveChangesFailedException) {
            this.rethrowException((Exception)((Object)editSaveChangesFailedException), method);
        }
        catch (EditFailedException editFailedException) {
            this.rethrowException((Exception)((Object)editFailedException), method);
        }
        catch (EditNotEditorException editNotEditorException) {
            this.rethrowException((Exception)((Object)editNotEditorException), method);
        }
    }

    private void stopEdit() {
        try {
            if (this.editAccess.isEditor()) {
                this.editAccess.stopEdit();
            }
        }
        catch (EditFailedException editFailedException) {
        }
        catch (EditNotEditorException editNotEditorException) {
            // empty catch block
        }
    }

    private void undoEdit() {
        try {
            if (this.editAccess.getEditor() != null && this.editAccess.isPendingChange()) {
                this.editAccess.undoUnactivatedChanges();
            }
        }
        catch (Throwable throwable) {
            ManagementLogger.logErrorUndoCompatibility((Throwable)throwable);
        }
    }

    private boolean isAdminMBean(ObjectName objectName) {
        return objectName.getKeyProperty("Location") == null;
    }

    private void checkForMSConfigModification() throws MBeanException {
        if (!ManagementService.getRuntimeAccess(kernelId).isAdminServer()) {
            ManagementException managementException = new ManagementException("Attempt to modify Managed Server Configuration");
            throw new MBeanException((Exception)((Object)managementException));
        }
    }
}

