/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.compatibility.internal;

import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanParameterInfo;
import weblogic.management.mbeanservers.compatibility.internal.TypesHelper;

public class Helper {
    public static Class[] getInterfaces(Class clazz) {
        ArrayList arrayList = new ArrayList();
        Helper.addInterfacesRecusively(clazz, arrayList);
        Class[] classArray = new Class[arrayList.size()];
        return arrayList.toArray(classArray);
    }

    public static boolean isAssignableFrom(Object[] objectArray, MBeanParameterInfo[] mBeanParameterInfoArray) throws ClassNotFoundException {
        int n;
        if (objectArray == null) {
            return mBeanParameterInfoArray.length == 0;
        }
        if (objectArray.length != mBeanParameterInfoArray.length) {
            return false;
        }
        Class[] classArray = new Class[objectArray.length];
        Class[] classArray2 = new Class[mBeanParameterInfoArray.length];
        for (n = 0; n < objectArray.length; ++n) {
            classArray[n] = objectArray[n] == null ? null : objectArray[n].getClass();
        }
        for (n = 0; n < objectArray.length; ++n) {
            String string = mBeanParameterInfoArray[n].getType();
            classArray2[n] = string == null ? Void.class : TypesHelper.wrapClass(TypesHelper.findClass(string));
        }
        for (n = 0; n < classArray.length; ++n) {
            if (classArray[n] == null || classArray2[n].isAssignableFrom(classArray[n])) continue;
            return false;
        }
        return true;
    }

    private static void addInterfacesRecusively(Class clazz, List list) {
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (!list.contains(classArray[i])) {
                list.add(classArray[i]);
            }
            Helper.addInterfacesRecusively(classArray[i], list);
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            Helper.addInterfacesRecusively(clazz2, list);
        }
    }
}

