/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.compatibility.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.Descriptor;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanInfo;
import weblogic.management.MBeanCreationException;
import weblogic.management.MBeanHome;
import weblogic.management.ManagementLogger;
import weblogic.management.RemoteMBeanServer;
import weblogic.management.WebLogicMBean;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.mbeanservers.compatibility.internal.MBeanProxy;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.beaninfo.BeanInfoAccess;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class MBeanHomeImpl
implements MBeanHome {
    Map proxyCache;
    RemoteMBeanServer mbeanServer;
    BeanInfoAccess beanInfoAccess;
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public MBeanHomeImpl(RemoteMBeanServer remoteMBeanServer) {
        this.mbeanServer = remoteMBeanServer;
        this.proxyCache = Collections.synchronizedMap(new HashMap(256));
        this.beanInfoAccess = ManagementService.getBeanInfoAccess();
    }

    public RemoteMBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public DomainMBean getActiveDomain() {
        try {
            return (DomainMBean)this.getMBean(this.getDomainName(), "DomainConfig");
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new Error(instanceNotFoundException);
        }
    }

    public Object getProxy(ObjectName objectName) throws InstanceNotFoundException {
        return this.getProxy(objectName, false);
    }

    private Object getProxy(ObjectName objectName, boolean bl) throws InstanceNotFoundException {
        if (!this.mbeanServer.isRegistered(objectName)) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        Object v = this.proxyCache.get(objectName);
        if (v != null) {
            return v;
        }
        Class[] classArray = new Class[]{this.getInterface(objectName, bl)};
        Object object = Proxy.newProxyInstance(classArray[0].getClassLoader(), classArray, (InvocationHandler)new MBeanProxy(objectName, this));
        this.proxyCache.put(objectName, object);
        return object;
    }

    public WebLogicMBean getMBean(ObjectName objectName) throws InstanceNotFoundException {
        Object object = this.getProxy(objectName, true);
        if (!(object instanceof WebLogicMBean)) {
            String string = "";
            try {
                if (object != null) {
                    Class<?> clazz = object.getClass();
                    string = "mbean class = " + clazz;
                    string = string + " superclass = " + clazz.getSuperclass();
                    Class<?>[] classArray = object.getClass().getInterfaces();
                    for (int i = 0; classArray != null && i < classArray.length; ++i) {
                        string = string + " intf[" + i + "] = " + classArray[i];
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AssertionError((Object)("The MBean represented by " + objectName + " is not a WebLogicMBean. The MBean info is " + string));
        }
        return (WebLogicMBean)object;
    }

    private Class getInterface(ObjectName objectName, boolean bl) {
        block11: {
            Object object;
            MBeanInfo mBeanInfo;
            try {
                mBeanInfo = this.mbeanServer.getMBeanInfo(objectName);
            }
            catch (Exception exception) {
                throw new AssertionError((Object)exception);
            }
            String string = mBeanInfo.getClassName();
            if (!ObjectName.class.getName().equals(string)) {
                try {
                    object = this.classForName(string);
                    if (((Class)object).isInterface()) {
                        return object;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (mBeanInfo instanceof ModelMBeanInfo) {
                object = null;
                Descriptor descriptor = null;
                ModelMBeanInfo modelMBeanInfo = null;
                try {
                    modelMBeanInfo = (ModelMBeanInfo)((Object)mBeanInfo);
                    descriptor = modelMBeanInfo.getMBeanDescriptor();
                    Object object2 = descriptor.getFieldValue("interfaceclassname");
                    if (object2 == null) {
                        object2 = descriptor.getFieldValue("com.bea.interfaceclassname");
                    }
                    if (object2 != null) {
                        object = object2.toString();
                    }
                    return this.classForName((String)object);
                }
                catch (Exception exception) {
                    if (!bl) break block11;
                    String string2 = "Error occurred while getting interfaceClassName. Model info = " + modelMBeanInfo + " desc = " + descriptor + " InterfaceClassName = " + (String)object;
                    RuntimeException runtimeException = new RuntimeException(string2);
                    ManagementLogger.logExceptionInMBeanProxy((Throwable)runtimeException);
                    ManagementLogger.logExceptionGettingClassForInterface((String)object, (Exception)exception);
                }
            }
        }
        return DynamicMBean.class;
    }

    private Class classForName(String string) throws ClassNotFoundException {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return this.beanInfoAccess.getClassForName(string);
        }
    }

    private WebLogicMBean queryMBean(String string) throws InstanceNotFoundException {
        try {
            ObjectName objectName = new ObjectName(string);
            Set<ObjectName> set = this.mbeanServer.queryNames(objectName, null);
            if (set.size() > 1) {
                throw new IllegalArgumentException("Query had multiple results " + string);
            }
            Iterator<ObjectName> iterator = set.iterator();
            if (!iterator.hasNext()) {
                throw new InstanceNotFoundException(string);
            }
            ObjectName objectName2 = iterator.next();
            return this.getMBean(objectName2);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new IllegalArgumentException(string);
        }
    }

    public WebLogicMBean getMBean(String string, String string2) throws InstanceNotFoundException {
        return this.getMBean(string, string2, this.getDomainName());
    }

    public WebLogicMBean getMBean(String string, String string2, String string3) throws InstanceNotFoundException {
        String string4 = string3 + ":Name=" + string + ",Type=" + string2 + ",*";
        return this.queryMBean(string4);
    }

    public WebLogicMBean getMBean(String string, String string2, String string3, String string4) throws InstanceNotFoundException {
        String string5 = string3 + ":Name=" + string + ",Type=" + string2 + ",Location=" + string4 + ",*";
        return this.queryMBean(string5);
    }

    public Set getMBeansByType(String string) {
        String string2 = "*:Type=" + string + ",*";
        HashSet<WebLogicMBean> hashSet = new HashSet<WebLogicMBean>();
        try {
            ObjectName objectName = new ObjectName(string2);
            Set<ObjectName> set = this.mbeanServer.queryNames(objectName, null);
            Iterator<ObjectName> iterator = set.iterator();
            while (iterator.hasNext()) {
                hashSet.add(this.getMBean(iterator.next()));
            }
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
        return hashSet;
    }

    public WebLogicMBean getMBean(String string, Class clazz) throws InstanceNotFoundException {
        if (string == null) {
            throw new NullPointerException("null name");
        }
        Set set = this.getAllMBeans(this.getDomainName());
        for (WebLogicMBean webLogicMBean : set) {
            if (!string.equals(webLogicMBean.getName()) || !clazz.isInstance(webLogicMBean)) continue;
            return webLogicMBean;
        }
        throw new InstanceNotFoundException(string + ", class: " + clazz.getName() + " (" + ManagementService.getRuntimeAccess(kernelId).isAdminServer() + ")");
    }

    public Set getAllMBeans(String string) {
        Set<ObjectName> set;
        try {
            set = this.mbeanServer.queryNames(new ObjectName(string + ":*"), null);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new Error(malformedObjectNameException);
        }
        HashSet<Object> hashSet = new HashSet<Object>(set.size());
        for (ObjectName objectName : set) {
            try {
                Object object = this.getProxy(objectName);
                if (!(object instanceof WebLogicMBean)) continue;
                hashSet.add(object);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {}
        }
        return hashSet;
    }

    public Set getAllMBeans() {
        return this.getAllMBeans("*");
    }

    public ConfigurationMBean getConfigurationMBean(String string, String string2) throws InstanceNotFoundException {
        return (ConfigurationMBean)this.getMBean(string, string2);
    }

    public RuntimeMBean getRuntimeMBean(String string, String string2) throws InstanceNotFoundException {
        return (RuntimeMBean)this.getMBean(string, string2);
    }

    public String toString() {
        return "MBeanHomeImpl for server " + this.getServerName();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof MBeanHome) {
            MBeanHome mBeanHome = (MBeanHome)object;
            return this.mbeanServer.equals(mBeanHome.getMBeanServer());
        }
        return false;
    }

    public ConfigurationMBean getAdminMBean(String string, String string2) throws InstanceNotFoundException {
        try {
            String string3 = this.getDomainName() + ":" + "Name=" + string + "," + "Type=" + string2;
            ObjectName objectName = new ObjectName(string3);
            return (ConfigurationMBean)this.getMBean(objectName);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new Error(malformedObjectNameException);
        }
    }

    public ConfigurationMBean getAdminMBean(String string, String string2, String string3) throws InstanceNotFoundException {
        try {
            String string4 = string3 + ":" + "Name=" + string + "," + "Type=" + string2;
            ObjectName objectName = new ObjectName(string4);
            return (ConfigurationMBean)this.getMBean(objectName);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new Error(malformedObjectNameException);
        }
    }

    public WebLogicMBean createAdminMBean(String string, String string2) throws MBeanCreationException {
        throw new UnsupportedOperationException("Only supported on the Admin MBeanHome");
    }

    public WebLogicMBean createAdminMBean(String string, String string2, String string3) throws MBeanCreationException {
        throw new UnsupportedOperationException("Only supported on the Admin MBeanHome");
    }

    public WebLogicMBean createAdminMBean(String string, String string2, String string3, ConfigurationMBean configurationMBean) throws MBeanCreationException {
        throw new UnsupportedOperationException("Only supported on the Admin MBeanHome");
    }

    public ConfigurationMBean findOrCreateAdminMBean(String string, String string2) throws MBeanCreationException {
        throw new UnsupportedOperationException("Only supported on the Admin MBeanHome");
    }

    public ConfigurationMBean findOrCreateAdminMBean(String string, String string2, String string3) throws MBeanCreationException {
        throw new UnsupportedOperationException("Only supported on the Admin MBeanHome");
    }

    public ConfigurationMBean findOrCreateAdminMBean(String string, String string2, String string3, ConfigurationMBean configurationMBean) throws MBeanCreationException {
        throw new UnsupportedOperationException("Only supported on the Admin MBeanHome");
    }

    public void addManagedHome(MBeanHome mBeanHome, String string, String string2) {
        throw new Error("addManagedHome is supported only on AdminMbeanHome: " + string + "=" + string2);
    }

    public String getDomainName() {
        return ManagementService.getRuntimeAccess(kernelId).getDomainName();
    }

    public String getServerName() {
        return ManagementService.getRuntimeAccess(kernelId).getServerName();
    }

    public void deleteMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        this.mbeanServer.unregisterMBean(objectName);
    }

    public void deleteMBean(WebLogicMBean webLogicMBean) throws InstanceNotFoundException, MBeanRegistrationException {
        this.deleteMBean((ObjectName)webLogicMBean.getObjectName());
    }
}

