/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.compatibility.internal;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeOperationsException;
import weblogic.common.internal.InteropWriteReplaceable;
import weblogic.common.internal.PeerInfo;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.management.AttributeAddNotification;
import weblogic.management.AttributeRemoveNotification;
import weblogic.management.MBeanHome;
import weblogic.management.ManagementException;
import weblogic.management.ManagementLogger;
import weblogic.management.WebLogicMBean;
import weblogic.management.WebLogicObjectName;
import weblogic.management.commo.StandardInterface;
import weblogic.management.configuration.ConfigurationError;
import weblogic.management.configuration.JMSDestinationMBean;
import weblogic.management.configuration.JMSSessionPoolMBean;
import weblogic.management.jmx.ExceptionMapper;
import weblogic.management.jmx.PrimitiveMapper;
import weblogic.management.mbeanservers.compatibility.internal.BaseNotificationListener;
import weblogic.management.mbeanservers.compatibility.internal.OnewayNotificationListenerImpl;
import weblogic.management.mbeanservers.compatibility.internal.RelayNotificationListenerImpl;
import weblogic.management.mbeanservers.compatibility.internal.TypesHelper;
import weblogic.rmi.extensions.RemoteRuntimeException;

public class MBeanProxy
implements InvocationHandler,
Serializable,
InteropWriteReplaceable {
    private static final long serialVersionUID = -3989625551485752570L;
    private final MBeanInfo info;
    protected MBeanHome mbeanHome;
    protected ObjectName objectName;
    protected transient Map listeners;
    private boolean unregistered = false;
    private MBeanServerConnection mbeanServer;

    public MBeanHome getMBeanHome() {
        return this.mbeanHome;
    }

    protected MBeanProxy(ObjectName objectName, MBeanHome mBeanHome) {
        this.mbeanHome = mBeanHome;
        this.objectName = objectName;
        this.mbeanServer = mBeanHome.getMBeanServer();
        try {
            this.info = this.mbeanServer.getMBeanInfo(this.objectName);
        }
        catch (Exception exception) {
            throw new ConfigurationError(exception);
        }
    }

    public final ObjectName getObjectName() {
        return this.objectName;
    }

    public final MBeanInfo getMBeanInfo() {
        return this.info;
    }

    private final boolean isUnregistered() {
        return this.unregistered;
    }

    public final Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        String string = method.getName();
        try {
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke((Object)this, objectArray);
            }
            if (string.equals("isRegistered") && (null == objectArray || objectArray.length == 0) && method.getReturnType().equals(Boolean.TYPE)) {
                return this.isUnregistered() ? Boolean.FALSE : Boolean.TRUE;
            }
            if (string.equals("toString") && (null == objectArray || objectArray.length == 0) && method.getReturnType().equals(String.class)) {
                return "(MBeanProxy:" + this.objectName.getCanonicalName() + ")";
            }
            if (string.equals("getMBeanInfo")) {
                return this.info;
            }
            if (string.equals("getObjectName")) {
                WebLogicObjectName webLogicObjectName = null;
                try {
                    webLogicObjectName = new WebLogicObjectName(this.objectName);
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    ManagementLogger.logExceptionCreatingObjectName((Throwable)malformedObjectNameException);
                }
                return webLogicObjectName;
            }
            if (method.getName().equals("wls_getObjectName")) {
                return this.getObjectName();
            }
            if ((string.startsWith("get") || string.startsWith("is")) && (objectArray == null || objectArray.length == 0)) {
                return this.getAttribute(method);
            }
            if (string.equals("setAttributes") && method.getDeclaringClass() == DynamicMBean.class) {
                return this.setAttributes(objectArray[0]);
            }
            if (string.equals("setAttribute") && method.getDeclaringClass() == DynamicMBean.class) {
                return this.setOneAttribute(objectArray[0]);
            }
            if (string.equals("getAttributes") && method.getDeclaringClass() == DynamicMBean.class) {
                return this.getAttributes(objectArray[0]);
            }
            if (string.equals("getAttribute") && method.getDeclaringClass() == DynamicMBean.class) {
                return this.getOneAttribute(objectArray[0]);
            }
            if (string.startsWith("set") && objectArray != null && objectArray.length == 1) {
                this.setAttribute(string, objectArray[0]);
                return null;
            }
            if (string.equals("addNotificationListener")) {
                this.addNotificationListener((NotificationListener)objectArray[0], (NotificationFilter)objectArray[1], objectArray[2]);
                return null;
            }
            if (string.equals("removeNotificationListener")) {
                this.removeNotificationListener((NotificationListener)objectArray[0]);
                return null;
            }
            if (string.equals("invoke") && method.getDeclaringClass() == DynamicMBean.class) {
                return this.dynamicInvoke(method.getReturnType(), objectArray);
            }
            return this.invoke(method, objectArray);
        }
        catch (Throwable throwable) {
            throw ExceptionMapper.matchJMXException((Method)method, (Throwable)throwable);
        }
    }

    private final void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        BaseNotificationListener baseNotificationListener;
        if (this.listeners == null) {
            this.listeners = new HashMap();
        }
        if ((baseNotificationListener = (BaseNotificationListener)this.listeners.get(notificationListener)) == null && null != (baseNotificationListener = this.objectName.getKeyProperty("Type").equals("LogBroadcasterRuntime") ? new OnewayNotificationListenerImpl(this, notificationListener) : new RelayNotificationListenerImpl(this, notificationListener))) {
            this.listeners.put(notificationListener, baseNotificationListener);
        }
        baseNotificationListener.addFilterAndHandback(notificationFilter, object);
    }

    private final void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        if (this.listeners == null) {
            throw new ListenerNotFoundException("listener: " + notificationListener);
        }
        BaseNotificationListener baseNotificationListener = (BaseNotificationListener)this.listeners.get(notificationListener);
        if (baseNotificationListener == null) {
            throw new ListenerNotFoundException("listener: " + notificationListener);
        }
        baseNotificationListener.remove();
        this.listeners.remove(notificationListener);
    }

    public final void sendNotification(NotificationListener notificationListener, Notification notification, Object object) {
        if (this.isUnregistered()) {
            return;
        }
        Notification notification2 = null;
        try {
            notification2 = this.wrapNotification(notification);
        }
        catch (ManagementException managementException) {
            ManagementLogger.logSendNotificationFailed((Throwable)managementException);
            return;
        }
        notificationListener.handleNotification(notification2, object);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof Proxy) {
            Proxy proxy = (Proxy)object;
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(proxy);
            if (invocationHandler instanceof MBeanProxy) {
                MBeanProxy mBeanProxy = (MBeanProxy)invocationHandler;
                return this.equalsMBeanProxy(mBeanProxy);
            }
        } else if (object instanceof MBeanProxy) {
            MBeanProxy mBeanProxy = (MBeanProxy)object;
            return this.equalsMBeanProxy(mBeanProxy);
        }
        return false;
    }

    public String toString() {
        return "Proxy for " + this.objectName;
    }

    void unregister() {
        if (this.isUnregistered()) {
            return;
        }
        this.unregistered = true;
        if (this.listeners != null) {
            Iterator iterator = new HashSet(this.listeners.keySet()).iterator();
            while (iterator.hasNext()) {
                try {
                    this.removeNotificationListener((NotificationListener)iterator.next());
                }
                catch (ListenerNotFoundException listenerNotFoundException) {}
            }
        }
        this.mbeanHome = null;
    }

    public Object interopWriteReplace(PeerInfo peerInfo) throws IOException {
        ObjectName objectName = this.objectName;
        if (peerInfo.compareTo((Object)PeerInfo.VERSION_DIABLO) < 0) {
            if (!(this.objectName instanceof WebLogicObjectName)) {
                try {
                    objectName = new WebLogicObjectName(this.objectName);
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    throw new Error(malformedObjectNameException);
                }
            }
            weblogic.management.internal.MBeanProxy mBeanProxy = new weblogic.management.internal.MBeanProxy(objectName, this.mbeanHome);
            return mBeanProxy;
        }
        return this;
    }

    private MBeanAttributeInfo getAttributeInfo(String string) throws AttributeNotFoundException {
        if (this.info != null) {
            MBeanAttributeInfo[] mBeanAttributeInfoArray = this.info.getAttributes();
            for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
                if (!mBeanAttributeInfoArray[i].getName().equals(string)) continue;
                return mBeanAttributeInfoArray[i];
            }
        }
        throw new AttributeNotFoundException(string);
    }

    private Object getAttribute(Method method) throws AttributeNotFoundException, InstanceNotFoundException, ReflectionException, MBeanException {
        if (this.mbeanHome == null) {
            throw new InstanceNotFoundException(this.objectName.toString());
        }
        String string = method.getName();
        String string2 = null;
        string2 = string.charAt(0) == 'g' ? string.substring(3) : string.substring(2);
        MBeanServerConnection mBeanServerConnection = this.mbeanServer;
        Object object = null;
        try {
            object = mBeanServerConnection.getAttribute(this.objectName, string2);
        }
        catch (IOException iOException) {
            throw new MBeanException(iOException);
        }
        catch (RemoteRuntimeException remoteRuntimeException) {
            throw new RuntimeOperationsException((RuntimeException)((Object)remoteRuntimeException));
        }
        return this.wrap(method.getReturnType(), object);
    }

    private Object getOneAttribute(Object object) throws AttributeNotFoundException, InstanceNotFoundException, ReflectionException, MBeanException, IOException {
        return this.mbeanServer.getAttribute(this.objectName, (String)object);
    }

    private Object getAttributes(Object object) throws InstanceNotFoundException, ReflectionException, IOException {
        return this.mbeanServer.getAttributes(this.objectName, (String[])object);
    }

    private final Object setAttribute(String string, Object object) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        String string2 = string.substring(3);
        Attribute attribute = new Attribute(string2, this.unwrap(object));
        try {
            this.mbeanServer.setAttribute(this.objectName, attribute);
            this.updateObjectNameForSetParent(attribute);
        }
        catch (RuntimeErrorException runtimeErrorException) {
            ManagementLogger.logMBeanProxySetAttributeError((ObjectName)this.objectName, (String)string, (Object)object, null, (Throwable)runtimeErrorException.getTargetError());
            throw runtimeErrorException;
        }
        catch (RuntimeOperationsException runtimeOperationsException) {
            throw new MBeanException(runtimeOperationsException);
        }
        return null;
    }

    private final Object setOneAttribute(Object object) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        Attribute attribute = (Attribute)object;
        Attribute attribute2 = this.unwrap(attribute);
        this.mbeanServer.setAttribute(this.objectName, attribute2);
        this.updateObjectNameForSetParent(attribute2);
        return null;
    }

    private static WebLogicObjectName asWebLogicObjectName(ObjectName objectName) {
        if (objectName instanceof WebLogicObjectName) {
            return (WebLogicObjectName)objectName;
        }
        try {
            return new WebLogicObjectName(objectName);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new AssertionError((Object)malformedObjectNameException);
        }
    }

    private final void updateObjectNameForSetParent(Attribute attribute) {
        if (attribute.getName().equals("Parent")) {
            try {
                this.objectName = new WebLogicObjectName(MBeanProxy.asWebLogicObjectName(this.objectName), MBeanProxy.asWebLogicObjectName((ObjectName)attribute.getValue()));
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                throw new AssertionError((Object)malformedObjectNameException);
            }
        }
    }

    private MBeanProxy getProxy(WebLogicMBean webLogicMBean) {
        return (MBeanProxy)Proxy.getInvocationHandler(webLogicMBean);
    }

    private final void updateObjectNameForAddRemove(String string, Object[] objectArray) {
        if (objectArray == null || objectArray.length != 1) {
            return;
        }
        Object object = objectArray[0];
        if (!(object instanceof JMSSessionPoolMBean) && !(object instanceof JMSDestinationMBean)) {
            return;
        }
        WebLogicMBean webLogicMBean = (WebLogicMBean)objectArray[0];
        if (string.equals("addSessionPool") || string.equals("addDestination")) {
            try {
                MBeanProxy mBeanProxy = this.getProxy(webLogicMBean);
                WebLogicObjectName webLogicObjectName = new WebLogicObjectName(MBeanProxy.asWebLogicObjectName(mBeanProxy.getObjectName()), MBeanProxy.asWebLogicObjectName(this.objectName));
                mBeanProxy.setObjectName((ObjectName)webLogicObjectName);
                return;
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                throw new AssertionError((Object)malformedObjectNameException);
            }
        }
        if (string.equals("removeSessionPool") || string.equals("removeDestination")) {
            try {
                MBeanProxy mBeanProxy = this.getProxy(webLogicMBean);
                WebLogicObjectName webLogicObjectName = new WebLogicObjectName(MBeanProxy.asWebLogicObjectName(mBeanProxy.getObjectName()), MBeanProxy.asWebLogicObjectName(this.objectName).getParent());
                mBeanProxy.setObjectName((ObjectName)webLogicObjectName);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                throw new AssertionError((Object)malformedObjectNameException);
            }
        }
    }

    void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    private Object invoke(Method method, Object[] objectArray) throws InstanceNotFoundException, MBeanException, ReflectionException, OperationsException, IOException {
        String string = method.getName();
        Object[] objectArray2 = this.unwrap(objectArray);
        if (objectArray2 == null) {
            objectArray2 = new Object[]{};
        }
        Class<?>[] classArray = method.getParameterTypes();
        String[] stringArray = new String[objectArray2.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.getMappedType(classArray[i]);
        }
        Object object = this.mbeanServer.invoke(this.objectName, string, objectArray2, stringArray);
        Object object2 = this.wrap(method.getReturnType(), object);
        this.updateObjectNameForAddRemove(string, objectArray);
        return object2;
    }

    private String getMappedType(Class clazz) {
        if (WebLogicMBean.class.isAssignableFrom(clazz) || StandardInterface.class.isAssignableFrom(clazz)) {
            return ObjectName.class.getName();
        }
        String string = PrimitiveMapper.lookupWrapperClassName((Class)clazz);
        if (string != null) {
            return string;
        }
        return clazz.getName();
    }

    private Object dynamicInvoke(Class clazz, Object[] objectArray) throws InstanceNotFoundException, MBeanException, ReflectionException, OperationsException, IOException {
        try {
            Object[] objectArray2 = this.unwrap((Object[])objectArray[1]);
            Object object = this.mbeanServer.invoke(this.objectName, (String)objectArray[0], objectArray2, (String[])objectArray[2]);
            return this.wrap(clazz, object);
        }
        catch (RuntimeErrorException runtimeErrorException) {
            throw runtimeErrorException.getTargetError();
        }
    }

    private Object wrap(Class clazz, Object object) {
        if (object == null) {
            return null;
        }
        if (clazz == Void.class) {
            return null;
        }
        if (clazz.isAssignableFrom(object.getClass())) {
            return object;
        }
        try {
            if (object instanceof ObjectName) {
                Object object2 = this.mbeanHome.getProxy((ObjectName)object);
                return object2;
            }
            if (object instanceof ObjectName[]) {
                Class<?> clazz2 = clazz.getComponentType();
                Object[] objectArray = (Object[])object;
                int n = objectArray.length;
                Object[] objectArray2 = (Object[])Array.newInstance(clazz2, n);
                int n2 = 0;
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object3 = this.wrap(clazz2, objectArray[i]);
                    if (object3 == null) continue;
                    objectArray2[n2++] = object3;
                }
                if (n2 < n) {
                    Object[] objectArray3 = (Object[])Array.newInstance(clazz2, n2);
                    System.arraycopy(objectArray2, 0, objectArray3, 0, n2);
                    objectArray2 = objectArray3;
                }
                return objectArray2;
            }
            return object;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            object = null;
            return object;
        }
    }

    private Object wrap(String string, Object object) throws ManagementException {
        if (object == null) {
            return null;
        }
        try {
            if (string.equals("ObjectName")) {
                return object;
            }
            MBeanAttributeInfo mBeanAttributeInfo = this.getAttributeInfo(string);
            Class clazz = TypesHelper.findClass(mBeanAttributeInfo.getType());
            return this.wrap(clazz, object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ManagementException("error wrapping " + string + ", value=" + object, (Throwable)classNotFoundException);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw new ManagementException("error wrapping " + string + ", value=" + object, (Throwable)attributeNotFoundException);
        }
    }

    private final Object setAttributes(Object object) throws InstanceNotFoundException, ReflectionException, IOException {
        AttributeList attributeList = this.unwrap((AttributeList)object);
        return this.mbeanServer.setAttributes(this.objectName, attributeList);
    }

    private final boolean equalsMBeanProxy(MBeanProxy mBeanProxy) {
        if (mBeanProxy.mbeanHome == null && this.mbeanHome == null) {
            return mBeanProxy.objectName.equals(this.objectName);
        }
        if (mBeanProxy.mbeanHome.equals(this.mbeanHome)) {
            return mBeanProxy.objectName.equals(this.objectName);
        }
        return false;
    }

    private AttributeList unwrap(AttributeList attributeList) {
        if (attributeList == null) {
            return null;
        }
        AttributeList attributeList2 = new AttributeList();
        Iterator iterator = attributeList.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = this.unwrap((Attribute)iterator.next());
            if (null == attribute) continue;
            attributeList2.add(attribute);
        }
        return attributeList2;
    }

    private Attribute unwrap(Attribute attribute) {
        if (null == attribute) {
            return null;
        }
        String string = attribute.getName();
        Object object = this.unwrap(attribute.getValue());
        if (null == string) {
            return null;
        }
        return new Attribute(string, object);
    }

    private Object[] unwrap(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        if (objectArray.length == 0) {
            return objectArray;
        }
        Object object = this.unwrap(objectArray[0]);
        if (object instanceof ObjectName) {
            Object[] objectArray2 = new ObjectName[objectArray.length];
            objectArray2[0] = (ObjectName)object;
            for (int i = 1; i < objectArray.length; ++i) {
                objectArray2[i] = (ObjectName)this.unwrap(objectArray[i]);
            }
            return objectArray2;
        }
        return objectArray;
    }

    private Object unwrap(Object object) {
        InvocationHandler invocationHandler;
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            if (clazz.getComponentType().isPrimitive()) {
                return object;
            }
            return this.unwrap((Object[])object);
        }
        if (Proxy.isProxyClass(clazz) && (invocationHandler = Proxy.getInvocationHandler(object)) instanceof MBeanProxy) {
            MBeanProxy mBeanProxy = (MBeanProxy)invocationHandler;
            return mBeanProxy.getObjectName();
        }
        return object;
    }

    private Notification wrapNotification(Notification notification) throws ManagementException {
        String string = null;
        Notification notification2 = notification;
        String string2 = null;
        if (notification instanceof AttributeAddNotification) {
            AttributeAddNotification attributeAddNotification = (AttributeAddNotification)notification;
            string2 = attributeAddNotification.getAttributeName();
            string = attributeAddNotification.getAttributeType();
            Object object = attributeAddNotification.getAddedValue();
            notification2 = new AttributeAddNotification(this.objectName, string2, string, this.wrap(string2, object));
        } else if (notification instanceof AttributeRemoveNotification) {
            AttributeRemoveNotification attributeRemoveNotification = (AttributeRemoveNotification)notification;
            string2 = attributeRemoveNotification.getAttributeName();
            string = attributeRemoveNotification.getAttributeType();
            Object object = attributeRemoveNotification.getRemovedValue();
            notification2 = new AttributeRemoveNotification(this.objectName, string2, string, this.wrap(string2, object));
        } else if (notification instanceof AttributeChangeNotification) {
            AttributeChangeNotification attributeChangeNotification = (AttributeChangeNotification)notification;
            string2 = attributeChangeNotification.getAttributeName();
            string = attributeChangeNotification.getAttributeType();
            if (string2.equals("ObjectName")) {
                return notification;
            }
            Object object = attributeChangeNotification.getOldValue();
            Object object2 = attributeChangeNotification.getNewValue();
            notification2 = new AttributeChangeNotification(this.objectName, 0L, 0L, null, string2, string, this.wrap(string2, object), this.wrap(string2, object2));
        } else {
            notification2 = notification;
        }
        return notification2;
    }

    public Descriptor getDescriptor() {
        return null;
    }

    public DescriptorBean getParentBean() {
        return null;
    }

    public boolean isSet(String string) {
        return false;
    }

    public void unSet(String string) {
    }

    public void addBeanUpdateListener(BeanUpdateListener beanUpdateListener) {
    }

    public void removeBeanUpdateListener(BeanUpdateListener beanUpdateListener) {
    }

    public boolean isEditable() {
        return false;
    }

    public Object clone() {
        return null;
    }

    static class DebugNotificationFilter
    implements NotificationFilter,
    Serializable {
        private static final long serialVersionUID = -277365551078287855L;
        ObjectName name = null;

        DebugNotificationFilter(ObjectName objectName) {
            this.name = objectName;
        }

        public boolean isNotificationEnabled(Notification notification) {
            return true;
        }
    }
}

