/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.compatibility.internal;

import javax.management.MBeanException;
import javax.management.Notification;
import weblogic.management.AttributeAddNotification;
import weblogic.management.AttributeRemoveNotification;
import weblogic.management.jmx.JMXLogger;
import weblogic.management.jmx.modelmbean.NotificationGenerator;
import weblogic.management.jmx.modelmbean.WLSModelMBeanContext;
import weblogic.utils.ArrayUtils;

public class PropertyChangeNotificationTranslator
extends weblogic.management.jmx.modelmbean.PropertyChangeNotificationTranslator {
    public PropertyChangeNotificationTranslator(WLSModelMBeanContext wLSModelMBeanContext, Object object, NotificationGenerator notificationGenerator) {
        super(wLSModelMBeanContext, object, notificationGenerator);
    }

    protected void generateNotification(String string, Class clazz, Object object, Object object2) {
        if (clazz.isArray()) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            ArrayUtils.computeDiff((Object[])objectArray, (Object[])objectArray2, (ArrayUtils.DiffHandler)this.createNewDiffHandler(string, clazz.getName()));
        } else {
            super.generateNotification(string, clazz, object, object2);
        }
    }

    private ArrayUtils.DiffHandler createNewDiffHandler(final String string, final String string2) {
        return new ArrayUtils.DiffHandler(){

            public void addObject(Object object) {
                AttributeAddNotification attributeAddNotification = new AttributeAddNotification(PropertyChangeNotificationTranslator.this.generator.getObjectName(), PropertyChangeNotificationTranslator.this.generator.incrementSequenceNumber(), System.currentTimeMillis(), "add", string, string2, object);
                try {
                    PropertyChangeNotificationTranslator.this.generator.sendNotification((Notification)attributeAddNotification);
                }
                catch (MBeanException mBeanException) {
                    JMXLogger.logErrorGeneratingAttributeChangeNotification((String)PropertyChangeNotificationTranslator.this.generator.getObjectName().toString(), (String)string);
                }
            }

            public void removeObject(Object object) {
                AttributeRemoveNotification attributeRemoveNotification = new AttributeRemoveNotification(PropertyChangeNotificationTranslator.this.generator.getObjectName(), PropertyChangeNotificationTranslator.this.generator.incrementSequenceNumber(), System.currentTimeMillis(), "remove", string, string2, object);
                try {
                    PropertyChangeNotificationTranslator.this.generator.sendNotification((Notification)attributeRemoveNotification);
                }
                catch (MBeanException mBeanException) {
                    JMXLogger.logErrorGeneratingAttributeChangeNotification((String)PropertyChangeNotificationTranslator.this.generator.getObjectName().toString(), (String)string);
                }
            }
        };
    }
}

