/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.compatibility.internal;

import java.io.ObjectInputStream;
import java.rmi.Remote;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;
import weblogic.management.MBeanHome;
import weblogic.management.RemoteMBeanServer;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.rmi.extensions.DisconnectEvent;
import weblogic.rmi.extensions.DisconnectListener;
import weblogic.rmi.extensions.DisconnectMonitor;
import weblogic.rmi.extensions.DisconnectMonitorListImpl;
import weblogic.rmi.extensions.DisconnectMonitorUnavailableException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class RemoteMBeanServerImpl
implements RemoteMBeanServer {
    MBeanHome mbeanHome;
    MBeanServer mbeanServer;
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private Map remoteListeners = Collections.synchronizedMap(new HashMap());

    public RemoteMBeanServerImpl(MBeanServer mBeanServer) {
        this.mbeanServer = mBeanServer;
    }

    public MBeanHome getMBeanHome() {
        return this.mbeanHome;
    }

    void setMBeanHome(MBeanHome mBeanHome) {
        this.mbeanHome = mBeanHome;
    }

    public String getServerName() {
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        if (runtimeAccess == null) {
            return null;
        }
        return runtimeAccess.getServerName();
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.mbeanServer.getMBeanInfo(objectName);
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException {
        return this.mbeanServer.getAttributes(objectName, stringArray);
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        return this.mbeanServer.getObjectInstance(objectName);
    }

    public boolean isRegistered(ObjectName objectName) {
        return this.mbeanServer.isRegistered(objectName);
    }

    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        return this.mbeanServer.getAttribute(objectName, string);
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.mbeanServer.setAttribute(objectName, attribute);
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        return this.mbeanServer.setAttributes(objectName, attributeList);
    }

    public ObjectInstance registerMBean(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return this.mbeanServer.registerMBean(object, objectName);
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        this.mbeanServer.unregisterMBean(objectName);
    }

    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        if (notificationListener instanceof Remote) {
            notificationListener = this.cacheRemoteStub(notificationListener);
        }
        this.mbeanServer.addNotificationListener(objectName, notificationListener, notificationFilter, object);
    }

    public void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        this.mbeanServer.addNotificationListener(objectName, objectName2, notificationFilter, object);
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        if (notificationListener != null) {
            if (notificationListener instanceof Remote) {
                notificationListener = this.getRemoteCachedStub(notificationListener);
            }
            this.mbeanServer.removeNotificationListener(objectName, notificationListener);
        }
    }

    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.mbeanServer.createMBean(string, objectName);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.mbeanServer.createMBean(string, objectName, objectName2);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.mbeanServer.createMBean(string, objectName, objectArray, stringArray);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.mbeanServer.createMBean(string, objectName, objectName2, objectArray, stringArray);
    }

    public Set queryMBeans(ObjectName objectName, QueryExp queryExp) {
        return this.mbeanServer.queryMBeans(objectName, queryExp);
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp) {
        return this.mbeanServer.queryNames(objectName, queryExp);
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return this.mbeanServer.invoke(objectName, string, objectArray, stringArray);
    }

    public Integer getMBeanCount() {
        return this.mbeanServer.getMBeanCount();
    }

    public String getDefaultDomain() {
        return this.mbeanServer.getDefaultDomain();
    }

    public String[] getDomains() {
        return this.mbeanServer.getDomains();
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbeanServer.removeNotificationListener(objectName, objectName2);
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbeanServer.removeNotificationListener(objectName, objectName2, notificationFilter, object);
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        if (notificationListener instanceof Remote && (notificationListener = this.getRemoteCachedStub(notificationListener)) == null) {
            return;
        }
        this.mbeanServer.removeNotificationListener(objectName, notificationListener, notificationFilter, object);
    }

    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException {
        return this.mbeanServer.isInstanceOf(objectName, string);
    }

    public Object instantiate(String string) throws ReflectionException, MBeanException {
        return this.mbeanServer.instantiate(string);
    }

    public Object instantiate(String string, ObjectName objectName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.mbeanServer.instantiate(string, objectName);
    }

    public Object instantiate(String string, Object[] objectArray, String[] stringArray) throws ReflectionException, MBeanException {
        return this.mbeanServer.instantiate(string, objectArray, stringArray);
    }

    public Object instantiate(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.mbeanServer.instantiate(string, objectName, objectArray, stringArray);
    }

    public ObjectInputStream deserialize(ObjectName objectName, byte[] byArray) throws InstanceNotFoundException, OperationsException {
        return this.mbeanServer.deserialize(objectName, byArray);
    }

    public ObjectInputStream deserialize(String string, byte[] byArray) throws OperationsException, ReflectionException {
        return this.mbeanServer.deserialize(string, byArray);
    }

    public ObjectInputStream deserialize(String string, ObjectName objectName, byte[] byArray) throws InstanceNotFoundException, OperationsException, ReflectionException {
        return this.mbeanServer.deserialize(string, objectName, byArray);
    }

    public ClassLoader getClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException {
        return this.mbeanServer.getClassLoaderFor(objectName);
    }

    public ClassLoader getClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        return this.mbeanServer.getClassLoader(objectName);
    }

    public ClassLoaderRepository getClassLoaderRepository() {
        return this.mbeanServer.getClassLoaderRepository();
    }

    private NotificationListener cacheRemoteStub(NotificationListener notificationListener) {
        Object object2;
        for (Object object2 : this.remoteListeners.keySet()) {
            if (!object2.equals(notificationListener)) continue;
            return object2;
        }
        object2 = new StubCleaner(notificationListener);
        this.remoteListeners.put(notificationListener, object2);
        return notificationListener;
    }

    private NotificationListener getRemoteCachedStub(NotificationListener notificationListener) {
        if (this.remoteListeners.isEmpty()) {
            return notificationListener;
        }
        for (NotificationListener notificationListener2 : this.remoteListeners.keySet()) {
            if (!notificationListener2.equals(notificationListener)) continue;
            return notificationListener2;
        }
        return null;
    }

    private Map getRemoteCachedStubs() {
        return this.remoteListeners;
    }

    private class StubCleaner
    implements DisconnectListener {
        private final Remote remoteListener;
        private final DisconnectMonitor monitor = DisconnectMonitorListImpl.getDisconnectMonitor();

        public StubCleaner(NotificationListener notificationListener) {
            if (!(notificationListener instanceof Remote)) {
                throw new AssertionError((Object)"Impossible exception");
            }
            this.remoteListener = (Remote)((Object)notificationListener);
            try {
                this.monitor.addDisconnectListener(this.remoteListener, (DisconnectListener)this);
            }
            catch (DisconnectMonitorUnavailableException disconnectMonitorUnavailableException) {
                // empty catch block
            }
        }

        public void onDisconnect(DisconnectEvent disconnectEvent) {
            RemoteMBeanServerImpl.this.getRemoteCachedStubs().remove(this.remoteListener);
        }
    }
}

