/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.compatibility.internal;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.jmx.mbeanserver.WLSMBeanServerInterceptorBase;

public class ReparentingInterceptor
extends WLSMBeanServerInterceptorBase {
    private static DebugLogger debug = DebugLogger.getDebugLogger((String)"CompatabilityMBeanServer");
    private static final String[] CREATOR_SIGNATURE = new String[]{"java.lang.String", "javax.management.ObjectName"};
    private static final String[] DESTROYER_SIGNATURE = new String[]{"javax.management.ObjectName"};
    private static Set BEAN_TYPE = new HashSet<String>(Arrays.asList("ForeignJMSServer", "JMSSessionPool"));
    private static Set ADDERS = new HashSet<String>(Arrays.asList("addConnectionFactory", "addDestination", "addConnectionConsumer"));
    private static Set REMOVERS = new HashSet<String>(Arrays.asList("removeConnectionFactory", "removeDestination", "removeConnectionConsumer"));

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        if (attribute.getName().equals("Parent")) {
            if (debug.isDebugEnabled()) {
                debug.debug("Reparenting for object " + objectName);
            }
            try {
                String string = objectName.getKeyProperty("Type");
                String string2 = objectName.getKeyProperty("Name");
                String string3 = "create" + string;
                String string4 = "destroy" + string;
                ObjectName objectName2 = (ObjectName)super.getAttribute(objectName, "Parent");
                ObjectName objectName3 = (ObjectName)attribute.getValue();
                super.invoke(objectName3, string3, new Object[]{string2, objectName}, CREATOR_SIGNATURE);
                super.invoke(objectName2, string4, new Object[]{objectName}, DESTROYER_SIGNATURE);
            }
            catch (MBeanException mBeanException) {
                Exception exception = mBeanException.getTargetException();
                if (exception instanceof ConfigurationException) {
                    throw mBeanException;
                }
                ConfigurationException configurationException = new ConfigurationException((Throwable)exception);
                throw new MBeanException((Exception)((Object)configurationException));
            }
            catch (RuntimeMBeanException runtimeMBeanException) {
                RuntimeException runtimeException = runtimeMBeanException.getTargetException();
                if (runtimeException instanceof ConfigurationException) {
                    throw runtimeMBeanException;
                }
                ConfigurationException configurationException = new ConfigurationException((Throwable)runtimeException);
                throw new MBeanException((Exception)((Object)configurationException));
            }
        } else {
            super.setAttribute(objectName, attribute);
        }
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        String string2 = objectName.getKeyProperty("Type");
        if (string2 != null && string2.endsWith("Config")) {
            string2 = string2.substring(0, string2.length() - 6);
        }
        Boolean bl = Boolean.TRUE;
        if (BEAN_TYPE.contains(string2) && objectArray != null & objectArray.length == 1 && objectArray[0] instanceof ObjectName) {
            ObjectName objectName2 = (ObjectName)objectArray[0];
            String string3 = objectName2.getKeyProperty("Type");
            if (string3.endsWith("Config")) {
                string3 = string3.substring(0, string3.length() - 6);
            }
            String string4 = objectName2.getKeyProperty("Name");
            String string5 = "create" + string3;
            String string6 = "destroy" + string3;
            if (ADDERS.contains(string)) {
                try {
                    if (debug.isDebugEnabled()) {
                        debug.debug("Adding for object " + objectName + " method " + string);
                    }
                    super.invoke(objectName, string5, new Object[]{string4, objectName2}, CREATOR_SIGNATURE);
                    ObjectName objectName3 = (ObjectName)super.getAttribute(objectName, "Parent");
                    super.invoke(objectName3, string6, new Object[]{objectName2}, DESTROYER_SIGNATURE);
                }
                catch (AttributeNotFoundException attributeNotFoundException) {
                    throw new Error(attributeNotFoundException);
                }
                return bl;
            }
            if (REMOVERS.contains(string)) {
                if (debug.isDebugEnabled()) {
                    debug.debug("Destroying for object " + objectName + " method " + string);
                }
                super.invoke(objectName, string6, new Object[]{string4, objectName2}, CREATOR_SIGNATURE);
                return bl;
            }
        }
        return super.invoke(objectName, string, objectArray, stringArray);
    }
}

