/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.compatibility.internal;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;

public class TypesHelper {
    private static Map autoNameMap = new HashMap();

    public static synchronized String assignAutoName(String string) {
        Integer n = (Integer)autoNameMap.get(string);
        n = n == null ? new Integer(0) : new Integer(n + 1);
        autoNameMap.put(string, n);
        return string + "-" + n;
    }

    public static Class findClass(String string) throws ClassNotFoundException {
        if (string.equals("long")) {
            return Long.TYPE;
        }
        if (string.equals("double")) {
            return Double.TYPE;
        }
        if (string.equals("float")) {
            return Float.TYPE;
        }
        if (string.equals("int")) {
            return Integer.TYPE;
        }
        if (string.equals("char")) {
            return Character.TYPE;
        }
        if (string.equals("short")) {
            return Short.TYPE;
        }
        if (string.equals("byte")) {
            return Byte.TYPE;
        }
        if (string.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (string.equals("void")) {
            return Void.TYPE;
        }
        if (string.endsWith("[]")) {
            Class clazz = TypesHelper.findClass(string.substring(0, string.length() - 2));
            return Array.newInstance(clazz, 0).getClass();
        }
        return Class.forName(string);
    }

    public static Class wrapClass(Class clazz) {
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        return clazz;
    }
}

