/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.domainruntime.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.OperationsException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMXMBean;
import weblogic.management.jmx.ObjectNameManager;
import weblogic.management.jmx.ObjectSecurityManager;
import weblogic.management.jmx.mbeanserver.WLSMBeanServer;
import weblogic.management.jmx.mbeanserver.WLSMBeanServerBuilder;
import weblogic.management.jmx.mbeanserver.WLSMBeanServerInterceptor;
import weblogic.management.jmx.modelmbean.WLSModelMBeanContext;
import weblogic.management.jmx.modelmbean.WLSModelMBeanFactory;
import weblogic.management.mbeanservers.domainruntime.internal.DomainRuntimeServiceMBeanImpl;
import weblogic.management.mbeanservers.domainruntime.internal.FederatedMBeanServerDelegate;
import weblogic.management.mbeanservers.domainruntime.internal.FederatedMBeanServerInterceptor;
import weblogic.management.mbeanservers.domainruntime.internal.FederatedObjectNameManager;
import weblogic.management.mbeanservers.domainruntime.internal.MBeanServerConnectionManager;
import weblogic.management.mbeanservers.internal.JMXContextInterceptor;
import weblogic.management.mbeanservers.internal.MBeanServerServiceBase;
import weblogic.management.mbeanservers.internal.RuntimeMBeanAgent;
import weblogic.management.mbeanservers.internal.SecurityInterceptor;
import weblogic.management.mbeanservers.internal.SecurityMBeanMgmtOpsInterceptor;
import weblogic.management.mbeanservers.internal.WLSObjectSecurityManagerImpl;
import weblogic.management.provider.DomainAccess;
import weblogic.management.provider.EditAccess;
import weblogic.management.provider.EditFailedException;
import weblogic.management.provider.EditNotEditorException;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.ManagementServiceRestricted;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.DomainRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.server.ServiceFailureException;

public class DomainRuntimeServerService
extends MBeanServerServiceBase {
    private static DebugLogger debug = DebugLogger.getDebugLogger((String)"DebugJMXDomain");
    private MBeanServerConnectionManager connectionManager = null;
    private FederatedObjectNameManager objectNameManager = null;
    private DomainAccess domainAccess;
    private DomainRuntimeMBean domainRuntime;
    WLSModelMBeanContext context = null;
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public String getName() {
        return "DomainRuntimeService";
    }

    public String getVersion() {
        return null;
    }

    public void start() throws ServiceFailureException {
        boolean bl = this.isEnabled();
        if (debug.isDebugEnabled()) {
            debug.debug("DomainRuntimeServerService start: isEnabled(" + bl + ") jndiName(" + "weblogic.management.mbeanservers.domainruntime" + ")");
        }
        if (!bl) {
            return;
        }
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        WLSMBeanServerBuilder wLSMBeanServerBuilder = new WLSMBeanServerBuilder();
        this.connectionManager = new MBeanServerConnectionManager();
        MBeanServerDelegate mBeanServerDelegate = wLSMBeanServerBuilder.newMBeanServerDelegate();
        FederatedMBeanServerDelegate federatedMBeanServerDelegate = new FederatedMBeanServerDelegate(mBeanServerDelegate, this.connectionManager);
        String string = runtimeAccess.getDomainName();
        FederatedMBeanServerInterceptor federatedMBeanServerInterceptor = new FederatedMBeanServerInterceptor(this.connectionManager, string);
        WLSMBeanServer wLSMBeanServer = (WLSMBeanServer)wLSMBeanServerBuilder.newMBeanServer(string, null, (MBeanServerDelegate)federatedMBeanServerDelegate);
        this.objectNameManager = new FederatedObjectNameManager(this.connectionManager, string);
        SecurityInterceptor securityInterceptor = new SecurityInterceptor(wLSMBeanServer, "weblogic.management.mbeanservers.domainruntime");
        wLSMBeanServer.addInterceptor((WLSMBeanServerInterceptor)securityInterceptor);
        SecurityMBeanMgmtOpsInterceptor securityMBeanMgmtOpsInterceptor = new SecurityMBeanMgmtOpsInterceptor(2);
        wLSMBeanServer.addInterceptor((WLSMBeanServerInterceptor)securityMBeanMgmtOpsInterceptor);
        JMXContextInterceptor jMXContextInterceptor = new JMXContextInterceptor(string);
        wLSMBeanServer.addInterceptor((WLSMBeanServerInterceptor)jMXContextInterceptor);
        wLSMBeanServer.addInterceptor((WLSMBeanServerInterceptor)federatedMBeanServerInterceptor);
        this.context = new WLSModelMBeanContext((MBeanServer)wLSMBeanServer, (ObjectNameManager)this.objectNameManager, (ObjectSecurityManager)WLSObjectSecurityManagerImpl.getInstance());
        this.context.setVersion("12.0.0.0");
        this.initialize("weblogic.management.mbeanservers.domainruntime", (MBeanServer)wLSMBeanServer);
        runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        this.domainAccess = ManagementService.getDomainAccess(kernelId);
        this.domainRuntime = this.domainAccess.getDomainRuntime();
        this.domainAccess.setDomainRuntimeService(new DomainRuntimeServiceMBeanImpl(this.connectionManager, this.domainRuntime));
        wLSMBeanServer.setFirstAccessCallback(this.createAccessCallback());
        ManagementService.initializeDomainRuntimeMBeanServer(kernelId, (MBeanServer)wLSMBeanServer);
        if (!debug.isDebugEnabled()) {
            Logger.getLogger("javax.management.remote.misc").setLevel(Level.OFF);
            Logger.getLogger("javax.management.remote.rmi").setLevel(Level.OFF);
        }
        super.start();
        if (debug.isDebugEnabled()) {
            debug.debug("DomainRuntimeService start: completed - weblogic.management.mbeanservers.domainruntime");
        }
    }

    private void registerAllMBeans() {
        if (debug.isDebugEnabled()) {
            debug.debug("DomainRuntimeServerService.registerAllMBeans - starting ");
        }
        try {
            WLSModelMBeanContext wLSModelMBeanContext = new WLSModelMBeanContext(this.getMBeanServer(), (ObjectNameManager)this.objectNameManager, (ObjectSecurityManager)WLSObjectSecurityManagerImpl.getInstance());
            wLSModelMBeanContext.setRecurse(false);
            wLSModelMBeanContext.setVersion("12.0.0.0");
            wLSModelMBeanContext.setReadOnly(false);
            new RuntimeMBeanAgent(wLSModelMBeanContext, this.domainAccess);
            this.registerTypeService(this.context);
            WLSModelMBeanContext wLSModelMBeanContext2 = new WLSModelMBeanContext(this.getMBeanServer(), (ObjectNameManager)this.objectNameManager, (ObjectSecurityManager)WLSObjectSecurityManagerImpl.getInstance());
            wLSModelMBeanContext2.setRecurse(true);
            wLSModelMBeanContext2.setVersion("12.0.0.0");
            wLSModelMBeanContext2.setReadOnly(true);
            WLSModelMBeanFactory.registerWLSModelMBean((Object)SINGLETON.getInstance().getDomainConfig(), (WLSModelMBeanContext)wLSModelMBeanContext2);
            WLSModelMBeanContext wLSModelMBeanContext3 = new WLSModelMBeanContext(this.getMBeanServer(), (ObjectNameManager)this.objectNameManager, (ObjectSecurityManager)WLSObjectSecurityManagerImpl.getInstance());
            wLSModelMBeanContext3.setRecurse(true);
            wLSModelMBeanContext3.setVersion("12.0.0.0");
            wLSModelMBeanContext3.setReadOnly(true);
            wLSModelMBeanContext3.setFilteringEnabled(true);
            WLSModelMBeanFactory.registerWLSModelMBean((Object)SINGLETON.getInstance().getDomainEdit(), (WLSModelMBeanContext)wLSModelMBeanContext3);
            this.connectionManager.initializeConnectivity();
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
        }
        catch (OperationsException operationsException) {
            throw new Error("Unable to register Federated Domain Runtime Access ", operationsException);
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw new Error("Unable to register Federated Domain Runtime Access ", mBeanRegistrationException);
        }
        if (debug.isDebugEnabled()) {
            debug.debug("DomainRuntimeServerService.registerAllMBeans - completed ");
        }
    }

    private WLSMBeanServer.FirstAccessCallback createAccessCallback() {
        return new WLSMBeanServer.FirstAccessCallback(){

            public void accessed(MBeanServer mBeanServer) {
                SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)kernelId, (PrivilegedAction)new PrivilegedAction(){

                    public Object run() {
                        DomainRuntimeServerService.this.registerAllMBeans();
                        return null;
                    }
                });
            }
        };
    }

    private boolean isEnabled() {
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        if (!runtimeAccess.isAdminServer()) {
            return false;
        }
        JMXMBean jMXMBean = runtimeAccess.getDomain().getJMX();
        return jMXMBean.isDomainMBeanServerEnabled() || jMXMBean.isManagementEJBEnabled();
    }

    public void stop() throws ServiceFailureException {
        boolean bl = this.isEnabled();
        if (debug.isDebugEnabled()) {
            debug.debug("DomainRuntimeServerService stop: isEnabled(" + bl + ") jndiName(" + "weblogic.management.mbeanservers.domainruntime" + ")");
        }
        if (!bl) {
            return;
        }
        this.connectionManager.stop();
        super.stop();
        if (debug.isDebugEnabled()) {
            debug.debug("DomainRuntimeService stop: completed - weblogic.management.mbeanservers.domainruntime");
        }
    }

    private static class SINGLETON {
        private DomainMBean domainConfig = null;
        private DomainMBean domainEdit = null;
        private static SINGLETON instance = null;

        public static SINGLETON getInstance() {
            if (instance == null) {
                instance = new SINGLETON();
            }
            return instance;
        }

        private SINGLETON() {
            EditAccess editAccess = ManagementServiceRestricted.getEditAccess(kernelId);
            try {
                this.domainConfig = editAccess.getCurrentDomainBean();
                this.domainEdit = editAccess.getDomainBeanWithoutLock();
            }
            catch (EditFailedException editFailedException) {
                throw new AssertionError((Object)editFailedException);
            }
            catch (EditNotEditorException editNotEditorException) {
                throw new AssertionError((Object)editNotEditorException);
            }
        }

        public DomainMBean getDomainConfig() {
            return this.domainConfig;
        }

        public DomainMBean getDomainEdit() {
            return this.domainEdit;
        }
    }
}

