/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeanservers.domainruntime.internal;

import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import weblogic.descriptor.DescriptorBean;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.jmx.MBeanServerInvocationHandler;
import weblogic.management.jmx.RemoteRuntimeException;
import weblogic.management.mbeanservers.Service;
import weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean;
import weblogic.management.mbeanservers.domainruntime.internal.MBeanServerConnectionManager;
import weblogic.management.mbeanservers.internal.DomainServiceImpl;
import weblogic.management.mbeanservers.runtime.RuntimeServiceMBean;
import weblogic.management.provider.DomainAccess;
import weblogic.management.provider.EditAccess;
import weblogic.management.provider.EditFailedException;
import weblogic.management.provider.EditNotEditorException;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.ManagementServiceRestricted;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.DomainRuntimeMBean;
import weblogic.management.runtime.MigratableServiceCoordinatorRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class DomainRuntimeServiceMBeanImpl
extends DomainServiceImpl
implements DomainRuntimeServiceMBean {
    private static DebugLogger debug = DebugLogger.getDebugLogger((String)"DebugJMXDomain");
    private final MBeanServerConnectionManager connectionManager;
    private final String serverName;
    private final DomainRuntimeMBean domainRuntime;
    private static final ObjectName RUNTIME_SERVICE;
    private RuntimeServicesManager runtimeServicesManager;
    private DomainAccess domainAccess = null;
    private static AuthenticatedSubject kernelId;

    DomainRuntimeServiceMBeanImpl(MBeanServerConnectionManager mBeanServerConnectionManager, DomainRuntimeMBean domainRuntimeMBean) {
        super("DomainRuntimeService", DomainRuntimeServiceMBean.class.getName(), null);
        this.connectionManager = mBeanServerConnectionManager;
        this.domainRuntime = domainRuntimeMBean;
        this.runtimeServicesManager = new RuntimeServicesManager();
        this.domainAccess = ManagementService.getDomainAccess(kernelId);
        mBeanServerConnectionManager.addCallback(new MBeanServerConnectionManager.MBeanServerConnectionListener(){

            public synchronized void connect(String string, MBeanServerConnection mBeanServerConnection) {
                DomainRuntimeServiceMBeanImpl.this.runtimeServicesManager.addConnection(string, mBeanServerConnection);
            }

            public synchronized void disconnect(String string) {
                DomainRuntimeServiceMBeanImpl.this.runtimeServicesManager.removeConnection(string);
            }
        });
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        this.serverName = runtimeAccess.getServerName();
    }

    public DomainMBean getDomainConfiguration() {
        return SINGLETON.getInstance().getDomainConfig();
    }

    public DomainMBean getDomainPending() {
        return SINGLETON.getInstance().getDomainEdit();
    }

    public ServerMBean findServerConfiguration(String string) {
        RuntimeServiceMBean runtimeServiceMBean = this.getRuntimeServiceMBean(string);
        return runtimeServiceMBean == null ? null : runtimeServiceMBean.getServerConfiguration();
    }

    public DomainMBean findDomainConfiguration(String string) {
        RuntimeServiceMBean runtimeServiceMBean = this.getRuntimeServiceMBean(string);
        return runtimeServiceMBean == null ? null : runtimeServiceMBean.getDomainConfiguration();
    }

    public String getServerName() {
        return this.serverName;
    }

    public DomainRuntimeMBean getDomainRuntime() {
        return this.domainRuntime;
    }

    public RuntimeMBean[] findRuntimes(DescriptorBean descriptorBean) {
        ArrayList arrayList = new ArrayList();
        RuntimeServiceMBean[] runtimeServiceMBeanArray = this.runtimeServicesManager.getRuntimeServices();
        for (int i = 0; i < runtimeServiceMBeanArray.length; ++i) {
            Object e;
            block3: {
                RuntimeServiceMBean runtimeServiceMBean = runtimeServiceMBeanArray[i];
                e = null;
                try {
                    runtimeServiceMBean.findRuntime(descriptorBean);
                }
                catch (RemoteRuntimeException remoteRuntimeException) {
                    if (!debug.isDebugEnabled()) break block3;
                    debug.debug("Exception finding runtimes: ", (Throwable)remoteRuntimeException);
                }
            }
            if (e == null) continue;
            arrayList.add(e);
        }
        return arrayList.toArray(new RuntimeMBean[arrayList.size()]);
    }

    public RuntimeMBean findRuntime(DescriptorBean descriptorBean, String string) {
        RuntimeServiceMBean runtimeServiceMBean = this.getRuntimeServiceMBean(string);
        if (runtimeServiceMBean == null) {
            return null;
        }
        try {
            return runtimeServiceMBean.findRuntime(descriptorBean);
        }
        catch (RemoteRuntimeException remoteRuntimeException) {
            if (debug.isDebugEnabled()) {
                debug.debug("Exception finding runtime for config and server:", (Throwable)remoteRuntimeException);
            }
            return null;
        }
    }

    public DescriptorBean findConfiguration(RuntimeMBean runtimeMBean) {
        MBeanServerInvocationHandler mBeanServerInvocationHandler = (MBeanServerInvocationHandler)Proxy.getInvocationHandler(runtimeMBean);
        String string = this.connectionManager.lookupServerName(mBeanServerInvocationHandler._getConnection());
        if (string == null) {
            return null;
        }
        RuntimeServiceMBean runtimeServiceMBean = this.getRuntimeServiceMBean(string);
        if (runtimeServiceMBean == null) {
            return null;
        }
        try {
            return runtimeServiceMBean.findConfiguration(runtimeMBean);
        }
        catch (RemoteRuntimeException remoteRuntimeException) {
            if (debug.isDebugEnabled()) {
                debug.debug("Exception finding configuration: ", (Throwable)remoteRuntimeException);
            }
            return null;
        }
    }

    public ServerRuntimeMBean[] getServerRuntimes() {
        ArrayList<ServerRuntimeMBean> arrayList = new ArrayList<ServerRuntimeMBean>();
        RuntimeServiceMBean[] runtimeServiceMBeanArray = this.runtimeServicesManager.getRuntimeServices();
        for (int i = 0; i < runtimeServiceMBeanArray.length; ++i) {
            RuntimeServiceMBean runtimeServiceMBean = runtimeServiceMBeanArray[i];
            try {
                ServerRuntimeMBean serverRuntimeMBean = runtimeServiceMBean.getServerRuntime();
                if (serverRuntimeMBean == null) continue;
                arrayList.add(serverRuntimeMBean);
                continue;
            }
            catch (RemoteRuntimeException remoteRuntimeException) {
                if (!debug.isDebugEnabled()) continue;
                debug.debug("Exception finding server runtimes: ", (Throwable)remoteRuntimeException);
            }
        }
        return arrayList.toArray(new ServerRuntimeMBean[arrayList.size()]);
    }

    public ServerRuntimeMBean lookupServerRuntime(String string) {
        ServerRuntimeMBean serverRuntimeMBean;
        block4: {
            serverRuntimeMBean = null;
            if (string == null) {
                return serverRuntimeMBean;
            }
            RuntimeServiceMBean runtimeServiceMBean = this.runtimeServicesManager.get(string);
            if (runtimeServiceMBean != null) {
                try {
                    serverRuntimeMBean = runtimeServiceMBean.getServerRuntime();
                }
                catch (RemoteRuntimeException remoteRuntimeException) {
                    if (!debug.isDebugEnabled()) break block4;
                    debug.debug("Exception looking up runtime: ", (Throwable)remoteRuntimeException);
                }
            }
        }
        return serverRuntimeMBean;
    }

    public Service findService(String string, String string2, String string3) {
        if (string3 == null) {
            return (Service)this.domainAccess.findService(string, string2);
        }
        RuntimeServiceMBean runtimeServiceMBean = this.getRuntimeServiceMBean(string3);
        if (runtimeServiceMBean != null) {
            return runtimeServiceMBean.findService(string, string2);
        }
        return null;
    }

    public Service[] getServices(String string) {
        if (string == null) {
            weblogic.management.provider.Service[] serviceArray = this.domainAccess.getRootServices();
            Service[] serviceArray2 = new Service[serviceArray.length];
            System.arraycopy(serviceArray, 0, serviceArray2, 0, serviceArray.length);
            return serviceArray2;
        }
        RuntimeServiceMBean runtimeServiceMBean = this.getRuntimeServiceMBean(string);
        if (runtimeServiceMBean != null) {
            return runtimeServiceMBean.getServices();
        }
        return null;
    }

    private RuntimeServiceMBean getRuntimeServiceMBean(String string) {
        RuntimeServiceMBean runtimeServiceMBean = this.runtimeServicesManager.get(string);
        return runtimeServiceMBean;
    }

    public MigratableServiceCoordinatorRuntimeMBean lookupMigratableServiceCoordinatorRuntime() {
        return ManagementService.getDomainAccess(kernelId).getMigratableServiceCoordinatorRuntime();
    }

    public MigratableServiceCoordinatorRuntimeMBean getMigratableServiceCoordinatorRuntime() {
        return ManagementService.getDomainAccess(kernelId).getMigratableServiceCoordinatorRuntime();
    }

    static {
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        try {
            RUNTIME_SERVICE = new ObjectName(RuntimeServiceMBean.OBJECT_NAME);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new Error(malformedObjectNameException);
        }
    }

    private class RuntimeServicesManager {
        private Map runtimeServicesByName = new ConcurrentHashMap();
        private RuntimeServiceMBean[] runtimeServicesArray;
        private boolean runtimeServicesArrayUptodate = true;
        private Map unresolvedConnections = new ConcurrentHashMap();

        RuntimeServicesManager() {
        }

        RuntimeServiceMBean get(String string) {
            this.checkUnresolved();
            return (RuntimeServiceMBean)this.runtimeServicesByName.get(string);
        }

        synchronized void addConnection(String string, MBeanServerConnection mBeanServerConnection) {
            if (debug.isDebugEnabled()) {
                debug.debug("Added MBeanServerConnection " + string + " " + mBeanServerConnection);
            }
            this.unresolvedConnections.put(string, mBeanServerConnection);
            this.runtimeServicesArrayUptodate = false;
        }

        synchronized void removeConnection(String string) {
            if (debug.isDebugEnabled()) {
                debug.debug("Removed MBeanServerConnection " + string);
            }
            this.runtimeServicesByName.remove(string);
            this.unresolvedConnections.remove(string);
            Collection collection = this.runtimeServicesByName.values();
            this.runtimeServicesArray = collection.toArray(new RuntimeServiceMBean[collection.size()]);
        }

        RuntimeServiceMBean[] getRuntimeServices() {
            this.checkUnresolved();
            return this.runtimeServicesArray;
        }

        private void checkUnresolved() {
            if (!this.runtimeServicesArrayUptodate) {
                this.resolve();
            }
        }

        private synchronized void resolve() {
            if (!this.runtimeServicesArrayUptodate) {
                for (Map.Entry entry : this.unresolvedConnections.entrySet()) {
                    this.resolveRuntimeServiceProxy((MBeanServerConnection)entry.getValue(), (String)entry.getKey());
                }
                Collection collection = this.runtimeServicesByName.values();
                this.runtimeServicesArray = collection.toArray(new RuntimeServiceMBean[collection.size()]);
                this.runtimeServicesArrayUptodate = true;
            }
        }

        private synchronized RuntimeServiceMBean resolveRuntimeServiceProxy(MBeanServerConnection mBeanServerConnection, String string) {
            RuntimeServiceMBean runtimeServiceMBean;
            try {
                runtimeServiceMBean = (RuntimeServiceMBean)MBeanServerInvocationHandler.newProxyInstance((MBeanServerConnection)mBeanServerConnection, (ObjectName)RUNTIME_SERVICE);
            }
            catch (Throwable throwable) {
                if (debug.isDebugEnabled()) {
                    debug.debug("Exception resolve runtime: ", throwable);
                }
                return null;
            }
            this.runtimeServicesByName.put(string, runtimeServiceMBean);
            this.unresolvedConnections.remove(string);
            return runtimeServiceMBean;
        }
    }

    private static class SINGLETON {
        private DomainMBean domainConfig = null;
        private DomainMBean domainEdit = null;
        private static SINGLETON instance = null;

        public static SINGLETON getInstance() {
            if (instance == null) {
                instance = new SINGLETON();
            }
            return instance;
        }

        private SINGLETON() {
            EditAccess editAccess = ManagementServiceRestricted.getEditAccess(kernelId);
            try {
                this.domainConfig = editAccess.getCurrentDomainBean();
                this.domainEdit = editAccess.getDomainBeanWithoutLock();
            }
            catch (EditFailedException editFailedException) {
                throw new AssertionError((Object)editFailedException);
            }
            catch (EditNotEditorException editNotEditorException) {
                throw new AssertionError((Object)editNotEditorException);
            }
        }

        public DomainMBean getDomainConfig() {
            return this.domainConfig;
        }

        public DomainMBean getDomainEdit() {
            return this.domainEdit;
        }
    }
}

